/*
 * Decompiled with CFR 0.152.
 */
package com.wily.zos.common;

import com.wily.introscope.agent.trace.InvocationData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.zos.common.InvocationContext;
import com.wily.zos.common.MetricWriter;
import com.wily.zos.common.Tracer;

public abstract class Listener {
    private IModuleFeedbackChannel feedback;
    private InvocationContext context;
    private MetricWriter metricWriter;
    private boolean initializationDone;
    private boolean startWasSuccessful;
    private long elapsedTime;

    public static Listener getInstance(Class cls, Tracer tracer, InvocationData data) throws Exception {
        Listener listener = (Listener)cls.newInstance();
        listener.initialize(tracer, data);
        return listener;
    }

    private void initialize(Tracer tracer, InvocationData data) {
        this.feedback = tracer.getFeedback();
        this.context = new InvocationContext(tracer, data);
        this.metricWriter = new MetricWriter(tracer);
        this.initializationDone = true;
    }

    protected boolean isInterested() {
        return true;
    }

    public void start(InvocationData data) {
        this.startWasSuccessful = false;
        if (!this.initializationDone) {
            return;
        }
        try {
            this.setMethodEntryData(data);
            this.handleMethodEntry(data);
            this.startWasSuccessful = true;
        }
        catch (NullPointerException nullPointerException) {}
    }

    private void setMethodEntryData(InvocationData data) {
        data.storeWallClockStartTime();
    }

    protected void handleMethodEntry(InvocationData data) {
    }

    public void finish(InvocationData data) {
        if (!this.startWasSuccessful) {
            return;
        }
        this.setMethodExitData(data);
        this.handleMethodExit(data);
    }

    private void setMethodExitData(InvocationData data) {
        this.elapsedTime = data.getWallClockElapsedTimeAsInt();
    }

    protected abstract void handleMethodExit(InvocationData var1);

    protected String getClassName() {
        return this.context.getClassName();
    }

    protected String getMethodName() {
        return this.context.getMethodName();
    }

    protected String getMethodSignature() {
        return this.context.getMethodSignature();
    }

    protected String getObjectId() {
        return this.context.getObjectId();
    }

    protected String getPbdMetricName() {
        return this.context.getPbdMetricName();
    }

    protected String getSimpleClassName() {
        return this.context.getSimpleClassName();
    }

    protected boolean classNameIs(String value) {
        return this.is(this.getClassName(), value);
    }

    protected boolean methodNameIs(String value) {
        return this.is(this.getMethodName(), value);
    }

    protected boolean methodSignatureIs(String value) {
        return this.is(this.getMethodSignature(), value);
    }

    protected boolean objectIdIs(String value) {
        return this.is(this.getObjectId(), value);
    }

    protected boolean pbdMetricNameIs(String value) {
        return this.is(this.getPbdMetricName(), value);
    }

    protected boolean simpleClassNameIs(String value) {
        return this.is(this.getSimpleClassName(), value);
    }

    protected boolean classNameContains(String value) {
        return this.contains(this.getClassName(), value);
    }

    protected boolean methodNameContains(String value) {
        return this.contains(this.getMethodName(), value);
    }

    protected boolean methodSignatureContains(String value) {
        return this.contains(this.getMethodSignature(), value);
    }

    protected boolean objectIdContains(String value) {
        return this.contains(this.getObjectId(), value);
    }

    protected boolean pbdMetricNameContains(String value) {
        return this.contains(this.getPbdMetricName(), value);
    }

    protected boolean simpleClassNameContains(String value) {
        return this.contains(this.getSimpleClassName(), value);
    }

    protected boolean classNameStartsWith(String value) {
        return this.startsWith(this.getClassName(), value);
    }

    protected boolean methodNameStartsWith(String value) {
        return this.startsWith(this.getMethodName(), value);
    }

    protected boolean methodSignatureStartsWith(String value) {
        return this.startsWith(this.getMethodSignature(), value);
    }

    protected boolean objectIdStartsWith(String value) {
        return this.startsWith(this.getObjectId(), value);
    }

    protected boolean pbdMetricNameStartsWith(String value) {
        return this.startsWith(this.getPbdMetricName(), value);
    }

    protected boolean simpleClassNameStartsWith(String value) {
        return this.startsWith(this.getSimpleClassName(), value);
    }

    private boolean is(String value, String candidate) {
        return value != null && value.equals(candidate);
    }

    private boolean contains(String value, String candidate) {
        return value != null && value.contains(candidate);
    }

    private boolean startsWith(String value, String candidate) {
        return value != null && value.startsWith(candidate);
    }

    protected long getElapsedTime() {
        return this.elapsedTime;
    }

    protected void writeLong(String metricName, long value) {
        this.metricWriter.writeLong(metricName, value);
    }

    protected void writeLongDelta(String metricName, long value) {
        this.metricWriter.writeLongDelta(metricName, value);
    }

    protected void writeInt(String metricName, int value) {
        this.metricWriter.writeInt(metricName, value);
    }

    protected void writeIntDelta(String metricName, int value) {
        this.metricWriter.writeIntDelta(metricName, value);
    }

    protected void writeString(String metricName, String value) {
        this.metricWriter.writeString(metricName, value);
    }

    protected void writeAverageResponseTime(String metricName) {
        this.metricWriter.writeAverageResponseTime(metricName, this.getElapsedTime());
    }

    protected void writeResponsesPerInterval(String metricName) {
        this.metricWriter.writeResponsesPerInterval(metricName);
    }

    protected void increment(String metricName) {
        this.metricWriter.increment(metricName);
    }

    protected void incrementInt(String metricName) {
        this.metricWriter.incrementInt(metricName);
    }

    protected void decrement(String metricName) {
        this.metricWriter.decrement(metricName);
    }

    protected void decrementInt(String metricName) {
        this.metricWriter.decrementInt(metricName);
    }

    protected void logInfo(String message) {
        this.feedback.info(message);
    }

    protected void logWarn(String message) {
        this.feedback.warn(message);
    }

    protected void logError(String message) {
        this.feedback.error(message);
    }

    protected void logDebug(String message) {
        this.feedback.debug(message);
    }
}

