/*
 * Decompiled with CFR 0.152.
 */
package com.wily.zos.tools;

import com.wily.introscope.agent.IAgent;
import com.wily.zos.tools.AgentProperties;
import com.wily.zos.tools.DebugLevel;

public final class DebugController {
    private static boolean propertiesReported = false;
    private boolean enabled;
    private DebugLevel level;
    private long commareaScale;

    public DebugController(IAgent agent) {
        AgentProperties properties = new AgentProperties(agent);
        String enabled = properties.valueWithDefault("debug.enable", "false");
        String level = properties.valueWithDefault("debug.level", "info");
        String commareaScale = properties.valueWithDefault("ctg.commarea.scale", "1");
        this.enabled = this.sanitizedEnabled(enabled);
        this.level = this.sanitizedLevel(level);
        this.commareaScale = this.sanitizedCommareaScale(commareaScale);
        this.reportPropertiesOnce();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public long commareaScale() {
        return this.commareaScale;
    }

    public void printInfo(String message) {
        this.printForLevel(message, DebugLevel.INFO);
    }

    public void printDetail(String message) {
        this.printForLevel(message, DebugLevel.DETAIL);
    }

    public void printDeep(String message) {
        this.printForLevel(message, DebugLevel.DEEP);
    }

    private boolean sanitizedEnabled(String enabled) {
        String lowercaseValue = enabled.toLowerCase();
        if (lowercaseValue.equals("true")) {
            return true;
        }
        if (lowercaseValue.equals("false")) {
            return false;
        }
        this.print("Debug enabling '" + enabled + "' is not recognized. Using " + false + ".");
        return false;
    }

    private DebugLevel sanitizedLevel(String level) {
        DebugLevel DEFAULT_LEVEL = DebugLevel.INFO;
        String lowercaseValue = level.toLowerCase();
        if (lowercaseValue.equals("info")) {
            return DebugLevel.INFO;
        }
        if (lowercaseValue.equals("detail")) {
            return DebugLevel.DETAIL;
        }
        if (lowercaseValue.equals("deep")) {
            return DebugLevel.DEEP;
        }
        this.print("Debug level '" + level + "' is not recognized. Using " + DEFAULT_LEVEL + ".");
        return DEFAULT_LEVEL;
    }

    private long sanitizedCommareaScale(String commareaScale) {
        long result;
        try {
            result = Long.parseLong(commareaScale);
        }
        catch (NumberFormatException numberFormatException) {
            this.print("Debug commarea scale '" + commareaScale + "' is not a valid number. Using " + 1L + ".");
            return 1L;
        }
        if (result >= 1L) {
            return result;
        }
        this.print("Debug commarea scale '" + commareaScale + "' isn't large enough. Using " + 1L + ".");
        return 1L;
    }

    private synchronized void reportPropertiesOnce() {
        if (!this.enabled() || propertiesReported) {
            return;
        }
        this.print("Debugging is enabled");
        this.printDetail("Debug level is " + this.level);
        this.printDetail("Commarea scale is " + this.commareaScale);
        propertiesReported = true;
    }

    private void printForLevel(String message, DebugLevel minimumLevel) {
        if (this.enabled() && this.level.isAtLeast(minimumLevel)) {
            this.print(message);
        }
    }

    private void print(String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("   ---> WILY");
        buffer.append(" : ");
        buffer.append(Thread.currentThread().getName());
        buffer.append(" : ");
        buffer.append(message);
        System.out.println(buffer.toString());
    }
}

