/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class LeafOnlyTreeSelectionModel
extends DefaultTreeSelectionModel {
    private static final long serialVersionUID = 367131020217329641L;

    public LeafOnlyTreeSelectionModel() {
        this.setSelectionMode(4);
    }

    public void setSelectionPaths(TreePath[] paths) {
        super.setSelectionPaths(this.getFilteredList(paths));
    }

    public void addSelectionPaths(TreePath[] paths) {
        super.addSelectionPaths(this.getFilteredList(paths));
    }

    private TreePath[] getFilteredList(TreePath[] originalList) {
        Object[] result;
        if (originalList == null) {
            result = originalList;
        } else {
            Vector<TreePath> bag = new Vector<TreePath>();
            for (int x = 0; x < originalList.length; ++x) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)originalList[x].getLastPathComponent();
                if (!this.allowSelection(node)) continue;
                bag.addElement(originalList[x]);
            }
            int goodElementCount = bag.size();
            if (goodElementCount > 0) {
                if (goodElementCount == originalList.length) {
                    result = originalList;
                } else {
                    result = new TreePath[goodElementCount];
                    bag.copyInto(result);
                }
            } else {
                result = null;
            }
        }
        return result;
    }

    private boolean allowSelection(DefaultMutableTreeNode node) {
        return node.isLeaf();
    }
}

