/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import com.wily.wilyassert.SwingAssertion;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public final class ListToTreeModelAdapter
extends DefaultTreeModel {
    private static final long serialVersionUID = 784584304469648999L;
    private final ListModel fListModel;

    public ListToTreeModelAdapter(ListModel model, String rootName) {
        super(new DefaultMutableTreeNode(rootName));
        this.fListModel = model;
        this.fListModel.addListDataListener(new ListToTreeNodeEventListener());
        this.addChildren();
    }

    private void addChildren() {
        SwingAssertion.assertSwingSafe();
        int numChildren = this.fListModel.getSize();
        for (int i = 0; i < numChildren; ++i) {
            this.addChildAt(i);
        }
    }

    private TreeNode addChildAt(int index) {
        SwingAssertion.assertSwingSafe();
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(this.fListModel.getElementAt(index), false);
        this.insertNodeInto(child, this.getTypedRoot(), index);
        return child;
    }

    private TreeNode removeChildAt(int index) {
        SwingAssertion.assertSwingSafe();
        TreeNode child = ((DefaultMutableTreeNode)this.getRoot()).getChildAt(index);
        this.removeNodeFromParent((DefaultMutableTreeNode)this.getTypedRoot().getChildAt(index));
        return child;
    }

    private DefaultMutableTreeNode getTypedRoot() {
        return (DefaultMutableTreeNode)this.getRoot();
    }

    protected void fireTreeNodesChanged(Object a, Object[] b, int[] c, Object[] d) {
        super.fireTreeNodesChanged(a, b, c, d);
    }

    protected void fireTreeNodesInserted(Object a, Object[] b, int[] c, Object[] d) {
        super.fireTreeNodesInserted(a, b, c, d);
    }

    protected void fireTreeNodesRemoved(Object a, Object[] b, int[] c, Object[] d) {
        super.fireTreeNodesRemoved(a, b, c, d);
    }

    protected void fireTreeStructureChanged(Object a, Object[] b, int[] c, Object[] d) {
        super.fireTreeStructureChanged(a, b, c, d);
    }

    private class ListToTreeNodeEventListener
    implements ListDataListener {
        private ListToTreeNodeEventListener() {
        }

        public void contentsChanged(ListDataEvent e) {
            SwingAssertion.assertSwingSafe();
            int intervalSize = e.getIndex1() - e.getIndex0() + 1;
            int[] childIndices = new int[intervalSize];
            Object[] children = new Object[intervalSize];
            DefaultMutableTreeNode root = ListToTreeModelAdapter.this.getTypedRoot();
            for (int i = 0; i < intervalSize; ++i) {
                childIndices[i] = e.getIndex0() + i;
                children[i] = root.getChildAt(e.getIndex0() + i);
            }
            ListToTreeModelAdapter.this.fireTreeNodesChanged(ListToTreeModelAdapter.this, root.getPath(), childIndices, children);
        }

        public void intervalAdded(ListDataEvent e) {
            SwingAssertion.assertSwingSafe();
            int start = e.getIndex0();
            int numChanged = e.getIndex1() - start + 1;
            for (int i = 0; i < numChanged; ++i) {
                ListToTreeModelAdapter.this.addChildAt(start + i);
            }
        }

        public void intervalRemoved(ListDataEvent e) {
            SwingAssertion.assertSwingSafe();
            int start = e.getIndex0();
            int numChanged = e.getIndex1() - start + 1;
            for (int i = 0; i < numChanged; ++i) {
                ListToTreeModelAdapter.this.removeChildAt(start);
            }
        }
    }
}

