/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import com.wily.properties.KUICommonStringsKeys;
import com.wily.ui.IGenericServices;
import com.wily.ui.WilyTextField;
import com.wily.util.StringUtils;
import com.wily.util.validate.ValidationException;
import com.wily.util.validate.ValidationInvalidBoundedNumberException;
import com.wily.util.validate.ValidationInvalidContentFormatException;
import com.wily.util.validate.ValidationUtilities;
import com.wily.wilyassert.Assertion;

public class WilyIntegerTextField
extends WilyTextField
implements KUICommonStringsKeys {
    private static final long serialVersionUID = 55265633284181516L;
    private static final String kWilyIntegerTextFieldContentsStateKey = "WilyIntegerTextField_Contents";
    private int fMinValue = Integer.MIN_VALUE;
    private int fMaxValue = Integer.MAX_VALUE;

    protected WilyIntegerTextField() {
        Assertion.unimplemented("Must at least specify GenericServices");
    }

    public WilyIntegerTextField(IGenericServices genericServices) {
        super(genericServices);
    }

    public WilyIntegerTextField(IGenericServices genericServices, int columns, int minValue, int maxValue) {
        super(genericServices, columns);
        this.fMinValue = minValue;
        this.fMaxValue = maxValue;
    }

    public WilyIntegerTextField(IGenericServices genericServices, int columns) {
        super(genericServices, columns);
    }

    protected String getContentsStateKey() {
        return kWilyIntegerTextFieldContentsStateKey;
    }

    public Object getObjectValue() {
        return this.getIntegerObjectValue();
    }

    public Number getNumberValue() {
        return this.getIntegerObjectValue();
    }

    public void setObjectValue(Object value) {
        Assertion.wilyAssert(value instanceof Integer);
        this.setIntegerObjectValue((Integer)value);
    }

    public Integer getIntegerObjectValue() {
        if (StringUtils.isEmpty(this.getText())) {
            return new Integer(0);
        }
        return new Integer(this.getText());
    }

    public void setIntegerObjectValue(Integer value) {
        this.setText(value.toString());
    }

    public int getIntValue() {
        return this.getIntegerObjectValue();
    }

    public void setIntValue(int value) {
        this.setText(Integer.toString(value));
    }

    public void increment() {
        this.setIntValue(this.getIntValue() + 1);
    }

    public void decrement() {
        this.setIntValue(this.getIntValue() - 1);
    }

    private void checkBounds() throws ValidationException {
        int intValue = this.getIntValue();
        if (intValue < this.fMinValue || intValue > this.fMaxValue) {
            throw new ValidationInvalidBoundedNumberException(this.fMinValue, this.fMaxValue);
        }
    }

    private void checkValueNonNegative() throws ValidationException {
        if (this.getIntValue() < 0) {
            throw new ValidationInvalidContentFormatException("Positive_Integer_Type_Name");
        }
    }

    private void checkValueNonZero() throws ValidationException {
        if (this.getIntValue() == 0) {
            throw new ValidationInvalidContentFormatException("Nonzero_Integer_Type_Name");
        }
    }

    public void IValidatable_validate(int validationConstraints) throws ValidationException {
        try {
            this.getIntValue();
        }
        catch (NumberFormatException nfe) {
            throw new ValidationInvalidBoundedNumberException(this.fMinValue, this.fMaxValue);
        }
        this.checkBounds();
        if (ValidationUtilities.validationRequiresNonNegativeNumbers(validationConstraints)) {
            this.checkValueNonNegative();
        }
        if (ValidationUtilities.validationRequiresNonZeroNumbers(validationConstraints)) {
            this.checkValueNonZero();
        }
        super.IValidatable_validate(validationConstraints);
    }
}

