/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import com.wily.properties.KUICommonStringsKeys;
import com.wily.ui.IGenericServices;
import com.wily.ui.WilyTextField;
import com.wily.util.StringUtils;
import com.wily.util.validate.ValidationException;
import com.wily.util.validate.ValidationInvalidContentFormatException;
import com.wily.util.validate.ValidationUtilities;
import com.wily.wilyassert.Assertion;

public class WilyLongTextField
extends WilyTextField
implements KUICommonStringsKeys {
    private static final long serialVersionUID = -3353447133625187945L;
    private static final String kWilyLongTextFieldContentsStateKey = "WilyLongTextField_Contents";

    private WilyLongTextField() {
        Assertion.unimplemented("Must at least specify GenericServices");
    }

    public WilyLongTextField(IGenericServices genericServices) {
        super(genericServices);
    }

    public WilyLongTextField(IGenericServices genericServices, int columns) {
        super(genericServices, columns);
    }

    protected String getContentsStateKey() {
        return kWilyLongTextFieldContentsStateKey;
    }

    public Object getObjectValue() {
        return this.getLongObjectValue();
    }

    public Number getNumberValue() {
        return this.getLongObjectValue();
    }

    public void setObjectValue(Object value) {
        Assertion.wilyAssert(value instanceof Integer);
        this.setLongObjectValue((Long)value);
    }

    public Long getLongObjectValue() {
        if (StringUtils.isEmpty(this.getText())) {
            return new Long(0L);
        }
        return new Long(this.getText());
    }

    public void setLongObjectValue(Long value) {
        this.setText(value.toString());
    }

    public void setLongValue(long value) {
        this.setText(Long.toString(value));
    }

    public long getLongValue() {
        return this.getLongObjectValue();
    }

    private void checkValueNonNegative() throws ValidationException {
        if (this.getLongValue() < 0L) {
            throw new ValidationInvalidContentFormatException("Positive_Long_Type_Name");
        }
    }

    public void IValidatable_validate(int validationConstraints) throws ValidationException {
        super.IValidatable_validate(validationConstraints);
        try {
            this.getLongValue();
        }
        catch (NumberFormatException nfe) {
            throw new ValidationInvalidContentFormatException("Long_Type_Name");
        }
        if (ValidationUtilities.validationRequiresNonNegativeNumbers(validationConstraints)) {
            this.checkValueNonNegative();
        }
    }
}

