/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import com.wily.ui.Bounds;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ZoomStack {
    private List fListeners = new ArrayList();
    private Stack fZoomOutStack = new Stack();
    private ZoomBounds fCurrentZoom = null;
    private Stack fZoomInStack = new Stack();

    public Bounds getCurrentZoom() {
        return this.fCurrentZoom == null ? null : this.fCurrentZoom.getBounds();
    }

    public boolean isCurrentZoomConstrainToTimeAxis() {
        return this.fCurrentZoom.isCurrentZoomConstrainToTimeAxis();
    }

    public void addChangeListener(ChangeListener listener) {
        this.fListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.fListeners.remove(listener);
    }

    private void notifyChangeListeners() {
        ChangeEvent event = new ChangeEvent(this);
        Iterator i = this.fListeners.iterator();
        while (i.hasNext()) {
            ChangeListener listener = (ChangeListener)i.next();
            listener.stateChanged(event);
        }
    }

    public void reset(double xMin, double xMax, double yMin, double yMax) {
        this.reset(new Bounds(xMin, xMax, yMin, yMax));
    }

    public void reset(Bounds currentZoom) {
        this.reset(new ZoomBounds(currentZoom, false));
    }

    public void reset(ZoomBounds currentZoom) {
        this.fZoomOutStack.clear();
        this.fCurrentZoom = currentZoom;
        this.fZoomInStack.clear();
        this.notifyChangeListeners();
    }

    public boolean canZoomOut() {
        return !this.fZoomOutStack.empty();
    }

    public Bounds zoomOut() {
        if (this.canZoomOut()) {
            if (this.fCurrentZoom != null) {
                this.fZoomInStack.push(this.fCurrentZoom);
            }
            this.fCurrentZoom = (ZoomBounds)this.fZoomOutStack.pop();
        }
        this.notifyChangeListeners();
        return this.fCurrentZoom.getBounds();
    }

    public Bounds zoomAllTheWayOut() {
        if (this.canZoomOut()) {
            if (this.fCurrentZoom != null) {
                this.fZoomInStack.push(this.fCurrentZoom);
                this.fCurrentZoom = null;
            }
            while (this.fCurrentZoom == null) {
                this.fCurrentZoom = (ZoomBounds)this.fZoomOutStack.pop();
                if (this.fZoomOutStack.empty()) continue;
                this.fZoomInStack.push(this.fCurrentZoom);
                this.fCurrentZoom = null;
            }
        }
        this.notifyChangeListeners();
        return this.fCurrentZoom == null ? null : this.fCurrentZoom.getBounds();
    }

    public boolean canZoomIn() {
        return !this.fZoomInStack.empty();
    }

    public Bounds peekZoomIn() {
        if (this.canZoomIn()) {
            return ((ZoomBounds)this.fZoomInStack.peek()).getBounds();
        }
        return null;
    }

    public Bounds zoomIn() {
        if (this.canZoomIn()) {
            if (this.fCurrentZoom != null) {
                this.fZoomOutStack.push(this.fCurrentZoom);
            }
            this.fCurrentZoom = (ZoomBounds)this.fZoomInStack.pop();
        }
        this.notifyChangeListeners();
        return this.fCurrentZoom == null ? null : this.fCurrentZoom.getBounds();
    }

    public void zoomTo(double xMin, double xMax, double yMin, double yMax) {
        this.zoomTo(new ZoomBounds(new Bounds(xMin, xMax, yMin, yMax), false));
    }

    public void zoomTo(ZoomBounds bounds) {
        Bounds maxBounds = this.zoomAllTheWayOut();
        this.reset(maxBounds);
        this.zoomInTo(bounds);
    }

    public void zoomInTo(double xMin, double xMax, double yMin, double yMax) {
        this.zoomInTo(xMin, xMax, yMin, yMax, false);
    }

    public void zoomInTo(double xMin, double xMax, double yMin, double yMax, boolean constrainToTimeAxis) {
        this.zoomInTo(new ZoomBounds(new Bounds(xMin, xMax, yMin, yMax), constrainToTimeAxis));
    }

    public void zoomInTo(ZoomBounds bounds) {
        if (this.canZoomIn() && bounds.equals(this.fZoomInStack.peek())) {
            this.zoomIn();
            return;
        }
        this.fZoomInStack.clear();
        if (this.fCurrentZoom != null) {
            this.fZoomOutStack.push(this.fCurrentZoom);
        }
        this.fCurrentZoom = bounds;
        this.notifyChangeListeners();
    }

    public void zoomOutTo(Bounds bounds) {
        ZoomBounds zoomBounds;
        if (this.canZoomOut() && bounds.equals(((ZoomBounds)this.fZoomOutStack.peek()).getBounds())) {
            this.zoomOut();
            return;
        }
        this.fZoomOutStack.clear();
        if (this.fCurrentZoom != null) {
            this.fZoomInStack.push(this.fCurrentZoom);
        }
        this.fCurrentZoom = zoomBounds = new ZoomBounds(bounds, false);
        this.notifyChangeListeners();
    }

    private class ZoomBounds {
        private boolean fIsCurrentZoomConstrainToTimeAxis;
        private Bounds fBounds;

        public ZoomBounds(Bounds bounds, boolean constrainToTimeAxis) {
            this.fBounds = bounds;
            this.fIsCurrentZoomConstrainToTimeAxis = constrainToTimeAxis;
        }

        public Bounds getBounds() {
            return this.fBounds;
        }

        public boolean isCurrentZoomConstrainToTimeAxis() {
            return this.fIsCurrentZoomConstrainToTimeAxis;
        }
    }
}

