/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.action;

import com.wily.ui.action.AExtendedAction;
import com.wily.ui.action.ExtendedActionException;
import com.wily.ui.action.IExtendedAction;
import com.wily.wilyassert.Assertion;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;

public abstract class AExtendedActionWrapper
extends AExtendedAction {
    private IExtendedAction fWrappedExtendedAction;
    private boolean fSyncNameAndIcon;
    private ExtendedActionPropertyChangePropogator fExtendedActionPropertyChangePropogator;
    private boolean fLastTriggerWasCancelled;

    protected AExtendedActionWrapper() {
        super(0);
        this.init(null);
    }

    protected AExtendedActionWrapper(String name) {
        super(name, 0);
        this.init(null);
    }

    protected AExtendedActionWrapper(String name, Icon icon) {
        super(name, icon, 0);
        this.init(null);
    }

    protected AExtendedActionWrapper(IExtendedAction wrappedExtendedAction) {
        super(0);
        Assertion.wilyAssert(wrappedExtendedAction != null);
        this.init(wrappedExtendedAction);
    }

    private void init(IExtendedAction wrappedExtendedAction) {
        this.setSyncNameAndIcon(wrappedExtendedAction != null);
        this.fExtendedActionPropertyChangePropogator = new ExtendedActionPropertyChangePropogator();
        this.setWrappedExtendedAction(wrappedExtendedAction);
    }

    public void setSyncNameAndIcon(boolean syncNameAndIcon) {
        this.fSyncNameAndIcon = syncNameAndIcon;
    }

    private boolean shouldSyncNameAndIcon() {
        return this.fSyncNameAndIcon;
    }

    protected void setWrappedExtendedAction(IExtendedAction wrappedExtendedAction) {
        if (this.fWrappedExtendedAction != null) {
            this.fWrappedExtendedAction.removePropertyChangeListener(this.getExtendedActionPropertyChangePropogator());
        }
        this.fWrappedExtendedAction = wrappedExtendedAction;
        if (this.fWrappedExtendedAction != null) {
            this.fWrappedExtendedAction.addPropertyChangeListener(this.getExtendedActionPropertyChangePropogator());
        }
        this.syncAppropriateProperties();
    }

    protected void tearDownWrappedExtendedAction() {
        if (this.fWrappedExtendedAction != null) {
            this.fWrappedExtendedAction.removePropertyChangeListener(this.getExtendedActionPropertyChangePropogator());
            this.fWrappedExtendedAction.IExtendedAction_tearDown();
        }
    }

    public void doTearDown() {
        this.tearDownWrappedExtendedAction();
        super.doTearDown();
    }

    protected IExtendedAction getWrappedExtendedAction() {
        return this.fWrappedExtendedAction;
    }

    public ExtendedActionPropertyChangePropogator getExtendedActionPropertyChangePropogator() {
        return this.fExtendedActionPropertyChangePropogator;
    }

    private synchronized void syncAppropriateProperties() {
        if (this.fWrappedExtendedAction != null) {
            if (this.shouldSyncNameAndIcon()) {
                this.IExtendedAction_setName(this.fWrappedExtendedAction.IExtendedAction_getName());
                this.IExtendedAction_setIcon(this.fWrappedExtendedAction.IExtendedAction_getIcon());
            }
            this.setEnabled(this.fWrappedExtendedAction.isEnabled());
            this.setActionType(this.fWrappedExtendedAction.IExtendedAction_getActionType());
            this.setIsConsumer(this.fWrappedExtendedAction.IExtendedAction_isConsumer());
            this.setIsProducer(this.fWrappedExtendedAction.IExtendedAction_isProducer());
        } else {
            this.setEnabled(false);
            this.setActionType(0);
            this.setIsConsumer(false);
            this.setIsProducer(false);
        }
    }

    protected void doTriggerAction(ActionEvent actionEvent) throws ExtendedActionException {
        Assertion.wilyAssert(this.fWrappedExtendedAction != null, "called doTrigger on a wrapping action that has no wrapped action. Action class=" + this.getClass().getName());
        if (this.fWrappedExtendedAction != null) {
            try {
                this.fWrappedExtendedAction.IExtendedAction_triggerAction(actionEvent);
                this.fLastTriggerWasCancelled = this.fWrappedExtendedAction.IExtendedAction_wasCancelled();
            }
            catch (ExtendedActionException ae) {
                throw ae.clone(this);
            }
        }
    }

    protected void doUndoAction() throws ExtendedActionException {
        Assertion.wilyAssert(this.fWrappedExtendedAction != null, "called doUndoAction on a wrapping action that has no wrapped action. Action class=" + this.getClass().getName());
        if (this.fWrappedExtendedAction != null) {
            try {
                this.fWrappedExtendedAction.IExtendedAction_undoAction();
            }
            catch (ExtendedActionException ae) {
                throw ae.clone(this);
            }
        }
    }

    protected void doRedoAction() throws ExtendedActionException {
        Assertion.wilyAssert(this.fWrappedExtendedAction != null, "called doRedoAction on a wrapping action that has no wrapped action. Action class=" + this.getClass().getName());
        if (this.fWrappedExtendedAction != null) {
            try {
                this.fWrappedExtendedAction.IExtendedAction_redoAction();
            }
            catch (ExtendedActionException ae) {
                throw ae.clone(this);
            }
        }
    }

    public boolean IExtendedAction_wasCancelled() {
        return this.fLastTriggerWasCancelled;
    }

    public Object IExtendedAction_getProduct() throws ExtendedActionException {
        Assertion.wilyAssert(this.fWrappedExtendedAction != null);
        return this.fWrappedExtendedAction.IExtendedAction_getProduct();
    }

    public void IExtendedAction_setConsumable(Object consumable) throws ExtendedActionException {
        Assertion.wilyAssert(this.fWrappedExtendedAction != null);
        this.fWrappedExtendedAction.IExtendedAction_setConsumable(consumable);
    }

    public Object clone() throws CloneNotSupportedException {
        AExtendedActionWrapper newExtendedActionWrapper = (AExtendedActionWrapper)super.clone();
        if (this.fWrappedExtendedAction != null) {
            newExtendedActionWrapper.fWrappedExtendedAction = (IExtendedAction)this.fWrappedExtendedAction.clone();
        }
        newExtendedActionWrapper.fSyncNameAndIcon = this.fSyncNameAndIcon;
        return newExtendedActionWrapper;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append("\n    Wrapped Action=").append(this.getWrappedExtendedAction().toString()).append("\n");
        return sb.toString();
    }

    private class ExtendedActionPropertyChangePropogator
    implements PropertyChangeListener {
        private ExtendedActionPropertyChangePropogator() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            AExtendedActionWrapper.this.syncAppropriateProperties();
        }
    }
}

