/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.action;

import com.wily.ui.action.AExtendedAction;
import com.wily.ui.action.ExtendedActionException;
import com.wily.ui.action.IExtendedAction;
import com.wily.ui.swing.KSwingPropertyNames;
import com.wily.util.text.ILocalizableMessage;
import com.wily.wilyassert.Assertion;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;

public class CompoundExtendedAction
extends AExtendedAction
implements KSwingPropertyNames {
    private static final long serialVersionUID = -4157474234880523795L;
    private Vector fActions;
    private Vector fPassiveActions;
    private Vector fTriggeredActions;
    private boolean fForceUnenabled;
    private PropertyChangeListener fPropertyPropogator;
    private boolean fShareEnabledState;
    private static final boolean kDefaultShareEnabledState = true;

    public CompoundExtendedAction() {
        this(true);
    }

    public CompoundExtendedAction(String name) {
        this(name, true);
    }

    public CompoundExtendedAction(String name, Icon icon) {
        this(name, icon, true);
    }

    public CompoundExtendedAction(boolean shareDisabledState) {
        super(0);
        this.init(shareDisabledState);
    }

    public CompoundExtendedAction(String name, boolean shareDisabledState) {
        super(name, 0);
        this.init(shareDisabledState);
    }

    public CompoundExtendedAction(String name, Icon icon, boolean shareDisabledState) {
        super(name, icon, 0);
        this.init(shareDisabledState);
    }

    private void init(boolean shareDisabledState) {
        this.fShareEnabledState = shareDisabledState;
        this.fForceUnenabled = false;
        this.fActions = new Vector();
        this.fPassiveActions = new Vector();
        this.fTriggeredActions = new Vector();
        this.fPropertyPropogator = new PropertyPropogator();
        this.syncStates();
    }

    public void addPassiveExtendedAction(IExtendedAction action) {
        this.fPassiveActions.add(action);
        action.addPropertyChangeListener(this.fPropertyPropogator);
        this.syncStates();
    }

    public void addExtendedAction(IExtendedAction action) {
        Assertion.wilyAssert(action != null);
        this.addExtendedAction(action, -1);
    }

    public void addExtendedAction(IExtendedAction action, int index) {
        Assertion.wilyAssert(action != null);
        if (index == -1) {
            index = this.fActions.size();
        }
        this.fActions.insertElementAt(action, index);
        int startIndex = index == 0 ? index : index - 1;
        int stopIndex = index == this.fActions.size() - 1 ? index : index + 1;
        this.validateActionChain(startIndex, stopIndex);
        action.addPropertyChangeListener(this.fPropertyPropogator);
        this.syncStates();
    }

    public void removeExtendedAction(int index) {
        IExtendedAction action = (IExtendedAction)this.fActions.remove(index);
        int startIndex = index == 0 ? index : index - 1;
        int stopIndex = index == this.fActions.size() ? index - 1 : index;
        this.validateActionChain(startIndex, stopIndex);
        action.removePropertyChangeListener(this.fPropertyPropogator);
        this.syncStates();
    }

    public void removePassiveExtendedAction(IExtendedAction action) {
        this.fPassiveActions.remove(action);
        action.removePropertyChangeListener(this.fPropertyPropogator);
        this.syncStates();
    }

    public int getExtendedActionCount() {
        return this.fActions.size();
    }

    public void IExtendedAction_setConsumable(Object consumable) throws ExtendedActionException {
        IExtendedAction firstAction = (IExtendedAction)this.fActions.firstElement();
        firstAction.IExtendedAction_setConsumable(consumable);
    }

    public Object IExtendedAction_getProduct() throws ExtendedActionException {
        IExtendedAction lastAction = (IExtendedAction)this.fActions.lastElement();
        return lastAction.IExtendedAction_getProduct();
    }

    public void doTearDown() {
        this.doTheTearDown(this.fActions);
        this.doTheTearDown(this.fPassiveActions);
    }

    private void doTheTearDown(Vector actions) {
        Enumeration actionsEnum = actions.elements();
        while (actionsEnum.hasMoreElements()) {
            IExtendedAction anAction = (IExtendedAction)actionsEnum.nextElement();
            anAction.IExtendedAction_tearDown();
            anAction.removePropertyChangeListener(this.fPropertyPropogator);
        }
    }

    private void validateActionChain(int start, int end) {
        if (end > start) {
            for (int i = start + 1; i <= end; ++i) {
                IExtendedAction previousAction = (IExtendedAction)this.fActions.elementAt(i - 1);
                IExtendedAction currentAction = (IExtendedAction)this.fActions.elementAt(i);
                if (!currentAction.IExtendedAction_isConsumer() || previousAction.IExtendedAction_isProducer()) continue;
                throw new IllegalArgumentException("Command #" + (i - 1) + " does not produce anything " + "for the consuming action that follows. Compound: " + this.toString() + " supposedProducer: " + previousAction.toString());
            }
        }
    }

    public void doTriggerAction(ActionEvent actionEvent) throws ExtendedActionException {
        try {
            this.fTriggeredActions.clear();
            this.triggerChainedActions(actionEvent);
        }
        catch (ExtendedActionException ae) {
            this.throwExceptionWithCompoundMessage(ae, 10);
        }
    }

    public void doUndoAction() throws ExtendedActionException {
        try {
            this.undoChainedActions();
        }
        catch (ExtendedActionException ae) {
            this.throwExceptionWithCompoundMessage(ae, 11);
        }
    }

    public void doRedoAction() throws ExtendedActionException {
        try {
            this.redoChainedActions();
        }
        catch (ExtendedActionException ae) {
            this.throwExceptionWithCompoundMessage(ae, 12);
        }
    }

    protected void triggerChainedActions(ActionEvent actionEvent) throws ExtendedActionException {
        for (int i = 0; i < this.fActions.size(); ++i) {
            IExtendedAction nextAction;
            IExtendedAction action = (IExtendedAction)this.fActions.elementAt(i);
            if (!this.fShareEnabledState && !action.isEnabled()) continue;
            action.IExtendedAction_triggerAction(actionEvent);
            if (action.IExtendedAction_wasCancelled()) {
                this.setCancelled(true);
                if (this.IExtendedAction_getActionType() != 2) {
                    this.undoChainedActions();
                }
                return;
            }
            this.fTriggeredActions.add(action);
            if (!action.IExtendedAction_isProducer() || i == this.fActions.size() - 1 || !(nextAction = (IExtendedAction)this.fActions.elementAt(i + 1)).IExtendedAction_isConsumer()) continue;
            Object product = action.IExtendedAction_getProduct();
            nextAction.IExtendedAction_setConsumable(product);
        }
    }

    protected void undoChainedActions() throws ExtendedActionException {
        for (int i = this.fTriggeredActions.size() - 1; i >= 0; --i) {
            IExtendedAction action = (IExtendedAction)this.fTriggeredActions.elementAt(i);
            int actionType = action.IExtendedAction_getActionType();
            Assertion.wilyAssert(actionType != 2, "undoChainedAction() shouldn't be called when the compound action is destructive");
            if (actionType != 1) continue;
            action.IExtendedAction_undoAction();
        }
    }

    protected void redoChainedActions() throws ExtendedActionException {
        for (int i = 0; i < this.fTriggeredActions.size(); ++i) {
            IExtendedAction nextAction;
            IExtendedAction action = (IExtendedAction)this.fTriggeredActions.elementAt(i);
            int actionType = action.IExtendedAction_getActionType();
            Assertion.wilyAssert(actionType != 2, "redoChainedActions shouldn't be called when the compound action is destructive");
            if (actionType == 1) {
                action.IExtendedAction_redoAction();
            }
            if (!action.IExtendedAction_isProducer() || i == this.fTriggeredActions.size() - 1 || !(nextAction = (IExtendedAction)this.fTriggeredActions.elementAt(i + 1)).IExtendedAction_isConsumer()) continue;
            Object product = action.IExtendedAction_getProduct();
            nextAction.IExtendedAction_setConsumable(product);
        }
    }

    public void setEnabled(boolean enabled) {
        this.fForceUnenabled = !enabled;
        this.syncEnabledState();
    }

    private void syncStates() {
        this.syncEnabledState();
        this.syncActionTypeState();
        this.syncIsConsumerState();
        this.syncIsProducerState();
    }

    private void syncEnabledState() {
        if (this.fShareEnabledState) {
            this.syncSharedEnabledState();
        } else {
            this.syncUnsharedEnabledState();
        }
    }

    private void syncSharedEnabledState() {
        boolean enabled = true;
        if (this.fForceUnenabled) {
            enabled = false;
        } else {
            int i;
            for (i = 0; i < this.fActions.size() && enabled; ++i) {
                enabled = ((Action)this.fActions.elementAt(i)).isEnabled();
            }
            for (i = 0; i < this.fPassiveActions.size() && enabled; ++i) {
                enabled = ((Action)this.fPassiveActions.elementAt(i)).isEnabled();
            }
        }
        super.setEnabled(enabled);
    }

    private void syncUnsharedEnabledState() {
        boolean enabled = false;
        if (!this.fForceUnenabled) {
            int i;
            for (i = 0; i < this.fActions.size() && !enabled; ++i) {
                enabled = ((Action)this.fActions.elementAt(i)).isEnabled();
            }
            for (i = 0; i < this.fPassiveActions.size() && !enabled; ++i) {
                enabled = ((Action)this.fPassiveActions.elementAt(i)).isEnabled();
            }
        }
        super.setEnabled(enabled);
    }

    private void syncActionTypeState() {
        int compoundActionType = 0;
        for (int i = 0; i < this.fActions.size() && compoundActionType != 2; ++i) {
            IExtendedAction action = (IExtendedAction)this.fActions.elementAt(i);
            int componentActionType = action.IExtendedAction_getActionType();
            if (componentActionType == 2) {
                compoundActionType = 2;
                continue;
            }
            if (componentActionType != 1) continue;
            compoundActionType = 1;
        }
        this.setActionType(compoundActionType);
    }

    private void syncIsConsumerState() {
        if (this.fActions.size() == 0) {
            this.setIsConsumer(false);
        } else {
            this.setIsConsumer(((IExtendedAction)this.fActions.firstElement()).IExtendedAction_isConsumer());
        }
    }

    private void syncIsProducerState() {
        if (this.fActions.size() == 0) {
            this.setIsProducer(false);
        } else {
            this.setIsProducer(((IExtendedAction)this.fActions.lastElement()).IExtendedAction_isProducer());
        }
    }

    private void throwExceptionWithCompoundMessage(ExtendedActionException ae, int whichVerb) throws ExtendedActionException {
        ILocalizableMessage compoundUserMessage = ae.ILocalizableException_getLocalizableMessage();
        String compoundExceptionMessage = "CompoundExtendedAction.trigger failed: " + ae.getMessage();
        throw new ExtendedActionException(this, ae, compoundExceptionMessage, compoundUserMessage, whichVerb);
    }

    public Object clone() throws CloneNotSupportedException {
        CompoundExtendedAction newCompoundExtendedAction = (CompoundExtendedAction)super.clone();
        newCompoundExtendedAction.fShareEnabledState = this.fShareEnabledState;
        newCompoundExtendedAction.fForceUnenabled = this.fForceUnenabled;
        newCompoundExtendedAction.fTriggeredActions = new Vector();
        newCompoundExtendedAction.fActions = new Vector();
        Enumeration myActions = this.fActions.elements();
        while (myActions.hasMoreElements()) {
            IExtendedAction anAction = (IExtendedAction)myActions.nextElement();
            IExtendedAction clonedAction = (IExtendedAction)anAction.clone();
            newCompoundExtendedAction.addExtendedAction(clonedAction);
            if (!this.fTriggeredActions.contains(anAction)) continue;
            newCompoundExtendedAction.fTriggeredActions.add(clonedAction);
        }
        newCompoundExtendedAction.fPassiveActions = new Vector();
        Enumeration myPassiveActions = this.fPassiveActions.elements();
        while (myPassiveActions.hasMoreElements()) {
            IExtendedAction anAction = (IExtendedAction)myPassiveActions.nextElement();
            IExtendedAction clonedAction = (IExtendedAction)anAction.clone();
            newCompoundExtendedAction.addPassiveExtendedAction(clonedAction);
        }
        return newCompoundExtendedAction;
    }

    public String toString() {
        return "(CompoundExtendedAction ACTIONS: " + this.actionsToString() + "TRIGGERED ACTIONS: " + this.triggeredActionsToString() + "PASSIVE ACTIONS: " + this.passiveActionsToString() + ") ";
    }

    private String actionsToString() {
        return this.vectorToString(this.fActions);
    }

    private String triggeredActionsToString() {
        return this.vectorToString(this.fTriggeredActions);
    }

    private String passiveActionsToString() {
        return this.vectorToString(this.fPassiveActions);
    }

    private String vectorToString(Vector v) {
        Enumeration actions = v.elements();
        String result = "";
        int j = 0;
        while (actions.hasMoreElements()) {
            IExtendedAction action = (IExtendedAction)actions.nextElement();
            result = result + "([" + j + "] " + action + ") ";
            ++j;
        }
        return result;
    }

    private class PropertyPropogator
    implements PropertyChangeListener {
        private PropertyPropogator() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            CompoundExtendedAction.this.syncStates();
        }
    }
}

