/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.mouse;

import com.wily.wilyassert.Assertion;
import com.wily.wilyassert.SwingAssertion;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseListener;

public class MouseListenerPropagator {
    private MouseListenerPropagator() {
    }

    public static void propagateMouseListenerPropagator(Component topComponent, MouseListener mouseListener) {
        SwingAssertion.assertSwingSafe();
        Assertion.wilyAssert(topComponent != null);
        if (!MouseListenerPropagator.propagatorAlreadyAdded(topComponent, mouseListener)) {
            topComponent.addMouseListener(mouseListener);
        }
        if (topComponent instanceof Container) {
            Container parentContainer = (Container)topComponent;
            int childCount = parentContainer.getComponentCount();
            Component[] children = parentContainer.getComponents();
            for (int i = 0; i < childCount; ++i) {
                MouseListenerPropagator.propagateMouseListenerPropagator(children[i], mouseListener);
            }
        }
    }

    protected static boolean propagatorAlreadyAdded(Component component, MouseListener mouseListener) {
        boolean exists = false;
        MouseListener[] listeners = (MouseListener[])component.getListeners(MouseListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != mouseListener) continue;
            exists = true;
            break;
        }
        return exists;
    }
}

