/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.selection;

import com.wily.ui.action.IExtendedAction;
import com.wily.ui.selection.Selection;
import com.wily.wilyassert.Assertion;
import java.util.HashSet;
import java.util.Set;

public abstract class ASelectable {
    private String fSelectableType;
    private ASelectable fParentSelectable;
    private final Set fChildSelectables;
    private final Object fUserObject;

    protected ASelectable(String selectableType, Object userObject) {
        this.fSelectableType = selectableType;
        this.fUserObject = userObject;
        this.fParentSelectable = null;
        this.fChildSelectables = new HashSet();
    }

    public final String getSelectableType() {
        return this.fSelectableType;
    }

    public final ASelectable getParentSelectable() {
        return this.fParentSelectable;
    }

    public final Selection getChildSelectables() {
        return new Selection(this.fChildSelectables);
    }

    public int getNumberChildren() {
        return this.fChildSelectables.size();
    }

    public boolean hasProperty(String propertyKey) {
        return this.getProperty(propertyKey) != null;
    }

    public abstract Object getProperty(String var1);

    public abstract boolean hasAction(String var1);

    public abstract IExtendedAction getAction(String var1);

    public final Object getUserObject() {
        return this.fUserObject;
    }

    final void addChildSelectable(ASelectable childSelectable) {
        Assertion.wilyAssert(childSelectable.getParentSelectable() == null);
        if (this.getParentSelectable() == null) {
            this.internalAddChildSelectable(childSelectable);
            childSelectable.internalSetParentSelectable(this);
        }
    }

    private final void internalSetParentSelectable(ASelectable parentSelectable) {
        this.fParentSelectable = parentSelectable;
    }

    private final void internalAddChildSelectable(ASelectable childSelectable) {
        this.fChildSelectables.add(childSelectable);
    }

    public String toString() {
        String userObjectName = "null";
        Object obj = this.getUserObject();
        if (obj != null) {
            userObjectName = obj.getClass().getName();
        }
        return this.getClass().getName() + ": selectableType = " + this.getSelectableType() + ", userObjectClass = " + userObjectName;
    }
}

