/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.wilyassert.Assertion;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;

public class DelegatingTreeCellRenderer
implements TreeCellRenderer {
    private TreeCellRenderer fDefaultTreeCellRenderer;
    private HashMap fSubTreeToTreeCellRendererMap;

    public DelegatingTreeCellRenderer(TreeCellRenderer defaultTreeCellRenderer) {
        this.fDefaultTreeCellRenderer = defaultTreeCellRenderer;
        this.fSubTreeToTreeCellRendererMap = new HashMap();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean isLeaf, int row, boolean hasFocus) {
        Assertion.wilyAssert(value instanceof TreeNode, "DelegatingTreeCellRenderer can only be used with nodes implementing javax.swing.tree.TreeNode");
        return this.getTreeCellRendererForNode((TreeNode)value).getTreeCellRendererComponent(tree, value, selected, expanded, isLeaf, row, hasFocus);
    }

    public void delegateTreeCellRendererForSubtree(TreeNode subTreeRootNode, TreeCellRenderer treeCellRenderer) {
        this.fSubTreeToTreeCellRendererMap.put(subTreeRootNode, treeCellRenderer);
    }

    private TreeCellRenderer getTreeCellRendererForNode(TreeNode treeNode) {
        TreeCellRenderer treeCellRenderer = this.getSubTreeCellRenderer(treeNode);
        if (treeCellRenderer == null) {
            treeCellRenderer = treeNode.getParent() == null ? this.fDefaultTreeCellRenderer : this.getTreeCellRendererForNode(treeNode.getParent());
        }
        return treeCellRenderer;
    }

    private TreeCellRenderer getSubTreeCellRenderer(TreeNode subTree) {
        return (TreeCellRenderer)this.fSubTreeToTreeCellRendererMap.get(subTree);
    }
}

