/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.ui.swing.WilyButtonComboBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboPopup;
import sun.awt.AppContext;

public abstract class WilyButtonComboBoxUI
extends ComboBoxUI {
    protected WilyButtonComboBox comboBox;
    protected boolean hasFocus = false;
    private boolean isTableCellEditor = false;
    private static final String IS_TABLE_CELL_EDITOR = "JComboBox.isTableCellEditor";
    protected JList listBox;
    protected CellRendererPane currentValuePane = new CellRendererPane();
    protected WilyButtonComboPopup popup;
    protected Component mainButton;
    protected JButton arrowButton;
    protected KeyListener keyListener;
    protected FocusListener focusListener;
    protected PropertyChangeListener propertyChangeListener;
    private FocusListener mainButtonFocusListener;
    private ActionListener mainButtonActionListener;
    private MouseListener mainButtonMouseListener;
    protected ItemListener itemListener;
    protected MouseListener popupMouseListener;
    protected MouseMotionListener popupMouseMotionListener;
    protected KeyListener popupKeyListener;
    protected ListDataListener listDataListener;
    protected boolean isMinimumSizeDirty = true;
    protected Dimension cachedMinimumSize = new Dimension(0, 0);
    protected boolean isDisplaySizeDirty = true;
    private Dimension cachedDisplaySize = new Dimension(0, 0);
    private static final Object COMBO_UI_LIST_CELL_RENDERER_KEY = new StringBuffer("DefaultListCellRendererKey");
    static Action homeAction = new NavigationalAction(36);
    static Action endAction = new NavigationalAction(35);
    static Action pgUpAction = new NavigationalAction(33);
    static Action pgDownAction = new NavigationalAction(34);

    private static ListCellRenderer getDefaultListCellRenderer() {
        ListCellRenderer renderer = (ListCellRenderer)AppContext.getAppContext().get(COMBO_UI_LIST_CELL_RENDERER_KEY);
        if (renderer == null) {
            renderer = new DefaultListCellRenderer();
            AppContext.getAppContext().put(COMBO_UI_LIST_CELL_RENDERER_KEY, new DefaultListCellRenderer());
        }
        return renderer;
    }

    public void installUI(JComponent c) {
        this.isMinimumSizeDirty = true;
        this.comboBox = (WilyButtonComboBox)c;
        this.installDefaults();
        this.popup = this.createPopup();
        this.listBox = this.popup.getList();
        Boolean inTable = (Boolean)c.getClientProperty(IS_TABLE_CELL_EDITOR);
        if (inTable != null) {
            boolean bl = this.isTableCellEditor = inTable.equals(Boolean.TRUE);
        }
        if (this.comboBox.getRenderer() == null || this.comboBox.getRenderer() instanceof UIResource) {
            this.comboBox.setRenderer(this.createRenderer());
        }
        this.installListeners();
        this.installComponents();
        this.comboBox.setLayout(this.createLayoutManager());
        this.comboBox.setRequestFocusEnabled(true);
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent c) {
        this.setPopupVisible((JComboBox)this.comboBox, false);
        this.popup.uninstallingUI();
        this.uninstallKeyboardActions();
        this.comboBox.setLayout(null);
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        if (this.comboBox.getRenderer() == null || this.comboBox.getRenderer() instanceof UIResource) {
            this.comboBox.setRenderer(null);
        }
        this.keyListener = null;
        this.focusListener = null;
        this.listDataListener = null;
        this.propertyChangeListener = null;
        this.mainButtonActionListener = null;
        this.mainButtonMouseListener = null;
        this.mainButtonFocusListener = null;
        this.popup = null;
        this.listBox = null;
        this.comboBox = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.comboBox, "ComboBox.background", "ComboBox.foreground", "ComboBox.font");
        this.comboBox.setBorder(null);
    }

    protected void installListeners() {
        this.itemListener = this.createItemListener();
        if (this.itemListener != null) {
            this.comboBox.addItemListener(this.itemListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener()) != null) {
            this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.comboBox.addKeyListener(this.keyListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.comboBox.addFocusListener(this.focusListener);
        }
        if ((this.popupMouseListener = this.popup.getMouseListener()) != null) {
            this.comboBox.addMouseListener(this.popupMouseListener);
        }
        if ((this.popupMouseMotionListener = this.popup.getMouseMotionListener()) != null) {
            this.comboBox.addMouseMotionListener(this.popupMouseMotionListener);
        }
        if ((this.popupKeyListener = this.popup.getKeyListener()) != null) {
            this.comboBox.addKeyListener(this.popupKeyListener);
        }
        if (this.comboBox.getModel() != null && (this.listDataListener = this.createListDataListener()) != null) {
            this.comboBox.getModel().addListDataListener(this.listDataListener);
        }
    }

    protected void uninstallDefaults() {
        LookAndFeel.installColorsAndFont(this.comboBox, "ComboBox.background", "ComboBox.foreground", "ComboBox.font");
        LookAndFeel.uninstallBorder(this.comboBox);
    }

    protected void uninstallListeners() {
        if (this.keyListener != null) {
            this.comboBox.removeKeyListener(this.keyListener);
        }
        if (this.itemListener != null) {
            this.comboBox.removeItemListener(this.itemListener);
        }
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.focusListener != null) {
            this.comboBox.removeFocusListener(this.focusListener);
        }
        if (this.popupMouseListener != null) {
            this.comboBox.removeMouseListener(this.popupMouseListener);
        }
        if (this.popupMouseMotionListener != null) {
            this.comboBox.removeMouseMotionListener(this.popupMouseMotionListener);
        }
        if (this.popupKeyListener != null) {
            this.comboBox.removeKeyListener(this.popupKeyListener);
        }
        if (this.comboBox.getModel() != null && this.listDataListener != null) {
            this.comboBox.getModel().removeListDataListener(this.listDataListener);
        }
    }

    protected WilyButtonComboPopup createPopup() {
        WilyButtonComboPopup popup = new WilyButtonComboPopup(this.comboBox);
        popup.getAccessibleContext().setAccessibleParent(this.comboBox);
        return popup;
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ListDataListener createListDataListener() {
        return new ListDataHandler();
    }

    protected ItemListener createItemListener() {
        return null;
    }

    protected abstract PropertyChangeListener createPropertyChangeListener();

    protected LayoutManager createLayoutManager() {
        return new ComboBoxLayoutManager();
    }

    protected ListCellRenderer createRenderer() {
        return new BasicComboBoxRenderer.UIResource();
    }

    protected ComboBoxEditor createEditor() {
        return new BasicComboBoxEditor.UIResource();
    }

    protected void updateToolTipTextForChildren() {
        Component[] children = this.comboBox.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof JComponent)) continue;
            ((JComponent)children[i]).setToolTipText(this.comboBox.getToolTipText());
        }
    }

    protected int getArrowButtonWidth() {
        return 15;
    }

    public void layoutComboBox(Container parent, ComboBoxLayoutManager manager) {
        if (this.comboBox.isEditable()) {
            manager.superLayout(parent);
        } else if (this.arrowButton != null) {
            Insets insets = this.comboBox.getInsets();
            int width = this.comboBox.getWidth();
            int height = this.comboBox.getHeight();
            this.arrowButton.setBounds(insets.left, insets.top, width - (insets.left + insets.right), height - (insets.top + insets.bottom));
        }
    }

    public static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    protected void installComponents() {
        this.arrowButton = this.createArrowButton();
        this.comboBox.add(this.arrowButton);
        if (this.arrowButton != null) {
            this.configureArrowButton();
        }
        this.addMainButton();
        this.comboBox.add(this.currentValuePane);
    }

    protected void uninstallComponents() {
        if (this.arrowButton != null) {
            this.unconfigureArrowButton();
            this.comboBox.remove(this.arrowButton);
        }
        if (this.mainButton != null) {
            this.removeMainButton();
        }
        this.comboBox.removeAll();
        this.mainButton = null;
        this.arrowButton = null;
    }

    public void addMainButton() {
        this.removeMainButton();
        this.mainButton = this.comboBox.getButton();
        if (this.mainButton != null) {
            this.configureMainButton();
            this.comboBox.add(this.mainButton);
        }
    }

    public void removeMainButton() {
        if (this.mainButton != null) {
            this.unconfigureMainButton();
            this.comboBox.remove(this.mainButton);
            this.mainButton = null;
        }
    }

    protected void configureMainButton() {
        AccessibleContext ac;
        this.mainButton.setEnabled(this.comboBox.isEnabled());
        this.mainButton.setFont(this.comboBox.getFont());
        if (this.mainButton instanceof Accessible && (ac = ((Accessible)((Object)this.mainButton)).getAccessibleContext()) != null) {
            ac.setAccessibleParent(this.comboBox);
        }
        if (this.focusListener != null) {
            this.mainButton.addFocusListener(this.focusListener);
        }
        if (this.mainButtonFocusListener == null) {
            this.mainButtonFocusListener = new MainButtonFocusListener();
        }
        this.mainButton.addFocusListener(this.mainButtonFocusListener);
        if (this.mainButtonActionListener == null) {
            this.mainButtonActionListener = new MainButtonActionListener();
        }
        this.comboBox.getButton().addActionListener(this.mainButtonActionListener);
        if (this.mainButtonMouseListener == null) {
            this.mainButtonMouseListener = new MainButtonMouseListener();
        }
        this.mainButton.addMouseListener(this.mainButtonMouseListener);
    }

    protected void unconfigureMainButton() {
        if (this.focusListener != null) {
            this.mainButton.removeFocusListener(this.focusListener);
        }
        if (this.mainButtonFocusListener != null) {
            this.mainButton.removeFocusListener(this.mainButtonFocusListener);
        }
        if (this.mainButtonActionListener != null) {
            this.comboBox.getButton().removeActionListener(this.mainButtonActionListener);
        }
        if (this.mainButtonMouseListener != null) {
            this.mainButton.removeMouseListener(this.mainButtonMouseListener);
        }
    }

    public void configureArrowButton() {
        if (this.arrowButton != null) {
            this.arrowButton.setEnabled(this.comboBox.isEnabled());
            this.arrowButton.setRequestFocusEnabled(false);
            this.arrowButton.addMouseListener(this.popup.getMouseListener());
            this.arrowButton.addMouseMotionListener(this.popup.getMouseMotionListener());
            this.arrowButton.resetKeyboardActions();
        }
    }

    public void unconfigureArrowButton() {
        if (this.arrowButton != null) {
            this.arrowButton.removeMouseListener(this.popup.getMouseListener());
            this.arrowButton.removeMouseMotionListener(this.popup.getMouseMotionListener());
        }
    }

    protected abstract JButton createArrowButton();

    public boolean isPopupVisible(JComboBox c) {
        return this.popup.isVisible();
    }

    public void setPopupVisible(JComboBox c, boolean v) {
        if (v) {
            this.popup.show();
        } else {
            this.popup.hide();
        }
    }

    public boolean isFocusTraversable(JComboBox c) {
        return false;
    }

    public void paint(Graphics g, JComponent c) {
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension size = this.getDisplaySize();
        if (this.arrowButton != null) {
            size.width += this.getArrowButtonWidth();
        }
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(size);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public int getAccessibleChildrenCount(JComponent c) {
        return 2;
    }

    public Accessible getAccessibleChild(JComponent c, int i) {
        switch (i) {
            case 0: {
                if (!(this.popup instanceof Accessible)) break;
                AccessibleContext ac = this.popup.getAccessibleContext();
                ac.setAccessibleParent(this.comboBox);
                return this.popup;
            }
            case 1: {
                if (!(this.mainButton instanceof Accessible)) break;
                AccessibleContext ac = ((Accessible)((Object)this.mainButton)).getAccessibleContext();
                ac.setAccessibleParent(this.comboBox);
                return (Accessible)((Object)this.mainButton);
            }
        }
        return null;
    }

    protected boolean isNavigationKey(int keyCode) {
        return keyCode == 38 || keyCode == 40 || keyCode == KeyStroke.getKeyStroke("KP_UP").getKeyCode() || keyCode == KeyStroke.getKeyStroke("KP_DOWN").getKeyCode();
    }

    protected void selectNextPossibleValue() {
        int si = this.isTableCellEditor ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
        if (si < this.comboBox.getModel().getSize() - 1) {
            if (this.isTableCellEditor) {
                this.listBox.setSelectedIndex(si + 1);
                this.listBox.ensureIndexIsVisible(si + 1);
            } else {
                this.comboBox.setSelectedIndex(si + 1);
            }
            this.comboBox.repaint();
        }
    }

    protected void selectPreviousPossibleValue() {
        int si = this.isTableCellEditor ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
        if (si > 0) {
            if (this.isTableCellEditor) {
                this.listBox.setSelectedIndex(si - 1);
                this.listBox.ensureIndexIsVisible(si - 1);
            } else {
                this.comboBox.setSelectedIndex(si - 1);
            }
            this.comboBox.repaint();
        }
    }

    protected void toggleOpenClose() {
        this.setPopupVisible((JComboBox)this.comboBox, !this.isPopupVisible((JComboBox)this.comboBox));
    }

    protected Rectangle rectangleForCurrentValue() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int buttonSize = height - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            buttonSize = this.arrowButton.getWidth();
        }
        if (WilyButtonComboBoxUI.isLeftToRight(this.comboBox)) {
            return new Rectangle(insets.left, insets.top, width - (insets.left + insets.right + buttonSize), height - (insets.top + insets.bottom));
        }
        return new Rectangle(insets.left + buttonSize, insets.top, width - (insets.left + insets.right + buttonSize), height - (insets.top + insets.bottom));
    }

    protected Insets getInsets() {
        return this.comboBox.getInsets();
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        Component c;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        if (hasFocus && !this.isPopupVisible((JComboBox)this.comboBox)) {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            c.setBackground(UIManager.getColor("ComboBox.background"));
        }
        c.setFont(this.comboBox.getFont());
        if (hasFocus && !this.isPopupVisible((JComboBox)this.comboBox)) {
            c.setForeground(this.listBox.getSelectionForeground());
            c.setBackground(this.listBox.getSelectionBackground());
        } else if (this.comboBox.isEnabled()) {
            c.setForeground(this.comboBox.getForeground());
            c.setBackground(this.comboBox.getBackground());
        } else {
            c.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            c.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        this.currentValuePane.paintComponent(g, c, this.comboBox, bounds.x, bounds.y, bounds.width, bounds.height, shouldValidate);
    }

    protected Dimension getDefaultSize() {
        Component c = WilyButtonComboBoxUI.getDefaultListCellRenderer().getListCellRendererComponent(this.listBox, " ", -1, false, false);
        this.currentValuePane.add(c);
        c.setFont(this.comboBox.getFont());
        Dimension d = c.getPreferredSize();
        this.currentValuePane.remove(c);
        return new Dimension(d.width, d.height);
    }

    public int getPopupWidth() {
        DefaultListCellRenderer renderer = this.comboBox.getRenderer();
        if (renderer == null) {
            renderer = new DefaultListCellRenderer();
        }
        ComboBoxModel model = this.comboBox.getModel();
        int modelSize = model.getSize();
        int bestWidth = 0;
        if (modelSize > 0) {
            for (int i = 0; i < modelSize; ++i) {
                Component cpn = renderer.getListCellRendererComponent(this.listBox, model.getElementAt(i), -1, false, false);
                this.currentValuePane.add(cpn);
                cpn.setFont(this.comboBox.getFont());
                Dimension d = cpn.getPreferredSize();
                this.currentValuePane.remove(cpn);
                bestWidth = Math.max(bestWidth, d.width);
            }
        } else {
            bestWidth = this.getDefaultSize().width;
            if (this.comboBox.isEditable()) {
                bestWidth = 100;
            }
        }
        return bestWidth;
    }

    protected Dimension getDisplaySize() {
        if (!this.isDisplaySizeDirty) {
            return new Dimension(this.cachedDisplaySize);
        }
        Dimension result = new Dimension();
        result = this.mainButton.getPreferredSize();
        this.cachedDisplaySize.setSize(result.width, result.height);
        this.isDisplaySizeDirty = false;
        return result;
    }

    protected void installKeyboardActions() {
        InputMap km = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.comboBox, 1, km);
        ActionMap am = this.getActionMap();
        if (am != null) {
            SwingUtilities.replaceUIActionMap(this.comboBox, am);
        }
    }

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)UIManager.get("ComboBox.ancestorInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        return this.createActionMap();
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("hidePopup", new HidePopupAction());
        map.put("pageDownPassThrough", pgDownAction);
        map.put("pageUpPassThrough", pgUpAction);
        map.put("homePassThrough", homeAction);
        map.put("endPassThrough", endAction);
        map.put("selectNext", new DownAction());
        map.put("togglePopup", new AltAction());
        map.put("selectPrevious", new UpAction());
        map.put("enterPressed", new EnterAction());
        return map;
    }

    boolean isTableCellEditor() {
        return this.isTableCellEditor;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.comboBox, 1, null);
        SwingUtilities.replaceUIActionMap(this.comboBox, null);
    }

    protected static class ArrowIcon
    implements Icon,
    Serializable {
        private static final long serialVersionUID = 1292982574721313035L;
        private Color shadow = UIManager.getColor("ComboBox.buttonShadow");
        private Color darkShadow = UIManager.getColor("ComboBox.buttonDarkShadow");
        private Color highlight = UIManager.getColor("ComboBox.buttonHighlight");

        public int getIconWidth() {
            return 5;
        }

        public int getIconHeight() {
            int iconHeight = (int)Math.ceil((double)this.getIconWidth() / 2.0);
            return iconHeight;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color oldColor = g.getColor();
            JComponent component = (JComponent)c;
            int iconWidth = this.getIconWidth();
            int iconHeight = this.getIconHeight();
            g.translate(x, y);
            if (!component.isEnabled()) {
                g.translate(1, 1);
                g.setColor(this.highlight);
                this.drawTriangle(g, iconWidth, iconHeight);
                g.translate(-1, -1);
            }
            g.setColor(component.isEnabled() ? this.darkShadow : this.shadow);
            this.drawTriangle(g, iconWidth, iconHeight);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }

        private void drawTriangle(Graphics g, int iconWidth, int iconHeight) {
            for (int i = 0; i < iconHeight; ++i) {
                g.drawLine(i, i, i + (iconWidth - (2 * i + 1)), i);
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            JComboBox comboBox = (JComboBox)e.getSource();
            if (propertyName.equals("model")) {
                ComboBoxModel newModel = (ComboBoxModel)e.getNewValue();
                ComboBoxModel oldModel = (ComboBoxModel)e.getOldValue();
                if (oldModel != null && WilyButtonComboBoxUI.this.listDataListener != null) {
                    oldModel.removeListDataListener(WilyButtonComboBoxUI.this.listDataListener);
                }
                if (newModel != null && WilyButtonComboBoxUI.this.listDataListener != null) {
                    newModel.addListDataListener(WilyButtonComboBoxUI.this.listDataListener);
                }
                WilyButtonComboBoxUI.this.isMinimumSizeDirty = true;
                WilyButtonComboBoxUI.this.isDisplaySizeDirty = true;
                comboBox.revalidate();
                comboBox.repaint();
            } else if (propertyName.equals("button")) {
                WilyButtonComboBoxUI.this.addMainButton();
                comboBox.revalidate();
            } else if (propertyName.equals("editable")) {
                comboBox.repaint();
            } else if (propertyName.equals("enabled")) {
                boolean enabled = comboBox.isEnabled();
                if (WilyButtonComboBoxUI.this.mainButton != null) {
                    WilyButtonComboBoxUI.this.mainButton.setEnabled(enabled);
                }
                if (WilyButtonComboBoxUI.this.arrowButton != null) {
                    WilyButtonComboBoxUI.this.arrowButton.setEnabled(enabled);
                }
                comboBox.repaint();
            } else if (propertyName.equals("maximumRowCount")) {
                if (WilyButtonComboBoxUI.this.isPopupVisible(comboBox)) {
                    WilyButtonComboBoxUI.this.setPopupVisible(comboBox, false);
                    WilyButtonComboBoxUI.this.setPopupVisible(comboBox, true);
                }
            } else if (propertyName.equals("font")) {
                WilyButtonComboBoxUI.this.listBox.setFont(comboBox.getFont());
                if (WilyButtonComboBoxUI.this.mainButton != null) {
                    WilyButtonComboBoxUI.this.mainButton.setFont(comboBox.getFont());
                }
                WilyButtonComboBoxUI.this.isMinimumSizeDirty = true;
                comboBox.validate();
            } else if (propertyName.equals("ToolTipText")) {
                WilyButtonComboBoxUI.this.updateToolTipTextForChildren();
            } else if (propertyName.equals(WilyButtonComboBoxUI.IS_TABLE_CELL_EDITOR)) {
                Boolean inTable = (Boolean)e.getNewValue();
                WilyButtonComboBoxUI.this.isTableCellEditor = inTable.equals(Boolean.TRUE);
            } else if (propertyName.equals("prototypeDisplayValue")) {
                WilyButtonComboBoxUI.this.isMinimumSizeDirty = true;
                WilyButtonComboBoxUI.this.isDisplaySizeDirty = true;
                comboBox.revalidate();
            } else if (propertyName.equals("renderer")) {
                WilyButtonComboBoxUI.this.isMinimumSizeDirty = true;
                WilyButtonComboBoxUI.this.isDisplaySizeDirty = true;
                comboBox.revalidate();
            } else if (propertyName.equals("background")) {
                Color color = (Color)e.getNewValue();
                WilyButtonComboBoxUI.this.arrowButton.setBackground(color);
                WilyButtonComboBoxUI.this.listBox.setBackground(color);
            } else if (propertyName.equals("foreground")) {
                Color color = (Color)e.getNewValue();
                WilyButtonComboBoxUI.this.arrowButton.setForeground(color);
                WilyButtonComboBoxUI.this.listBox.setForeground(color);
            }
        }
    }

    class MainButtonMouseListener
    extends MouseAdapter {
        MainButtonMouseListener() {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (!WilyButtonComboBoxUI.this.popup.isVisible()) {
                    WilyButtonComboBoxUI.this.popup.showAtLocation(e.getPoint());
                }
            } else {
                WilyButtonComboBoxUI.this.popup.hide();
            }
        }
    }

    private class WilyButtonComboPopup
    extends BasicComboPopup {
        private static final long serialVersionUID = 1030392401491286344L;
        protected boolean inRightClickShow;

        public WilyButtonComboPopup(JComboBox comboBox) {
            super(comboBox);
            this.inRightClickShow = false;
        }

        protected MouseListener createListMouseListener() {
            return new BasicComboPopup.ListMouseHandler(){

                public void mouseReleased(MouseEvent anEvent) {
                    int selectedIndex = WilyButtonComboPopup.this.list.getSelectedIndex();
                    WilyButtonComboPopup.this.comboBox.setPopupVisible(false);
                    WilyButtonComboPopup.this.comboBox.setSelectedIndex(selectedIndex);
                }
            };
        }

        protected MouseListener createMouseListener() {
            return new BasicComboPopup.InvocationMouseHandler(){

                public void mousePressed(MouseEvent e) {
                    if (!SwingUtilities.isLeftMouseButton(e) || !WilyButtonComboPopup.this.comboBox.isEnabled()) {
                        return;
                    }
                    if (WilyButtonComboPopup.this.comboBox.isEditable()) {
                        JButton comp = ((WilyButtonComboPopup)WilyButtonComboPopup.this).WilyButtonComboBoxUI.this.comboBox.getButton();
                        if (!(comp instanceof JComponent) || ((JComponent)comp).isRequestFocusEnabled()) {
                            ((Component)comp).requestFocus();
                        }
                    } else if (WilyButtonComboPopup.this.comboBox.isRequestFocusEnabled()) {
                        WilyButtonComboPopup.this.comboBox.requestFocus();
                    }
                    WilyButtonComboPopup.this.togglePopup();
                }

                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        if (!WilyButtonComboPopup.this.isVisible()) {
                            Point popupLocation = new Point(e.getPoint());
                            Object source = e.getSource();
                            if (source.equals(((WilyButtonComboPopup)WilyButtonComboPopup.this).WilyButtonComboBoxUI.this.arrowButton) && ((WilyButtonComboPopup)WilyButtonComboPopup.this).WilyButtonComboBoxUI.this.mainButton != null) {
                                popupLocation.x += ((WilyButtonComboPopup)WilyButtonComboPopup.this).WilyButtonComboBoxUI.this.arrowButton.getLocation().x - ((WilyButtonComboPopup)WilyButtonComboPopup.this).WilyButtonComboBoxUI.this.mainButton.getLocation().x;
                            }
                            WilyButtonComboPopup.this.showAtLocation(popupLocation);
                        }
                        return;
                    }
                    Component source = (Component)e.getSource();
                    Dimension size = source.getSize();
                    Rectangle bounds = new Rectangle(0, 0, size.width - 1, size.height - 1);
                    if (!bounds.contains(e.getPoint())) {
                        MouseEvent newEvent = WilyButtonComboPopup.this.convertMouseEvent(e);
                        Point location = newEvent.getPoint();
                        Rectangle r = new Rectangle();
                        WilyButtonComboPopup.this.list.computeVisibleRect(r);
                        WilyButtonComboPopup.this.comboBox.setPopupVisible(false);
                        if (r.contains(location)) {
                            WilyButtonComboPopup.this.comboBox.setSelectedIndex(WilyButtonComboPopup.this.list.getSelectedIndex());
                        }
                    }
                    WilyButtonComboPopup.this.hasEntered = false;
                    WilyButtonComboPopup.this.stopAutoScrolling();
                }
            };
        }

        protected void delegateFocus(MouseEvent e) {
            if (this.comboBox.isEditable()) {
                JButton comp = WilyButtonComboBoxUI.this.comboBox.getButton();
                if (!(comp instanceof JComponent) || ((JComponent)comp).isRequestFocusEnabled()) {
                    ((Component)comp).requestFocus();
                }
            } else if (this.comboBox.isRequestFocusEnabled()) {
                this.comboBox.requestFocus();
            }
        }

        public void show() {
            this.showAtLocation(new Point(0, this.comboBox.getBounds().height));
        }

        public void showAtLocation(Point preferredPopupLocation) {
            WilyButtonComboBoxUI.this.comboBox.getWilyButtonComboBoxModel().aboutToPopupComboBox();
            int selectedIndex = this.comboBox.getSelectedIndex();
            if (selectedIndex == -1) {
                this.list.clearSelection();
            } else {
                this.list.setSelectedIndex(selectedIndex);
                this.list.ensureIndexIsVisible(selectedIndex);
            }
            Point location = this.getPopupLocation(preferredPopupLocation);
            this.show(this.comboBox, location.x, location.y);
        }

        public void showForRightClick() {
            this.inRightClickShow = true;
            this.show();
        }

        public void hide() {
            super.hide();
        }

        private Point getPopupLocation(Point preferredPopupLocation) {
            Dimension popupSize = this.comboBox.getSize();
            int popupWidth = WilyButtonComboBoxUI.this.getPopupWidth();
            int maximumRowCount = this.comboBox.getMaximumRowCount();
            int itemCount = this.comboBox.getItemCount();
            if (itemCount > maximumRowCount) {
                int widthScrollbar = this.scroller.getVerticalScrollBar().getWidth();
                popupWidth += widthScrollbar;
            }
            popupSize.setSize(popupWidth, this.getPopupHeightForRowCount(maximumRowCount));
            Rectangle popupBounds = this.computePopupBounds(preferredPopupLocation.x, preferredPopupLocation.y, popupSize.width, popupSize.height);
            Dimension scrollSize = popupBounds.getSize();
            Point popupLocation = popupBounds.getLocation();
            this.scroller.setMaximumSize(scrollSize);
            this.scroller.setPreferredSize(scrollSize);
            this.scroller.setMinimumSize(scrollSize);
            this.list.revalidate();
            return popupLocation;
        }
    }

    public class NoRightBorder
    implements Border {
        Border fOrigBorder;

        NoRightBorder(Border border) {
            this.fOrigBorder = border;
        }

        public Border getOriginalBorder() {
            return this.fOrigBorder;
        }

        public Insets getBorderInsets(Component c) {
            Insets insets = this.fOrigBorder.getBorderInsets(c);
            insets.right -= 2;
            return insets;
        }

        public boolean isBorderOpaque() {
            return this.fOrigBorder.isBorderOpaque();
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.fOrigBorder.paintBorder(c, g, x, y, width + 2, height);
        }
    }

    class MainButtonActionListener
    implements ActionListener {
        MainButtonActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
        }
    }

    class MainButtonFocusListener
    extends FocusAdapter {
        MainButtonFocusListener() {
        }

        public void focusLost(FocusEvent e) {
        }
    }

    static class UpAction
    extends AbstractAction {
        private static final long serialVersionUID = 332893975823624974L;

        UpAction() {
        }

        public void actionPerformed(ActionEvent e) {
            WilyButtonComboBoxUI ui;
            JComboBox comboBox = (JComboBox)e.getSource();
            if (comboBox.isEnabled() && (ui = (WilyButtonComboBoxUI)comboBox.getUI()).isPopupVisible(comboBox)) {
                ui.selectPreviousPossibleValue();
            }
        }
    }

    static class AltAction
    extends AbstractAction {
        private static final long serialVersionUID = 6635557210371071318L;

        AltAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            if (comboBox.isEnabled()) {
                WilyButtonComboBoxUI ui = (WilyButtonComboBoxUI)comboBox.getUI();
                if (ui.isTableCellEditor()) {
                    comboBox.setSelectedIndex(ui.popup.getList().getSelectedIndex());
                } else {
                    comboBox.setPopupVisible(!comboBox.isPopupVisible());
                }
            }
        }
    }

    class EnterAction
    extends AbstractAction {
        private static final long serialVersionUID = -6851656676638547805L;

        EnterAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            if (!comboBox.isEnabled()) {
                return;
            }
            WilyButtonComboBoxUI ui = (WilyButtonComboBoxUI)comboBox.getUI();
            if (ui.isTableCellEditor()) {
                comboBox.setSelectedIndex(ui.popup.getList().getSelectedIndex());
            } else if (comboBox.isPopupVisible()) {
                comboBox.setPopupVisible(false);
                ((WilyButtonComboBox)comboBox).resetSelectedIndex();
            } else {
                JRootPane root = SwingUtilities.getRootPane(comboBox);
                if (root != null) {
                    Action action;
                    Object obj;
                    InputMap im = root.getInputMap(2);
                    ActionMap am = root.getActionMap();
                    if (im != null && am != null && (obj = im.get(KeyStroke.getKeyStroke(10, 0))) != null && (action = am.get(obj)) != null) {
                        action.actionPerformed(e);
                    }
                }
            }
        }
    }

    static class DownAction
    extends AbstractAction {
        private static final long serialVersionUID = 8110606557418281766L;

        DownAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            if (comboBox.isEnabled() && comboBox.isShowing()) {
                if (comboBox.isPopupVisible()) {
                    WilyButtonComboBoxUI ui = (WilyButtonComboBoxUI)comboBox.getUI();
                    ui.selectNextPossibleValue();
                } else {
                    comboBox.setPopupVisible(true);
                }
            }
        }
    }

    static class NavigationalAction
    extends AbstractAction {
        private static final long serialVersionUID = -4665571046851427309L;
        int keyCode;

        NavigationalAction(int keyCode) {
            this.keyCode = keyCode;
        }

        public void actionPerformed(ActionEvent ev) {
            JComboBox comboBox = (JComboBox)ev.getSource();
            int index = this.getNextIndex(comboBox);
            if (index >= 0 && index < comboBox.getItemCount()) {
                comboBox.setSelectedIndex(index);
            }
        }

        int getNextIndex(JComboBox comboBox) {
            switch (this.keyCode) {
                case 33: {
                    int listHeight = comboBox.getMaximumRowCount();
                    int index = comboBox.getSelectedIndex() - listHeight;
                    return index < 0 ? 0 : index;
                }
                case 34: {
                    int listHeight = comboBox.getMaximumRowCount();
                    int index = comboBox.getSelectedIndex() + listHeight;
                    int max = comboBox.getItemCount();
                    return index < max ? index : max - 1;
                }
                case 36: {
                    return 0;
                }
                case 35: {
                    return comboBox.getItemCount() - 1;
                }
            }
            return comboBox.getSelectedIndex();
        }
    }

    class HidePopupAction
    extends AbstractAction {
        private static final long serialVersionUID = -1781378379651396946L;

        HidePopupAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            if (comboBox.isEnabled()) {
                comboBox.setPopupVisible(false);
            }
        }

        public boolean isEnabled() {
            return WilyButtonComboBoxUI.this.comboBox.isPopupVisible();
        }
    }

    public class ComboBoxLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        public void layoutContainer(Container parent) {
            WilyButtonComboBoxUI.this.layoutComboBox(parent, this);
        }

        public void superLayout(Container parent) {
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = WilyButtonComboBoxUI.this.getInsets();
            int buttonHeight = height - (insets.top + insets.bottom);
            int buttonWidth = WilyButtonComboBoxUI.this.getArrowButtonWidth();
            if (WilyButtonComboBoxUI.this.arrowButton != null) {
                if (WilyButtonComboBoxUI.isLeftToRight(cb)) {
                    WilyButtonComboBoxUI.this.arrowButton.setBounds(width - (insets.right + buttonWidth), insets.top, buttonWidth, buttonHeight);
                } else {
                    WilyButtonComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, buttonWidth, buttonHeight);
                }
            }
            if (WilyButtonComboBoxUI.this.mainButton != null) {
                Rectangle cvb = WilyButtonComboBoxUI.this.rectangleForCurrentValue();
                WilyButtonComboBoxUI.this.mainButton.setBounds(cvb);
            }
        }
    }

    public class ItemHandler
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        public void contentsChanged(ListDataEvent e) {
            if (e.getIndex0() != -1 || e.getIndex1() != -1) {
                WilyButtonComboBoxUI.this.isMinimumSizeDirty = true;
                WilyButtonComboBoxUI.this.comboBox.revalidate();
            }
            WilyButtonComboBoxUI.this.comboBox.repaint();
        }

        public void intervalAdded(ListDataEvent e) {
            WilyButtonComboBoxUI.this.isDisplaySizeDirty = true;
            this.contentsChanged(e);
        }

        public void intervalRemoved(ListDataEvent e) {
            WilyButtonComboBoxUI.this.isDisplaySizeDirty = true;
            this.contentsChanged(e);
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent e) {
            AccessibleContext ac;
            WilyButtonComboBoxUI.this.hasFocus = true;
            WilyButtonComboBoxUI.this.comboBox.repaint();
            if (WilyButtonComboBoxUI.this.comboBox instanceof Accessible && (ac = WilyButtonComboBoxUI.this.comboBox.getAccessibleContext()) != null) {
                ac.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }
        }

        public void focusLost(FocusEvent e) {
            AccessibleContext ac;
            WilyButtonComboBoxUI.this.hasFocus = false;
            if (!e.isTemporary() && WilyButtonComboBoxUI.this.comboBox.isLightWeightPopupEnabled()) {
                WilyButtonComboBoxUI.this.setPopupVisible((JComboBox)WilyButtonComboBoxUI.this.comboBox, false);
            }
            WilyButtonComboBoxUI.this.comboBox.repaint();
            if (WilyButtonComboBoxUI.this.comboBox instanceof Accessible && (ac = WilyButtonComboBoxUI.this.comboBox.getAccessibleContext()) != null) {
                ac.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }
        }
    }

    public class KeyHandler
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            if (WilyButtonComboBoxUI.this.comboBox.isEnabled() && !WilyButtonComboBoxUI.this.isNavigationKey(e.getKeyCode()) && this.isTypeAheadKey(e) && WilyButtonComboBoxUI.this.comboBox.selectWithKeyChar(e.getKeyChar())) {
                e.consume();
            }
        }

        boolean isTypeAheadKey(KeyEvent e) {
            return !e.isAltDown() && !e.isControlDown() && !e.isMetaDown();
        }
    }
}

