/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.properties.KUICommonStringsKeys;
import com.wily.ui.IGenericServices;
import com.wily.ui.OverriddenGenericServices;
import com.wily.ui.WilyUIUtilities;
import com.wily.ui.action.ADestructiveExtendedAction;
import com.wily.ui.action.ExtendedActionMonitor;
import com.wily.ui.action.IExtendedAction;
import com.wily.ui.action.TextEditActionBroker;
import com.wily.ui.selection.SelectionBroker;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class WilyJDialog
implements KUICommonStringsKeys {
    private IGenericServices fGenericServices;
    private JDialog fSurrogateJDialog;
    private Component fParentComponent;
    private int fPositioningFlags;
    private boolean fAllowCloseRequest;
    public static final int kCenterOnParentComponent = 0;
    public static final int kCenterOnOwningWindow = 1;
    public static final int kCenterOnScreen = 2;
    public static final int kDefaultPositioning = 1;

    public WilyJDialog(IGenericServices genericServices, Component parentComponent) {
        this(genericServices, parentComponent, null, false, 1);
    }

    public WilyJDialog(IGenericServices genericServices, Component parentComponent, int positioningFlags) {
        this(genericServices, parentComponent, null, false, positioningFlags);
    }

    public WilyJDialog(IGenericServices genericServices, Component parentComponent, String title) {
        this(genericServices, parentComponent, title, false, 1);
    }

    public WilyJDialog(IGenericServices genericServices, Component parentComponent, String title, int positioningFlags) {
        this(genericServices, parentComponent, title, false, positioningFlags);
    }

    public WilyJDialog(IGenericServices genericServices, Component parentComponent, boolean modal) {
        this(genericServices, parentComponent, null, modal, 1);
    }

    public WilyJDialog(IGenericServices genericServices, Component parentComponent, boolean modal, int positioningFlags) {
        this(genericServices, parentComponent, null, modal, positioningFlags);
    }

    public WilyJDialog(IGenericServices genericServices, Component parentComponent, String title, boolean modal) {
        this(genericServices, parentComponent, title, modal, 1);
    }

    public WilyJDialog(IGenericServices genericServices, Component parentComponent, String title, boolean modal, int positioningFlags) {
        this.commonInitialize(genericServices, parentComponent, positioningFlags);
        this.createAndInitSurrogateJDialog(title, modal);
    }

    public WilyJDialog(IGenericServices genericServices, Component parentComponent, JDialog surrogateJDialog, int positioningFlags) {
        this.commonInitialize(genericServices, parentComponent, positioningFlags);
        this.initSurrogateJDialog(surrogateJDialog);
    }

    private void commonInitialize(IGenericServices genericServices, Component parentComponent, int positioningFlags) {
        ExtendedActionMonitor actionMonitor = new ExtendedActionMonitor(genericServices.IGenericServices_getStringLocalizer());
        SelectionBroker selectionBroker = new SelectionBroker();
        TextEditActionBroker textEditActionBroker = new TextEditActionBroker(genericServices, actionMonitor);
        this.fGenericServices = new OverriddenGenericServices(genericServices, actionMonitor, selectionBroker, textEditActionBroker);
        this.fParentComponent = parentComponent;
        this.fPositioningFlags = positioningFlags;
        this.fAllowCloseRequest = true;
        if (this.fParentComponent == null) {
            this.fPositioningFlags = 2;
        }
    }

    protected IGenericServices getGenericServices() {
        return this.fGenericServices;
    }

    protected IStringLocalizer getStringLocalizer() {
        return this.getGenericServices().IGenericServices_getStringLocalizer();
    }

    protected IModuleFeedbackChannel getModuleFeedback() {
        return this.getGenericServices().IGenericServices_getModuleFeedback();
    }

    protected ExtendedActionMonitor getActionMonitor() {
        return this.getGenericServices().IGenericServices_getExtendedActionMonitor();
    }

    protected JDialog getSurrogateDialog() {
        return this.fSurrogateJDialog;
    }

    protected Component getParentComponent() {
        return this.fParentComponent;
    }

    private void createAndInitSurrogateJDialog(String title, boolean modal) {
        Window owningWindow = null;
        SurrogateJDialog surrogateJDialog = null;
        if (this.fParentComponent != null) {
            owningWindow = (Window)SwingUtilities.getRoot(this.fParentComponent);
        }
        surrogateJDialog = owningWindow instanceof Frame ? new SurrogateJDialog((Frame)owningWindow, title, modal) : (owningWindow instanceof Dialog ? new SurrogateJDialog((Dialog)owningWindow, title, modal) : new SurrogateJDialog((Frame)null, title, modal));
        this.initSurrogateJDialog(surrogateJDialog);
    }

    private void initSurrogateJDialog(JDialog surrogateJDialog) {
        this.fSurrogateJDialog = surrogateJDialog;
        WilyUIUtilities.registerLocalizedKeyboardAction(this.getRootPane(), this.getActionMonitor().getUndoAction(), "Undo_Accelerator", 2, this.getStringLocalizer());
        WilyUIUtilities.registerLocalizedKeyboardAction(this.getRootPane(), this.getActionMonitor().getRedoAction(), "Redo_Accelerator", 2, this.getStringLocalizer());
        WilyUIUtilities.autoDeselectMenuOnWindowDeactivation(surrogateJDialog);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                WilyJDialog.this.respondToCloseRequest();
            }
        });
    }

    private void positionSurrogateDialog() {
        Assertion.wilyAssert(this.fPositioningFlags == 0 || this.fPositioningFlags == 1 || this.fPositioningFlags == 2);
        switch (this.fPositioningFlags) {
            case 0: {
                this.fSurrogateJDialog.setLocationRelativeTo(this.fParentComponent);
                break;
            }
            case 1: {
                Window owningWindow = (Window)SwingUtilities.getRoot(this.fParentComponent);
                this.fSurrogateJDialog.setLocationRelativeTo(owningWindow);
                break;
            }
            case 2: {
                WilyUIUtilities.centerWindowOnScreen(this.fSurrogateJDialog);
                break;
            }
            default: {
                Assertion.wilyAssert(false, "unknown dialog centering option");
            }
        }
    }

    public void show() {
        this.positionSurrogateDialog();
        this.fSurrogateJDialog.show();
        this.fixBug4189244();
    }

    public boolean isShowing() {
        Assertion.wilyAssert(this.fSurrogateJDialog != null);
        return this.fSurrogateJDialog.isShowing();
    }

    public int getWidth() {
        return this.fSurrogateJDialog.getWidth();
    }

    public int getHeight() {
        return this.fSurrogateJDialog.getHeight();
    }

    public Point getLocation() {
        return this.fSurrogateJDialog.getLocation();
    }

    public Dimension getSize() {
        return this.fSurrogateJDialog.getSize();
    }

    public JRootPane getRootPane() {
        return this.fSurrogateJDialog.getRootPane();
    }

    public void pack() {
        this.fSurrogateJDialog.pack();
    }

    public void hide() {
        this.fSurrogateJDialog.hide();
    }

    public void setContentPane(Container contentPane) {
        this.fSurrogateJDialog.setContentPane(contentPane);
    }

    public Container getContentPane() {
        return this.fSurrogateJDialog.getContentPane();
    }

    public void setVisible(boolean visible) {
        this.fSurrogateJDialog.setVisible(visible);
    }

    public void setTitle(String title) {
        this.fSurrogateJDialog.setTitle(title);
    }

    public String getTitle() {
        return this.fSurrogateJDialog.getTitle();
    }

    public void setDefaultCloseOperation(int operation) {
        this.fSurrogateJDialog.setDefaultCloseOperation(operation);
    }

    public void addWindowListener(WindowListener l) {
        this.fSurrogateJDialog.addWindowListener(l);
    }

    public void addMouseListener(MouseListener l) {
        this.fSurrogateJDialog.addMouseListener(l);
    }

    public void setResizable(boolean resizable) {
        this.fSurrogateJDialog.setResizable(resizable);
    }

    public void setSize(Dimension d) {
        this.fSurrogateJDialog.setSize(d);
    }

    public void dispose() {
        this.fSurrogateJDialog.dispose();
    }

    public Dimension getPreferredSize() {
        return this.fSurrogateJDialog.getPreferredSize();
    }

    public void setLocation(int x, int y) {
        this.fSurrogateJDialog.setLocation(x, y);
    }

    public void validate() {
        this.fSurrogateJDialog.validate();
    }

    public void setDefaultButton(JButton defaultButton) {
        this.fSurrogateJDialog.getRootPane().setDefaultButton(defaultButton);
    }

    public JButton getDefaultButton() {
        return this.fSurrogateJDialog.getRootPane().getDefaultButton();
    }

    public static Object showInputDialog(IGenericServices genericServices, Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) {
        JOptionPane pane = new JOptionPane(message, messageType, 2, icon, null, null);
        WilyJDialog.adjustPreferredSize(pane);
        pane.setWantsInput(true);
        pane.setSelectionValues(selectionValues);
        pane.setInitialSelectionValue(initialSelectionValue);
        WilyJDialog dialog = new WilyJDialog(genericServices, parentComponent, pane.createDialog(parentComponent, title), 1);
        pane.selectInitialValue();
        dialog.show();
        Object value = pane.getInputValue();
        if (value == JOptionPane.UNINITIALIZED_VALUE) {
            return null;
        }
        return value;
    }

    public static String showInputDialog(IGenericServices genericServices, Component parentComponent, Object message, String title, int messageType) {
        return (String)WilyJDialog.showInputDialog(genericServices, parentComponent, message, title, messageType, null, null, null);
    }

    public static String showInputDialog(IGenericServices genericServices, Component parentComponent, Object message) {
        return WilyJDialog.showInputDialog(genericServices, parentComponent, message, "Input", 3);
    }

    public static int showOptionDialog(IGenericServices genericServices, Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue, int positioningFlags) {
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon, options, initialValue);
        WilyJDialog.adjustPreferredSize(pane);
        pane.setInitialValue(initialValue);
        WilyJDialog dialog = new WilyJDialog(genericServices, parentComponent, pane.createDialog(parentComponent, title), positioningFlags);
        pane.selectInitialValue();
        dialog.show();
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            return counter;
        }
        return -1;
    }

    public static int showOptionDialog(IGenericServices genericServices, Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) {
        return WilyJDialog.showOptionDialog(genericServices, parentComponent, message, title, optionType, messageType, icon, options, initialValue, 1);
    }

    public static int showConfirmDialog(IGenericServices genericServices, Component parentComponent, Object message, String title, int optionType, int messageType, int positioningFlags) {
        return WilyJDialog.showConfirmDialog(genericServices, parentComponent, message, title, optionType, messageType, null, positioningFlags);
    }

    public static int showConfirmDialog(IGenericServices genericServices, Component parentComponent, Object message, String title, int optionType, int messageType) {
        return WilyJDialog.showConfirmDialog(genericServices, parentComponent, message, title, optionType, messageType, null, 1);
    }

    public static int showConfirmDialog(IGenericServices genericServices, Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, int positioingFlags) {
        return WilyJDialog.showOptionDialog(genericServices, parentComponent, message, title, optionType, messageType, icon, null, null, positioingFlags);
    }

    public static int showConfirmDialog(IGenericServices genericServices, Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon) {
        return WilyJDialog.showConfirmDialog(genericServices, parentComponent, message, title, optionType, messageType, icon, 1);
    }

    public static void showMessageDialog(IGenericServices genericServices, Component parentComponent, Object message, String title, int messageType, Icon icon) {
        WilyJDialog.showOptionDialog(genericServices, parentComponent, message, title, -1, messageType, icon, null, null);
    }

    public static void showMessageDialog(IGenericServices genericServices, Component parentComponent, Object message, String title, int messageType) {
        WilyJDialog.showMessageDialog(genericServices, parentComponent, message, title, messageType, null);
    }

    private void fixBug4189244() {
        if (JPopupMenu.getDefaultLightWeightPopupEnabled()) {
            this.repaintOwningWindow();
        } else {
            this.repaintOwningWindowMenuBar();
        }
    }

    private void repaintOwningWindowMenuBar() {
        JFrame owningJFrame;
        JMenuBar jMenuBar;
        Window owningWindow = (Window)SwingUtilities.getRoot(this.fParentComponent);
        if (owningWindow instanceof Frame) {
            this.repaintOwningWindow();
        } else if (owningWindow instanceof JFrame && (jMenuBar = (owningJFrame = (JFrame)owningWindow).getJMenuBar()) != null) {
            jMenuBar.invalidate();
            jMenuBar.repaint();
        }
    }

    private void repaintOwningWindow() {
        Window owningWindow = (Window)SwingUtilities.getRoot(this.fParentComponent);
        if (owningWindow == null) {
            return;
        }
        owningWindow.invalidate();
        owningWindow.repaint();
    }

    private static void adjustPreferredSize(JOptionPane pane) {
        Dimension prefSize = pane.getPreferredSize();
        prefSize.width += 5;
        prefSize.height += 2;
        pane.setPreferredSize(prefSize);
    }

    private final void standardClose() {
        ExtendedActionMonitor monitor = this.fGenericServices.IGenericServices_getExtendedActionMonitor();
        monitor.tearDownActionMonitor();
        this.doStandardClose();
    }

    protected void doStandardClose() {
        this.setVisible(false);
        this.dispose();
    }

    public void setAllowCloseRequest(boolean allowCloseRequest) {
        this.fAllowCloseRequest = allowCloseRequest;
    }

    private boolean allowCloseRequest() {
        return this.fAllowCloseRequest;
    }

    private final void respondToCloseRequest() {
        if (this.allowCloseRequest()) {
            this.doRespondToCloseRequest();
        }
    }

    protected void doRespondToCloseRequest() {
        this.standardClose();
    }

    public final void programmaticallyRequestClose() {
        this.respondToCloseRequest();
    }

    public final void programmaticallyForceClose() {
        this.standardClose();
    }

    public final IExtendedAction getAtomicCloseAction() {
        return new CloseAction();
    }

    public final IExtendedAction getMonitoredReportingCloseAction(JComponent parentComponent) {
        return WilyUIUtilities.makeMonitoredReportingAction(this.getAtomicCloseAction(), this.getGenericServices(), parentComponent);
    }

    private class CloseAction
    extends ADestructiveExtendedAction {
        private static final long serialVersionUID = 5624295826421154174L;

        public CloseAction() {
            super(WilyJDialog.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Close"));
        }

        protected void doTriggerAction(ActionEvent actionEvent) {
            WilyJDialog.this.programmaticallyRequestClose();
        }
    }

    public class SurrogateJDialog
    extends JDialog {
        private static final long serialVersionUID = 1678702614910299513L;

        public SurrogateJDialog(Frame owningWindow, String title, boolean modal) {
            super(owningWindow, title, modal);
            this.initialize();
        }

        public SurrogateJDialog(Dialog owningWindow, String title, boolean modal) {
            super(owningWindow, title, modal);
            this.initialize();
        }

        private void initialize() {
            super.setDefaultCloseOperation(0);
        }

        public WilyJDialog getWilyJDialog() {
            return WilyJDialog.this;
        }

        public final void setDefaultCloseOperation(int operation) {
            Assertion.unimplemented("Subclasses of WilyJDialog should use standardClose() and/or doRespondToCloseRequest()");
            super.setDefaultCloseOperation(0);
        }
    }
}

