/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.ui.swing.SearchableComboBox;
import com.wily.ui.swing.WilySearchableComboBoxUI;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ComboBoxModel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalComboBoxEditor;

public class WilySearchableComboBoxEditor
extends MetalComboBoxEditor {
    protected WilySearchableComboBoxUI fComboboxUI;

    public WilySearchableComboBoxEditor(WilySearchableComboBoxUI comboboxUI) {
        this.fComboboxUI = comboboxUI;
        this.editor = new KTextField("", 9);
        this.editor.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                WilySearchableComboBoxEditor.this.handleKeyEvent(e);
            }
        });
    }

    protected boolean isNavigationKey(int keyCode) {
        return keyCode == 38 || keyCode == 40 || keyCode == KeyStroke.getKeyStroke("KP_UP").getKeyCode() || keyCode == KeyStroke.getKeyStroke("KP_DOWN").getKeyCode();
    }

    protected boolean isEnterKey(int keyCode) {
        return keyCode == 10 || keyCode == 27 || keyCode == KeyStroke.getKeyStroke("ENTER").getKeyCode() || keyCode == KeyStroke.getKeyStroke("ESCAPE").getKeyCode();
    }

    private void handleKeyEvent(KeyEvent e) {
        if (e.getModifiers() != 0) {
            return;
        }
        char keyChar = e.getKeyChar();
        if (keyChar != '\n' && keyChar != '\u001b') {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ComboBoxModel model = WilySearchableComboBoxEditor.this.fComboboxUI.getComboBox().getModel();
                    if (model instanceof SearchableComboBox.SearchableComboBoxModel) {
                        ((SearchableComboBox.SearchableComboBoxModel)model).setSearchText(WilySearchableComboBoxEditor.this.editor.getText());
                    }
                }
            });
            if (Character.isDefined(keyChar)) {
                this.fComboboxUI.getComboBox().showPopup();
            }
        }
    }

    class KTextField
    extends JTextField {
        private static final long serialVersionUID = -678946192347678038L;

        public KTextField(String text, int columns) {
            super(text, columns);
        }

        public void setText(String s) {
            if (this.getText().equals(s)) {
                return;
            }
            super.setText(s);
        }
    }

    static class KUIResource
    extends WilySearchableComboBoxEditor
    implements UIResource {
        public KUIResource(WilySearchableComboBoxUI comboboxUI) {
            super(comboboxUI);
        }
    }
}

