/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing.filechooser;

import com.wily.util.io.ExtendedFile;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class HTMLFileFilter
extends FileFilter {
    private IStringLocalizer fLocalizer;
    public static final String kHTMLExtension = "html";
    public static final String kHTMExtension = "htm";

    public HTMLFileFilter(IStringLocalizer localizer) {
        Assertion.wilyAssert(localizer != null);
        this.fLocalizer = localizer;
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = ExtendedFile.getExtension(f);
        return extension != null && (extension.equalsIgnoreCase(kHTMLExtension) || extension.equalsIgnoreCase(kHTMExtension));
    }

    public String getDescription() {
        return this.fLocalizer.IStringLocalizer_getLocalizedString("HTMLFileFilterDescription");
    }
}

