/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing.filechooser;

import com.wily.util.io.ExtendedFile;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class ImageFileFilter
extends FileFilter {
    private IStringLocalizer fLocalizer;
    public static final String kGifExtension = "gif";
    public static final String kJpegExtension = "jpeg";
    public static final String kJpgExtension = "jpg";

    public ImageFileFilter(IStringLocalizer localizer) {
        Assertion.wilyAssert(localizer != null);
        this.fLocalizer = localizer;
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = ExtendedFile.getExtension(f);
        return extension != null && this.isExtensionValid(extension);
    }

    protected boolean isExtensionValid(String extension) {
        return extension.equalsIgnoreCase(kGifExtension) || extension.equalsIgnoreCase(kJpegExtension) || extension.equalsIgnoreCase(kJpgExtension);
    }

    public String getDescription() {
        return this.fLocalizer.IStringLocalizer_getLocalizedString("ImageFileFilterDescription");
    }
}

