/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing.table;

import com.wily.ui.swing.table.TableSorter_v2;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class SortedSelectionModel
implements ListSelectionModel,
ListSelectionListener {
    private final Set listeners = new HashSet();
    private final ListSelectionModel unsortedModel;
    private final TableSorter_v2 fSorter;

    private int toView(int v) {
        if (v >= 0 && v < this.fSorter.getRowCount()) {
            return this.fSorter.viewIndex(v);
        }
        return v;
    }

    private int toModel(int v) {
        if (v >= 0 && v < this.fSorter.getRowCount()) {
            return this.fSorter.modelIndex(v);
        }
        return v;
    }

    SortedSelectionModel(TableSorter_v2 sorter_v2, ListSelectionModel underlyingModel) {
        this.fSorter = sorter_v2;
        this.unsortedModel = underlyingModel;
        this.unsortedModel.addListSelectionListener(this);
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.listeners.add(l);
    }

    public void addSelectionInterval(int index0, int index1) {
        this.setSelectionInterval(index0, index1, false);
    }

    public void setSelectionInterval(int index0, int index1) {
        this.setSelectionInterval(index0, index1, true);
    }

    public void setSelectionInterval(int index0, int index1, boolean clearFirst) {
        boolean isAlreadyAdjusting = this.getValueIsAdjusting();
        int start = index0 < index1 ? index0 + 1 : index1;
        int length = Math.abs(index0 - index1);
        if (!isAlreadyAdjusting) {
            this.setValueIsAdjusting(true);
        }
        for (int i = start; i < start + length; ++i) {
            if (i == start && clearFirst) {
                this.unsortedModel.addSelectionInterval(this.toModel(i), this.toModel(i));
                continue;
            }
            this.unsortedModel.addSelectionInterval(this.toModel(i), this.toModel(i));
        }
        if (clearFirst && length == 0) {
            this.unsortedModel.setSelectionInterval(this.toModel(index0), this.toModel(index0));
        } else {
            this.unsortedModel.addSelectionInterval(this.toModel(index0), this.toModel(index0));
        }
        if (!isAlreadyAdjusting) {
            this.setValueIsAdjusting(false);
        }
    }

    public void clearSelection() {
        this.unsortedModel.clearSelection();
    }

    public int getAnchorSelectionIndex() {
        return this.toView(this.unsortedModel.getAnchorSelectionIndex());
    }

    public int getLeadSelectionIndex() {
        return this.toView(this.unsortedModel.getLeadSelectionIndex());
    }

    public int getMaxSelectionIndex() {
        int max = -1;
        for (int i = this.unsortedModel.getMinSelectionIndex(); i >= 0 && i <= this.unsortedModel.getMaxSelectionIndex(); ++i) {
            if (!this.unsortedModel.isSelectedIndex(i)) continue;
            max = Math.max(this.toView(i), max);
        }
        return max;
    }

    public int getMinSelectionIndex() {
        int min = Integer.MAX_VALUE;
        for (int i = this.unsortedModel.getMinSelectionIndex(); i >= 0 && i <= this.unsortedModel.getMaxSelectionIndex(); ++i) {
            if (!this.unsortedModel.isSelectedIndex(i)) continue;
            min = Math.min(this.toView(i), min);
        }
        return min == Integer.MAX_VALUE ? -1 : min;
    }

    public int getSelectionMode() {
        return this.unsortedModel.getSelectionMode();
    }

    public boolean getValueIsAdjusting() {
        return this.unsortedModel.getValueIsAdjusting();
    }

    public void insertIndexInterval(int index, int length, boolean before) {
    }

    public void removeIndexInterval(int index0, int index1) {
    }

    public boolean isSelectedIndex(int index) {
        return this.unsortedModel.isSelectedIndex(this.toModel(index));
    }

    public boolean isSelectionEmpty() {
        return this.unsortedModel.isSelectionEmpty();
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.listeners.remove(l);
    }

    public void removeSelectionInterval(int index0, int index1) {
        this.unsortedModel.removeSelectionInterval(this.toModel(index0), this.toModel(index1));
    }

    public void setAnchorSelectionIndex(int anchorIndex) {
        this.unsortedModel.setAnchorSelectionIndex(this.toModel(anchorIndex));
    }

    public void setLeadSelectionIndex(int leadIndex) {
        this.unsortedModel.setLeadSelectionIndex(this.toModel(leadIndex));
    }

    public void setSelectionMode(int selectionMode) {
        this.unsortedModel.setSelectionMode(selectionMode);
        switch (selectionMode) {
            case 1: 
            case 2: {
                this.unsortedModel.setSelectionMode(2);
                break;
            }
            case 0: {
                this.unsortedModel.setSelectionMode(0);
            }
        }
    }

    public void setValueIsAdjusting(boolean isAdjusting) {
        this.unsortedModel.setValueIsAdjusting(isAdjusting);
    }

    public void valueChanged(ListSelectionEvent e) {
        int start = Integer.MAX_VALUE;
        int end = -1;
        for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
            start = Math.min(this.toView(i), start);
            end = Math.max(this.toView(i), end);
        }
        ListSelectionEvent event = new ListSelectionEvent(this, start, end, e.getValueIsAdjusting());
        this.fireValueChanged(event);
    }

    private void fireValueChanged(ListSelectionEvent translatedEvent) {
        Iterator eachListener = this.listeners.iterator();
        while (eachListener.hasNext()) {
            ListSelectionListener l = (ListSelectionListener)eachListener.next();
            l.valueChanged(translatedEvent);
        }
    }
}

