/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.widget;

import com.wily.ui.KWilyUserInterfaceConstants;
import com.wily.ui.RadialMeasurements;
import com.wily.ui.WilyUIUtilities;
import com.wily.ui.widget.IWidget;
import com.wily.wilyassert.Assertion;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;

public abstract class ATrafficLightWidget
implements KWilyUserInterfaceConstants,
IWidget {
    public static final int kRed = 457;
    public static final int kYellow = 458;
    public static final int kGreen = 459;
    public static final int kHole = 460;
    public static final int kUnconnected = 461;
    protected int fState = 460;
    private boolean fUseStencilledShapes = false;
    private static final Color kLampFrameEdgeColor = new Color(51, 51, 102);
    private static final Color kGreenLampLitColor = kSharedUnderThresholdColor;
    private static final Color kYellowLampLitColor = kSharedWarningThresholdColor;
    private static final Color kRedLampLitColor = kSharedDangerThresholdColor;
    private static final Color kLampUnlitColor = Color.white;
    protected static final int kLampFrameOuterEdgeThickness = 3;
    protected static final int kLampFrameIntraEdgeOffset = 2;
    protected static final int kLampFrameInnerEdgeThickness = 2;

    public ATrafficLightWidget() {
    }

    public ATrafficLightWidget(int state) {
        Assertion.wilyAssert(state == 457 || state == 458 || state == 459 || state == 461 || state == 460, "invalid traffic light state");
        this.fState = state;
    }

    public boolean getUseStencilledShapes() {
        return this.fUseStencilledShapes;
    }

    public void setUseStancilledShapes(boolean useStencilledShapes) {
        this.fUseStencilledShapes = useStencilledShapes;
    }

    public abstract void draw(Graphics var1, Dimension var2);

    public abstract Dimension getPreferredSize();

    public int getState() {
        return this.fState;
    }

    public void setState(int state) {
        Assertion.wilyAssert(state == 457 || state == 458 || state == 459 || state == 460 || state == 461);
        this.fState = state;
    }

    public void setRed() {
        this.fState = 457;
    }

    public void setYellow() {
        this.fState = 458;
    }

    public void setGreen() {
        this.fState = 459;
    }

    public void setHole() {
        this.fState = 460;
    }

    public void drawGreenLamp(Graphics2D g2D, RadialMeasurements lampMeasurements, boolean light) {
        Color fillColor = light ? kGreenLampLitColor : kLampUnlitColor;
        this.drawLamp(g2D, lampMeasurements, fillColor);
    }

    public void drawYellowLamp(Graphics2D g2D, RadialMeasurements lampMeasurements, boolean light) {
        Color fillColor = light ? kYellowLampLitColor : kLampUnlitColor;
        this.drawLamp(g2D, lampMeasurements, fillColor);
    }

    public void drawGrayLamp(Graphics2D g2D, RadialMeasurements lampMeasurements, boolean light) {
        Color fillColor = Color.lightGray;
        this.drawLamp(g2D, lampMeasurements, fillColor);
    }

    public void drawRedLamp(Graphics2D g2D, RadialMeasurements lampMeasurements, boolean light) {
        Color fillColor = light ? kRedLampLitColor : kLampUnlitColor;
        this.drawLamp(g2D, lampMeasurements, fillColor);
    }

    protected void drawHoleLamp(Graphics2D g2D, RadialMeasurements lampMeasurements) {
        this.drawLamp(g2D, lampMeasurements, kLampUnlitColor);
    }

    private void drawLamp(Graphics2D g2D, RadialMeasurements lampMeasurements, Color fillColor) {
        int frameInnerRadius = lampMeasurements.getRadius() - 3 - 2 - 2;
        if (fillColor != null) {
            this.fillLamp(g2D, new RadialMeasurements(lampMeasurements.getCenter(), frameInnerRadius + 1), fillColor);
        }
        this.drawLampFrame(g2D, lampMeasurements);
    }

    private int drawLampFrame(Graphics2D g2D, RadialMeasurements lampFrameMeasurements) {
        g2D.setColor(kLampFrameEdgeColor);
        g2D.setStroke(new BasicStroke(3.0f));
        WilyUIUtilities.drawCircle(g2D, lampFrameMeasurements);
        int innerEdgeRadius = lampFrameMeasurements.getRadius() - 3 - 2;
        g2D.setStroke(new BasicStroke(2.0f));
        WilyUIUtilities.drawCircle(g2D, new RadialMeasurements(lampFrameMeasurements.getCenter(), innerEdgeRadius));
        return innerEdgeRadius - 2;
    }

    private void fillLamp(Graphics2D g2D, RadialMeasurements lampFrameMeasurements, Color fillColor) {
        g2D.setColor(fillColor);
        WilyUIUtilities.fillCircle(g2D, lampFrameMeasurements);
    }
}

