/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.widget;

import com.wily.ui.ArcHandler;
import com.wily.ui.ThresholdValue;
import com.wily.ui.widget.AContinuousValueDisplayWidget;
import com.wily.util.Range;
import com.wily.util.Scale;
import com.wily.wilyassert.Assertion;
import com.wily.wilyassert.SwingAssertion;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.LineMetrics;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import javax.swing.SwingUtilities;

public class DialMeterWidget
extends AContinuousValueDisplayWidget {
    private String fMaxValueString;
    private String fMinValueString;
    private String fCurrentValueString;
    private String fCautionValueString;
    private String fDangerValueString;
    private Dimension fMaxValueDimension;
    private Dimension fMinValueDimension;
    private Dimension fCurrentValueDimension;
    private Dimension fCautionValueDimension;
    private Dimension fDangerValueDimension;
    private static final int kPreferredWidth = 150;
    private static final int kPreferredHeight = 150;
    private static final int kInnerDialFaceRadius = 16;
    private static final int kDialFaceEdgeWidth = 2;
    private static final int kTickCount = 9;
    private static final int kTickAngleOffset = 10;
    private static final int kTickOffset = 5;
    private static final int kTickLength = 5;
    private static final int kLabelOffset = 2;
    private static final int kThresholdIndicatorTickOffset = 1;
    private static final int kThresholdIndicatorTickLength = 13;
    private static final int kNeedleOvershoot = 10;
    private static final Color kDialNeutralColor = kSharedNeutralColor;
    private static final Color kDialWarningThresholdColor = kSharedWarningThresholdColor;
    private static final Color kDialDangerThresholdColor = kSharedDangerThresholdColor;
    private static final Color kFaceFillColor = new Color(231, 238, 247);
    private static final Color kFaceOutlineColor = new Color(51, 51, 102);
    private static final Color kTickColor = kDialNeutralColor;
    private static final Color kNeedleColor = kFaceOutlineColor;
    private static final Color kNeedleHighlightColor = kDialNeutralColor;
    private static final Color kIndicatorStrikeThroughColor = Color.white;
    private static final Font kCurrentValueLabelFont = new Font("Dialog", 1, 12);

    public DialMeterWidget(double holeValue, ThresholdValue threshold) {
        super(holeValue, new Scale(), threshold);
    }

    public DialMeterWidget(double holeValue, Scale scale, ThresholdValue threshold) {
        super(holeValue, scale, threshold);
    }

    public Dimension getPreferredSize() {
        return new Dimension(150, 150);
    }

    public synchronized void draw(Graphics g, Dimension d) {
        SwingAssertion.assertSwingSafe("must draw on the swing thread");
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Insets labelInsets = this.getLabelInsets(g2D);
        int tickMaxInset = Math.max(10, 14);
        int rightInset = tickMaxInset + labelInsets.right;
        int leftInset = tickMaxInset + labelInsets.left;
        int topInset = tickMaxInset + labelInsets.top;
        int bottomInet = labelInsets.bottom;
        Insets insets = new Insets(topInset, leftInset, bottomInet, rightInset);
        int dialFaceRadius = Math.min((d.width - insets.left - insets.right) / 2, d.height - insets.top - insets.bottom);
        dialFaceRadius = Math.max(17, dialFaceRadius);
        Point dialFaceCenter = new Point((d.width - insets.left - insets.right) / 2 + insets.left, insets.top + dialFaceRadius);
        this.drawDialFace(g2D, dialFaceCenter, dialFaceRadius);
        this.drawValueFill(g2D, dialFaceCenter, dialFaceRadius);
        this.drawDialFaceEdge(g2D, dialFaceCenter, dialFaceRadius);
        this.drawTicks(g2D, dialFaceCenter, dialFaceRadius);
        this.drawThresholdIndicators(g2D, dialFaceCenter, dialFaceRadius);
        this.drawNeedle(g2D, dialFaceCenter, dialFaceRadius);
        this.drawLabels(g2D, dialFaceCenter, dialFaceRadius);
    }

    private Insets getLabelInsets(Graphics2D g2D) {
        SwingAssertion.assertSwingSafe("must get label insets on swing thread");
        int topInset = 0;
        int leftInset = 0;
        int bottomInset = 0;
        int rightInset = 0;
        g2D.setFont(kDefaultLabelFont);
        this.fMaxValueString = Scale.getNicelyFormattedString(this.fScale.getMax());
        LineMetrics maxValueLineMetrics = g2D.getFontMetrics().getLineMetrics(this.fMaxValueString, g2D);
        this.fMaxValueDimension = new Dimension(SwingUtilities.computeStringWidth(g2D.getFontMetrics(), this.fMaxValueString), (int)maxValueLineMetrics.getHeight());
        this.fMinValueString = Scale.getNicelyFormattedString(this.fScale.getMin());
        LineMetrics minValueLineMetrics = g2D.getFontMetrics().getLineMetrics(this.fMinValueString, g2D);
        this.fMinValueDimension = new Dimension(SwingUtilities.computeStringWidth(g2D.getFontMetrics(), this.fMinValueString), (int)minValueLineMetrics.getHeight());
        if (this.fThreshold != null && this.fThreshold.hasCaution()) {
            this.fCautionValueString = Scale.getNicelyFormattedString(this.fThreshold.getCautionValue());
            LineMetrics cautionValueLineMetrics = g2D.getFontMetrics().getLineMetrics(this.fCautionValueString, g2D);
            this.fCautionValueDimension = new Dimension(SwingUtilities.computeStringWidth(g2D.getFontMetrics(), this.fCautionValueString), (int)cautionValueLineMetrics.getHeight());
        } else {
            this.fCautionValueDimension = new Dimension(0, 0);
        }
        if (this.fThreshold != null) {
            this.fDangerValueString = Scale.getNicelyFormattedString(this.fThreshold.getDangerValue());
            LineMetrics dangerValueLineMetrics = g2D.getFontMetrics().getLineMetrics(this.fDangerValueString, g2D);
            this.fDangerValueDimension = new Dimension(SwingUtilities.computeStringWidth(g2D.getFontMetrics(), this.fDangerValueString), (int)dangerValueLineMetrics.getHeight());
        } else {
            this.fDangerValueDimension = new Dimension(0, 0);
        }
        g2D.setFont(kCurrentValueLabelFont);
        this.fCurrentValueString = Scale.getNicelyFormattedString(this.fCurrentValue);
        LineMetrics currentValueLineMetrics = g2D.getFontMetrics().getLineMetrics(this.fCurrentValueString, g2D);
        this.fCurrentValueDimension = new Dimension(SwingUtilities.computeStringWidth(g2D.getFontMetrics(), this.fCurrentValueString), (int)currentValueLineMetrics.getHeight());
        topInset = Math.max(this.fCautionValueDimension.height, this.fDangerValueDimension.height);
        leftInset = Math.max(this.fCautionValueDimension.width, this.fDangerValueDimension.width);
        bottomInset = Math.max(this.fMaxValueDimension.height, this.fMinValueDimension.height);
        bottomInset = Math.max(bottomInset, this.fCurrentValueDimension.height);
        rightInset = leftInset += 2;
        return new Insets(topInset += 2, leftInset, bottomInset += 2, rightInset);
    }

    private void drawLabels(Graphics2D g2D, Point dialFaceCenter, int dialFaceRadius) {
        SwingAssertion.assertSwingSafe("must draw labels from swing thread");
        g2D.setFont(kDefaultLabelFont);
        g2D.setColor(kDefaultLabelColor);
        int minLabelYLocation = dialFaceCenter.y + 2 + this.fMinValueDimension.height;
        int minLabelXLocation = dialFaceCenter.x - dialFaceRadius - 2;
        g2D.drawString(this.fMinValueString, minLabelXLocation, minLabelYLocation);
        int maxLabelYLocation = minLabelYLocation;
        int maxLabelXLocation = dialFaceCenter.x + dialFaceRadius + 2 - this.fMaxValueDimension.width;
        g2D.drawString(this.fMaxValueString, maxLabelXLocation, maxLabelYLocation);
        if (this.fThreshold != null) {
            int thresholdLabelRadius = dialFaceRadius + 1 + 13 + 2;
            Rectangle boundingRectangle = new Rectangle(dialFaceCenter.x - thresholdLabelRadius, dialFaceCenter.y - thresholdLabelRadius, 2 * thresholdLabelRadius, 2 * thresholdLabelRadius);
            ArcHandler thresholdLabelHander = new ArcHandler(boundingRectangle);
            int warningValueLabelAngle = 0;
            Point warningLabelLocation = null;
            if (this.fThreshold.hasCaution() && this.fScale.withinBounds(this.fThreshold.getCautionValue())) {
                warningValueLabelAngle = DialMeterWidget.calculateAngle(this.fThreshold.getCautionValue(), this.fScale);
                warningLabelLocation = thresholdLabelHander.getPointAt(warningValueLabelAngle, 1.0);
                if (warningValueLabelAngle > 90) {
                    warningLabelLocation = new Point(warningLabelLocation.x - this.fCautionValueDimension.width, warningLabelLocation.y);
                }
            }
            int dangerValueLabelAngle = 0;
            Point dangerLabelLocation = null;
            if (this.fScale.withinBounds(this.fThreshold.getDangerValue())) {
                dangerValueLabelAngle = DialMeterWidget.calculateAngle(this.fThreshold.getDangerValue(), this.fScale);
                dangerLabelLocation = thresholdLabelHander.getPointAt(dangerValueLabelAngle, 1.0);
                if (dangerValueLabelAngle > 90) {
                    dangerLabelLocation = new Point(dangerLabelLocation.x - this.fDangerValueDimension.width, dangerLabelLocation.y);
                }
            }
            if (warningLabelLocation != null && dangerLabelLocation != null) {
                Rectangle warningRect = new Rectangle(warningLabelLocation, this.fCautionValueDimension);
                Rectangle dangerRect = new Rectangle(dangerLabelLocation, this.fDangerValueDimension);
                Rectangle intersection = warningRect.intersection(dangerRect);
                while (!intersection.isEmpty()) {
                    int angleOffset = 1;
                    dangerValueLabelAngle -= angleOffset;
                    warningLabelLocation = thresholdLabelHander.getPointAt(warningValueLabelAngle += angleOffset, 1.0);
                    if (warningValueLabelAngle > 90) {
                        warningLabelLocation = new Point(warningLabelLocation.x - this.fCautionValueDimension.width, warningLabelLocation.y);
                    }
                    dangerLabelLocation = thresholdLabelHander.getPointAt(dangerValueLabelAngle, 1.0);
                    if (dangerValueLabelAngle > 90) {
                        dangerLabelLocation = new Point(dangerLabelLocation.x - this.fDangerValueDimension.width, dangerLabelLocation.y);
                    }
                    warningRect = new Rectangle(warningLabelLocation, this.fCautionValueDimension);
                    dangerRect = new Rectangle(dangerLabelLocation, this.fDangerValueDimension);
                    intersection = warningRect.intersection(dangerRect);
                }
            }
            if (this.fThreshold.hasCaution() && this.fScale.withinBounds(this.fThreshold.getCautionValue())) {
                g2D.drawString(this.fCautionValueString, warningLabelLocation.x, warningLabelLocation.y);
            }
            if (this.fScale.withinBounds(this.fThreshold.getDangerValue())) {
                g2D.drawString(this.fDangerValueString, dangerLabelLocation.x, dangerLabelLocation.y);
            }
        }
        g2D.setFont(kCurrentValueLabelFont);
        int currentLabelYLocation = dialFaceCenter.y + 2 + this.fCurrentValueDimension.height;
        int currentLabelXLocation = dialFaceCenter.x - this.fCurrentValueDimension.width / 2;
        if (!this.currentValueIsHoleValue()) {
            g2D.drawString(this.fCurrentValueString, currentLabelXLocation, currentLabelYLocation);
        }
    }

    private void drawDialFace(Graphics2D g2D, Point center, int radius) {
        this.drawSlice(g2D, center, 0, 180, 16, radius, kFaceFillColor, null, 0);
    }

    private void drawDialFaceEdge(Graphics2D g2D, Point center, int radius) {
        this.drawSlice(g2D, center, 0, 180, 16, radius, null, kFaceOutlineColor, 2);
    }

    private void drawValueFill(Graphics2D g2D, Point center, int radius) {
        if (!this.currentValueIsHoleValue()) {
            AContinuousValueDisplayWidget.RangeStyles rangeStyles = this.getRangeStyles(this.getThresholdValue(), this.getCurrentValue());
            Range currentValueRange = rangeStyles.getCurrentValueRange();
            AContinuousValueDisplayWidget.Style style = rangeStyles.getCurrentValueStyle();
            this.drawFillForRange(g2D, center, radius, currentValueRange, style.getColor());
        }
    }

    private void drawFillForRange(Graphics2D g2D, Point center, int radius, Range range, Color color) {
        int lowerValueAngle = DialMeterWidget.calculateAngle(range.getLowerBound(), this.fScale);
        int higherValueAngle = DialMeterWidget.calculateAngle(range.getUpperBound(), this.fScale);
        this.drawSlice(g2D, center, higherValueAngle, lowerValueAngle, 16, radius, color, null, 0);
    }

    private void drawTicks(Graphics2D g2D, Point center, int baseRadius) {
        int tickAngleIncrement = 20;
        int innerTickRadius = baseRadius + 5;
        int outerTickRadius = innerTickRadius + 5;
        for (int i = 0; i < 9; ++i) {
            int tickAngle = 10 + i * 20;
            this.drawSlice(g2D, center, tickAngle, tickAngle, innerTickRadius, outerTickRadius, null, kTickColor, 2);
        }
    }

    private void drawNeedle(Graphics2D g2D, Point center, int dialFaceRadius) {
        if (!this.currentValueIsHoleValue()) {
            int needleRadius = dialFaceRadius + 10;
            int needleAngle = DialMeterWidget.calculateAngle(this.fCurrentValue, this.fScale);
            Point highlightCenter = new Point(center.x - 1, center.y);
            this.drawSlice(g2D, center, needleAngle, needleAngle, 0, needleRadius, null, kNeedleColor, 3);
            this.drawSlice(g2D, highlightCenter, needleAngle, needleAngle, 0, needleRadius, null, kNeedleHighlightColor, 1);
        }
    }

    private void drawThresholdIndicators(Graphics2D g2D, Point center, int dialFaceRadius) {
        boolean drawDangerIndicator;
        int innerThresholdIndicatorTickRadius = dialFaceRadius + 1;
        int outerThresholdIndicatorTickRadius = innerThresholdIndicatorTickRadius + 13;
        boolean drawCautionIndicator = this.fThreshold != null && this.fThreshold.hasCaution() && this.fScale.withinBounds(this.fThreshold.getCautionValue());
        boolean bl = drawDangerIndicator = this.fThreshold != null && this.fScale.withinBounds(this.fThreshold.getDangerValue());
        if (drawCautionIndicator) {
            int warningAngle = DialMeterWidget.calculateAngle(this.fThreshold.getCautionValue(), this.fScale);
            this.drawSlice(g2D, center, warningAngle, warningAngle, 18, dialFaceRadius - 2, null, kIndicatorStrikeThroughColor, 2);
            this.drawSlice(g2D, center, warningAngle, warningAngle, innerThresholdIndicatorTickRadius, outerThresholdIndicatorTickRadius, null, kDialWarningThresholdColor, 2);
        }
        if (drawDangerIndicator) {
            int dangerAngle = DialMeterWidget.calculateAngle(this.fThreshold.getDangerValue(), this.fScale);
            this.drawSlice(g2D, center, dangerAngle, dangerAngle, 18, dialFaceRadius - 2, null, kIndicatorStrikeThroughColor, 2);
            this.drawSlice(g2D, center, dangerAngle, dangerAngle, innerThresholdIndicatorTickRadius, outerThresholdIndicatorTickRadius, null, kDialDangerThresholdColor, 2);
        }
    }

    private void drawSlice(Graphics2D g2D, Point center, int startAngle, int endAngle, int innerRadius, int outerRadius, Color fillColor, Color outlineColor, int lineWidth) {
        Assertion.wilyAssert(innerRadius < outerRadius && startAngle <= endAngle);
        g2D.setStroke(new BasicStroke(lineWidth));
        if (startAngle == endAngle && outlineColor != null) {
            Rectangle boundingRectangle = new Rectangle(center.x - innerRadius, center.y - innerRadius, 2 * innerRadius, 2 * innerRadius);
            ArcHandler arcHandler = new ArcHandler(boundingRectangle);
            Point p1 = arcHandler.getPointAt(startAngle, 1.0);
            boundingRectangle = new Rectangle(center.x - outerRadius, center.y - outerRadius, 2 * outerRadius, 2 * outerRadius);
            arcHandler = new ArcHandler(boundingRectangle);
            Point p2 = arcHandler.getPointAt(startAngle, 1.0);
            g2D.setColor(outlineColor);
            g2D.drawLine(p1.x, p1.y, p2.x, p2.y);
        } else {
            Ellipse2D.Float outerCircle = new Ellipse2D.Float(center.x - outerRadius, center.y - outerRadius, 2 * outerRadius, 2 * outerRadius);
            Ellipse2D.Float innerCircle = new Ellipse2D.Float(center.x - innerRadius, center.y - innerRadius, 2 * innerRadius, 2 * innerRadius);
            Area sliceArea = new Area(outerCircle);
            sliceArea.subtract(new Area(innerCircle));
            sliceArea.intersect(this.getFramingArea(center, startAngle, endAngle, outerRadius));
            if (fillColor != null) {
                g2D.setColor(fillColor);
                g2D.fill(sliceArea);
            }
            if (outlineColor != null) {
                g2D.setColor(outlineColor);
                g2D.draw(sliceArea);
            }
        }
    }

    private static int calculateAngle(double value, Scale scale) {
        int angle = value <= scale.getMin() ? 180 : (value >= scale.getMax() ? 0 : 180 - (int)((value - scale.getMin()) / (scale.getMax() - scale.getMin()) * 180.0));
        return angle;
    }

    private Area getFramingArea(Point center, int startAngle, int endAngle, int radius) {
        Assertion.wilyAssert(startAngle <= endAngle);
        Rectangle boundingRectangle = new Rectangle(center.x - radius, center.y - radius, 2 * radius, 2 * radius);
        ArcHandler arcHandler = new ArcHandler(boundingRectangle);
        Point p1 = center;
        Point p2 = arcHandler.getPointAt(startAngle, 1.0);
        Point p3 = new Point(p2.x, center.y - radius);
        Point p5 = arcHandler.getPointAt(endAngle, 1.0);
        Point p4 = new Point(p5.x, center.y - radius);
        GeneralPath polygon = new GeneralPath(0, 4);
        polygon.moveTo(p1.x, p1.y);
        polygon.lineTo(p2.x, p2.y);
        polygon.lineTo(p3.x, p3.y);
        polygon.lineTo(p4.x, p4.y);
        polygon.lineTo(p5.x, p5.y);
        polygon.closePath();
        return new Area(polygon);
    }
}

