/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.wizard;

import com.wily.properties.KUICommonStringsKeys;
import com.wily.ui.IGenericServices;
import com.wily.ui.action.AOneWayExtendedAction;
import com.wily.ui.swing.WilyJDialog;
import com.wily.ui.wizard.AWizardPanel;
import com.wily.ui.wizard.AWizardStaticPanel;
import com.wily.ui.wizard.IWizardListener;
import com.wily.ui.wizard.SilentWizardValidationException;
import com.wily.ui.wizard.WizardControlPanel;
import com.wily.ui.wizard.WizardValidationException;
import com.wily.util.IStateSaver;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.task.IExecutableItem;
import com.wily.util.task.IInterruptableTask;
import com.wily.util.task.ITask;
import com.wily.util.task.ITaskCompletionHandler;
import com.wily.util.task.TaskException;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.validate.IValidatable;
import com.wily.util.validate.KValidationConstants;
import com.wily.util.validate.ValidationException;
import com.wily.util.version.IVersion;
import com.wily.wilyassert.SwingAssertion;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public abstract class AWizard
extends JPanel
implements IStateSaver,
IValidatable,
KValidationConstants,
KUICommonStringsKeys {
    public static final int kNoButton = -1;
    public static final int kDefaultButton = 0;
    public static final int kCancelButton = 1;
    public static final int kHelpButton = 2;
    public static final int kPreviousButton = 3;
    public static final int kNextButton = 4;
    private JPanel fPagingPanel;
    private CardLayout fPagingLayout;
    private AWizardPanel[] fPages;
    private AWizardPanel fStatusPage;
    private boolean fStatus;
    private AWizardPanel fFinishedPage;
    private boolean fFinished;
    private Stack fStates;
    private AWizardStaticPanel fStaticPanel;
    private WizardControlPanel fControlPanel;
    private Vector fListeners;
    private ITask fWizardTask;
    private boolean fHandlingButton = false;
    private boolean fIsInterruptable = false;
    private String kStatusTitle = "status";
    private String kFinishedTitle = "finished";
    private String kStatePrefix = "state";
    private String kWizardPrefix = "wizard";
    private IGenericServices fGenericServices;
    private Action fPreviousAction;
    private Action fNextAction;
    private Action fCancelAction;
    private Action fHelpAction;
    private String fDefaultPreviousText;
    private String fDefaultNextText;
    private String fDefaultExitText;
    private String fDefaultCancelText;
    private String fDefaultHelpText;
    private int fDefaultPreviousMnemonic;
    private int fDefaultNextMnemonic;
    private int fDefaultExitMnemonic;
    private int fDefaultCancelMnemonic;
    private int fDefaultHelpMnemonic;

    public AWizard(IGenericServices genericServices) {
        this.fGenericServices = genericServices;
        this.fPagingPanel = null;
        this.fPagingLayout = null;
        this.fPages = null;
        this.fStatusPage = null;
        this.fStatus = false;
        this.fFinishedPage = null;
        this.fFinished = false;
        this.fStates = null;
        this.fStaticPanel = null;
        this.fControlPanel = null;
        this.fListeners = new Vector();
        this.fWizardTask = null;
        this.fDefaultPreviousText = this.getStringLocalizer().IStringLocalizer_getLocalizedString("Previous");
        this.fDefaultNextText = this.getStringLocalizer().IStringLocalizer_getLocalizedString("Next");
        this.fDefaultExitText = this.getStringLocalizer().IStringLocalizer_getLocalizedString("Exit");
        this.fDefaultCancelText = this.getStringLocalizer().IStringLocalizer_getLocalizedString("Cancel");
        this.fDefaultHelpText = this.getStringLocalizer().IStringLocalizer_getLocalizedString("Help");
        this.fDefaultPreviousMnemonic = this.getLocalizedMnemonic("Previous_Mnemonic");
        this.fDefaultNextMnemonic = this.getLocalizedMnemonic("Next_Mnemonic");
        this.fDefaultExitMnemonic = this.getLocalizedMnemonic("Exit_Mnemonic");
        this.fDefaultCancelMnemonic = this.getLocalizedMnemonic("Cancel_Mnemonic");
        this.fDefaultHelpMnemonic = this.getLocalizedMnemonic("Help_Mnemonic");
        this.fPreviousAction = new PreviousAction(this.fDefaultPreviousText);
        this.fNextAction = new NextAction(this.fDefaultNextText);
        this.fCancelAction = new CancelAction(this.fDefaultCancelText);
        this.fHelpAction = new HelpAction(this.fDefaultHelpText);
    }

    private int getLocalizedMnemonic(String key) {
        String str = this.getStringLocalizer().IStringLocalizer_getLocalizedString(key);
        return StringUtils.stringToMnemonic(str);
    }

    public void addWizardListener(IWizardListener listener) {
        this.fListeners.addElement(listener);
    }

    public void removeWizardListener(IWizardListener listener) {
        this.fListeners.remove(listener);
    }

    private void notifyListenersOfCancel() {
        Enumeration enumeration = this.fListeners.elements();
        while (enumeration.hasMoreElements()) {
            IWizardListener listener = (IWizardListener)enumeration.nextElement();
            listener.IWizardListener_wizardCancelled(this);
        }
    }

    private void notifyListenersOfCompletion() {
        Enumeration e = this.fListeners.elements();
        while (e.hasMoreElements()) {
            IWizardListener listener = (IWizardListener)e.nextElement();
            listener.IWizardListener_wizardFinished(this);
        }
    }

    private void notifyListenersOfDefaultButton(JButton button) {
        Enumeration e = this.fListeners.elements();
        while (e.hasMoreElements()) {
            IWizardListener listener = (IWizardListener)e.nextElement();
            listener.IWizardListener_setDefaultButton(this, button);
        }
    }

    public void initializeUI(AWizardPanel[] pages, AWizardStaticPanel staticPanel) {
        this.initializeUI(pages, null, null, staticPanel);
    }

    public void initializeUI(AWizardPanel[] pages, AWizardPanel statusPage, AWizardPanel finishedPage, AWizardStaticPanel staticPanel) {
        if (pages == null || pages.length == 0) {
            throw new IllegalArgumentException("wizard must have at least one panel");
        }
        this.fPages = pages;
        this.fStatusPage = statusPage;
        this.fFinishedPage = finishedPage;
        this.fStates = new Stack();
        this.fStaticPanel = staticPanel;
        this.fWizardTask = this.getWizardTask();
        this.fWizardTask.ITask_addTaskCompletionHandler(new WizardCompletionHandler());
        this.fIsInterruptable = this.fWizardTask instanceof IInterruptableTask;
        this.fStates.push(new Integer(0));
        this.fControlPanel = new WizardControlPanel(this, true, true);
        this.buildUI();
        this.showState();
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        this.fPagingLayout = new CardLayout();
        this.fPagingPanel = new JPanel(this.fPagingLayout);
        for (int i = 0; i < this.fPages.length; ++i) {
            this.fPagingPanel.add(String.valueOf(i), this.fPages[i]);
        }
        if (this.fStatusPage != null) {
            this.fPagingPanel.add(this.kStatusTitle, this.fStatusPage);
        }
        if (this.fFinishedPage != null) {
            this.fPagingPanel.add(this.kFinishedTitle, this.fFinishedPage);
        }
        this.add((Component)this.fStaticPanel, "West");
        this.add((Component)this.fPagingPanel, "Center");
        this.add((Component)this.fControlPanel, "South");
        this.fPagingPanel.setBorder(BorderFactory.createEtchedBorder());
        this.fStaticPanel.setBorder(new CompoundBorder(BorderFactory.createEtchedBorder(), new EmptyBorder(10, 0, 10, 0)));
    }

    public void gotoState(String title) {
        int index = this.lookupTitle(title);
        if (index != -1) {
            this.gotoState(index);
        }
    }

    private void gotoState(int index) {
        Integer newState = new Integer(index);
        int depth = this.fStates.search(newState);
        if (depth == -1) {
            this.fStates.push(newState);
        } else {
            for (int i = 1; i < depth; ++i) {
                this.fStates.pop();
            }
        }
        if (depth != 1) {
            this.showState();
        }
    }

    protected void showState() {
        this.fStatus = false;
        this.fFinished = false;
        int index = this.currentState();
        this.fPagingLayout.show(this.fPagingPanel, String.valueOf(index));
        this.fPages[index].aboutToShow();
        this.fControlPanel.updateControls();
        this.fStaticPanel.notifyOfPage(this.fPages[index].getTitle());
    }

    protected void showStatusState() {
        this.fStatus = true;
        this.fFinished = false;
        if (this.fStatusPage != null) {
            this.fPagingLayout.show(this.fPagingPanel, this.kStatusTitle);
            this.fStatusPage.aboutToShow();
            this.fControlPanel.updateControls();
            this.fStaticPanel.notifyOfPage(this.fStatusPage.getTitle());
        }
    }

    protected void showFinishedState() {
        this.fStatus = false;
        this.fFinished = true;
        if (this.fFinishedPage != null) {
            this.fPagingLayout.show(this.fPagingPanel, this.kFinishedTitle);
            this.fFinishedPage.aboutToShow();
            this.fControlPanel.updateControls();
            this.fStaticPanel.notifyOfPage(this.fFinishedPage.getTitle());
        }
    }

    public IGenericServices getGenericServices() {
        return this.fGenericServices;
    }

    public IStringLocalizer getStringLocalizer() {
        return this.getGenericServices().IGenericServices_getStringLocalizer();
    }

    public IModuleFeedbackChannel getModuleFeedback() {
        return this.getGenericServices().IGenericServices_getModuleFeedback();
    }

    public IVersion getVersion() {
        return this.getGenericServices().IGenericServices_getVersion();
    }

    private void performValidation() throws ValidationException {
        try {
            this.IValidatable_validate();
        }
        catch (SilentWizardValidationException swve) {
            throw swve;
        }
        catch (ValidationException ave) {
            this.notifyUserOfValidationProblem(ave);
            throw ave;
        }
    }

    public void IStateSaver_saveState(Map stateContainer, String keyPrefix) {
        for (int i = 0; i < this.fPages.length; ++i) {
            this.fPages[i].IStateSaver_saveState(stateContainer, keyPrefix + "_" + String.valueOf(i));
        }
        if (this.fFinishedPage != null) {
            this.fFinishedPage.IStateSaver_saveState(stateContainer, keyPrefix + "_" + this.kFinishedTitle);
        }
    }

    public void IStateSaver_restoreState(Map stateContainer, String keyPrefix) {
        for (int i = 0; i < this.fPages.length; ++i) {
            this.fPages[i].IStateSaver_restoreState(stateContainer, keyPrefix + "_" + String.valueOf(i));
        }
        if (this.fFinishedPage != null) {
            this.fFinishedPage.IStateSaver_restoreState(stateContainer, keyPrefix + "_" + this.kFinishedTitle);
        }
    }

    public Action getPreviousAction() {
        return this.fPreviousAction;
    }

    public Action getNextAction() {
        return this.fNextAction;
    }

    public Action getCancelAction() {
        return this.fCancelAction;
    }

    public Action getHelpAction() {
        return this.fHelpAction;
    }

    public String getPreviousText() {
        String text = this.currentPage().getPreviousText();
        if (text != null) {
            return text;
        }
        return this.fDefaultPreviousText;
    }

    public String getNextText() {
        String text = this.currentPage().getNextText();
        if (text != null) {
            return text;
        }
        return this.fDefaultNextText;
    }

    public String getCancelText() {
        String text = this.currentPage().getCancelText();
        if (text != null) {
            return text;
        }
        if (this.isFinishedState()) {
            return this.fDefaultExitText;
        }
        return this.fDefaultCancelText;
    }

    public String getHelpText() {
        String text = this.currentPage().getHelpText();
        if (text != null) {
            return text;
        }
        return this.fDefaultHelpText;
    }

    public int getPreviousMnemonic() {
        int mnemonic = this.currentPage().getPreviousMnemonic();
        if (mnemonic >= 0) {
            return mnemonic;
        }
        return this.fDefaultPreviousMnemonic;
    }

    public int getNextMnemonic() {
        int mnemonic = this.currentPage().getNextMnemonic();
        if (mnemonic >= 0) {
            return mnemonic;
        }
        return this.fDefaultNextMnemonic;
    }

    public int getCancelMnemonic() {
        int mnemonic = this.currentPage().getCancelMnemonic();
        if (mnemonic >= 0) {
            return mnemonic;
        }
        if (this.isFinishedState()) {
            return this.fDefaultExitMnemonic;
        }
        return this.fDefaultCancelMnemonic;
    }

    public int getHelpMnemonic() {
        int mnemonic = this.currentPage().getHelpMnemonic();
        if (mnemonic >= 0) {
            return mnemonic;
        }
        return this.fDefaultHelpMnemonic;
    }

    public boolean isPreviousEnabled() {
        Boolean state = this.currentPage().getPreviousEnabled();
        if (state != null) {
            return state;
        }
        return !this.fFinished && !this.isFirstState();
    }

    public boolean isNextEnabled() {
        Boolean state = this.currentPage().getNextEnabled();
        if (state != null) {
            return state;
        }
        return !this.fFinished && !this.fStatus;
    }

    public boolean isCancelEnabled() {
        Boolean state = this.currentPage().getCancelEnabled();
        if (state != null) {
            return state;
        }
        return this.fIsInterruptable || !this.fStatus;
    }

    public boolean isHelpEnabled() {
        Boolean state = this.currentPage().getHelpEnabled();
        if (state != null) {
            return state;
        }
        return true;
    }

    public int getDefaultButtonIndex() {
        int index = this.currentPage().getDefaultButtonIndex();
        if (index != 0) {
            return index;
        }
        return 4;
    }

    public void updateButtons() {
        this.fControlPanel.updateControls();
    }

    public void clearStates() {
        this.fStates.clear();
    }

    public void reset() {
        this.clearStates();
        this.gotoState(0);
    }

    public void previous() {
        this.doPrevious();
    }

    public void next() {
        this.doNext();
    }

    public void cancel() {
        this.doCancel();
    }

    public void help() {
        this.doHelp();
    }

    void setDefaultButton(JButton button) {
        this.notifyListenersOfDefaultButton(button);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPrevious() {
        AWizard aWizard = this;
        synchronized (aWizard) {
            if (this.fHandlingButton) {
                return;
            }
            this.fHandlingButton = true;
        }
        try {
            if (!this.fStates.isEmpty()) {
                this.fStates.pop();
                this.showState();
            }
        }
        finally {
            this.fHandlingButton = false;
        }
    }

    /*
     * Exception decompiling
     */
    private void doNext() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK], 1[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCancel() {
        AWizard aWizard = this;
        synchronized (aWizard) {
            if (this.fHandlingButton) {
                return;
            }
            this.fHandlingButton = true;
        }
        this.fWizardTask.ITask_getExecutionQueue().IExecutionQueue_addExecutableItem(new CancelHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHelp() {
        AWizard aWizard = this;
        synchronized (aWizard) {
            if (this.fHandlingButton) {
                return;
            }
            this.fHandlingButton = true;
        }
        try {
            this.showHelp();
        }
        finally {
            this.fHandlingButton = false;
        }
    }

    public abstract ITask getWizardTask();

    protected boolean confirmCancel() {
        return true;
    }

    protected void notifyUserOfValidationProblem(ValidationException ave) {
        SwingAssertion.assertSwingSafe();
        if (ave instanceof WizardValidationException) {
            WizardValidationException wve = (WizardValidationException)ave;
            WilyJDialog.showMessageDialog(this.getGenericServices(), this, wve.getLocalizedMessage(this.getStringLocalizer()), wve.getLocalizedTitle(this.getStringLocalizer()), 0);
        } else {
            WilyJDialog.showMessageDialog(this.getGenericServices(), this, ave.getRequiredCondition().ILocalizableMessage_getLocalizedMessage(this.getStringLocalizer()), ave.getRequiredCondition().ILocalizableMessage_getLocalizedMessage(this.getStringLocalizer()), 0);
        }
    }

    protected void showHelp() {
    }

    public void IValidatable_validate() throws ValidationException {
        this.IValidatable_validate(0);
    }

    public void IValidatable_validate(int validationConstraints) throws ValidationException {
    }

    protected String currentTitle() {
        return this.currentPage().getTitle();
    }

    private AWizardPanel currentPage() {
        if (this.fFinished) {
            return this.fFinishedPage;
        }
        if (this.fStatus) {
            return this.fStatusPage;
        }
        return this.fPages[this.currentState()];
    }

    private int currentState() {
        return (Integer)this.fStates.peek();
    }

    private int lookupTitle(String title) {
        for (int i = 0; i < this.fPages.length; ++i) {
            if (!this.fPages[i].getTitle().equals(title)) continue;
            return i;
        }
        return -1;
    }

    protected boolean isFirstState() {
        return this.fStates.size() <= 1;
    }

    protected boolean isLastState() {
        return !this.fFinished && !this.fStatus && this.currentState() == this.fPages.length - 1;
    }

    protected boolean isStatusState() {
        return this.fStatus;
    }

    protected boolean isFinishedState() {
        return this.fFinished;
    }

    private class CancelHandler
    implements IExecutableItem {
        private CancelHandler() {
        }

        public boolean IExecutableItem_shouldStillExecute() {
            return true;
        }

        public void IExecutableItem_executionAborted() {
            AWizard.this.fHandlingButton = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void IExecutableItem_execute() {
            try {
                if (AWizard.this.fIsInterruptable && ((IInterruptableTask)AWizard.this.fWizardTask).IInterruptableTask_isActive()) {
                    ((IInterruptableTask)AWizard.this.fWizardTask).IInterruptableTask_pauseAsynch();
                }
                if (AWizard.this.confirmCancel()) {
                    if (AWizard.this.fIsInterruptable && ((IInterruptableTask)AWizard.this.fWizardTask).IInterruptableTask_isActive()) {
                        ((IInterruptableTask)AWizard.this.fWizardTask).IInterruptableTask_cancelAsynch();
                    } else {
                        AWizard.this.notifyListenersOfCancel();
                    }
                } else if (AWizard.this.fIsInterruptable && ((IInterruptableTask)AWizard.this.fWizardTask).IInterruptableTask_isActive()) {
                    ((IInterruptableTask)AWizard.this.fWizardTask).IInterruptableTask_resume();
                }
            }
            finally {
                AWizard.this.fHandlingButton = false;
            }
        }
    }

    private class WizardCompletionHandler
    implements ITaskCompletionHandler {
        private WizardCompletionHandler() {
        }

        public void ITaskCompletionHandler_taskFinished() {
            AWizard.this.showFinishedState();
            AWizard.this.notifyListenersOfCompletion();
        }

        public void ITaskCompletionHandler_taskCancelled() {
            AWizard.this.notifyListenersOfCancel();
        }

        public void ITaskCompletionHandler_taskFailed(TaskException te) {
            AWizard.this.showFinishedState();
            AWizard.this.notifyListenersOfCompletion();
        }
    }

    private class HelpAction
    extends AOneWayExtendedAction {
        private static final long serialVersionUID = -5084613817816439573L;

        public HelpAction(String localizedTitle) {
            super(localizedTitle);
        }

        public void doTriggerAction(ActionEvent actionEvent) {
            AWizard.this.doHelp();
        }
    }

    private class CancelAction
    extends AOneWayExtendedAction {
        private static final long serialVersionUID = 1254665789414626961L;

        public CancelAction(String localizedTitle) {
            super(localizedTitle);
        }

        public void doTriggerAction(ActionEvent actionEvent) {
            AWizard.this.doCancel();
        }
    }

    private class NextAction
    extends AOneWayExtendedAction {
        private static final long serialVersionUID = -7576008865936459325L;

        public NextAction(String localizedTitle) {
            super(localizedTitle);
        }

        public void doTriggerAction(ActionEvent actionEvent) {
            AWizard.this.doNext();
        }
    }

    private class PreviousAction
    extends AOneWayExtendedAction {
        private static final long serialVersionUID = -4064087158249293254L;

        public PreviousAction(String localizedTitle) {
            super(localizedTitle);
        }

        public void doTriggerAction(ActionEvent actionEvent) {
            AWizard.this.doPrevious();
        }
    }
}

