/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.feedback;

public final class SeverityLevel {
    public static final SeverityLevel OFF = new SeverityLevel("OFF", 0);
    public static final SeverityLevel FATAL = new SeverityLevel("FATAL", 0);
    public static final SeverityLevel ERROR = new SeverityLevel("ERROR", 1);
    public static final SeverityLevel WARN = new SeverityLevel("WARN", 2);
    public static final SeverityLevel INFO = new SeverityLevel("INFO", 3);
    public static final SeverityLevel VERBOSE = new SeverityLevel("VERBOSE", 4);
    public static final SeverityLevel DEBUG = new SeverityLevel("DEBUG", 5);
    public static final SeverityLevel TRACE = new SeverityLevel("TRACE", 6);
    public static final SeverityLevel ALL = new SeverityLevel("ALL", 7);
    private final String fLevelString;
    private int fLevelNumber;

    private SeverityLevel(String levelString, int number) {
        this.fLevelString = levelString;
        this.fLevelNumber = number;
    }

    public String toString() {
        return this.fLevelString;
    }

    public int compareTo(SeverityLevel level) {
        return this.fLevelNumber - level.fLevelNumber;
    }

    public boolean isLessThan(SeverityLevel level) {
        return this.fLevelNumber < level.fLevelNumber;
    }

    public static SeverityLevel getLevelByName(String name) {
        if (name == null) {
            return TRACE;
        }
        if (name.equals("OFF")) {
            return OFF;
        }
        if (name.equals("FATAL")) {
            return FATAL;
        }
        if (name.equals("ERROR")) {
            return ERROR;
        }
        if (name.equals("WARN")) {
            return WARN;
        }
        if (name.equals("INFO")) {
            return INFO;
        }
        if (name.equals("VERBOSE")) {
            return VERBOSE;
        }
        if (name.equals("DEBUG")) {
            return DEBUG;
        }
        if (name.equals("TRACE")) {
            return TRACE;
        }
        if (name.equals("ALL")) {
            return ALL;
        }
        return TRACE;
    }
}

