/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.validate;

import com.wily.util.datetime.DateTimeUtilities;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.validate.ValidationInvalidBoundedLongException;

public class ValidationInvalidQuantizedBoundedLongException
extends ValidationInvalidBoundedLongException {
    private static final long serialVersionUID = 5014876854512932229L;
    private long fQuantum;

    public ValidationInvalidQuantizedBoundedLongException(long min, long max, long quantum) {
        super(min, max);
        this.fQuantum = quantum;
    }

    public ValidationInvalidQuantizedBoundedLongException(ILocalizableMessage invalidObjectIdentifier, long min, long max, long quantum) {
        super(invalidObjectIdentifier, min, max);
        this.fQuantum = quantum;
    }

    public ILocalizableMessage getInvalidObjectRequiredCondition() {
        ILocalizableMessage quantumString = DateTimeUtilities.getHoursMinutesSecondsDuration(this.getQuantum());
        ILocalizableMessage minMessage = DateTimeUtilities.getHoursMinutesSecondsDuration(this.getMin());
        ILocalizableMessage maxMessage = DateTimeUtilities.getHoursMinutesSecondsDuration(this.getMax());
        return new FormattedLocalizableMessage("Validation_Invalid_Quantized_Bounded_Long_Condition", quantumString, minMessage, maxMessage);
    }

    private long getQuantum() {
        return this.fQuantum;
    }
}

