/*
 * Decompiled with CFR 0.152.
 */
package com.wily.wilyassert;

import com.wily.wilyassert.AssertionFailureException;
import com.wily.wilyassert.UnimplementedException;
import java.io.PrintWriter;

public class Assertion {
    public static final boolean gEnabled = true;
    private static final boolean kImmediatelyPrintAssertionFailures = false;
    private static final boolean kPrintStackTraceWithAssertionFailure = false;

    public static final boolean isEnabled() {
        return true;
    }

    public static void wilyAssert(boolean condition) {
        Assertion.handleAssertion(condition, "");
    }

    public static void wilyAssert(boolean condition, String message) {
        Assertion.handleAssertion(condition, message);
    }

    public static void wilyAssert(String message) {
        Assertion.handleAssertion(false, message);
    }

    public static void wilyFail() {
        Assertion.handleAssertion(false, "");
    }

    public static void wilyFail(String message) {
        Assertion.handleAssertion(false, message);
    }

    private static void handleAssertion(boolean condition, String message) {
        if (!condition) {
            AssertionFailureException bad = new AssertionFailureException(message);
            throw bad;
        }
    }

    private static void printUnimplemented(String message) {
        System.err.println("### Unimplemented: " + message);
    }

    private static void printAssertionFailure(String msg, AssertionFailureException bad) {
        long id = bad == null ? -1L : bad.getID();
        System.err.println("### Assertion failure[" + id + "]: " + msg);
    }

    public static void unimplemented(String message) {
        Assertion.logUnimplemented(message);
        throw new UnimplementedException(message);
    }

    public static void logUnimplemented(String message) {
    }

    public static void unimplemented() {
        Assertion.unimplemented("Unknown");
    }

    private static void printUntested(String message) {
        System.err.println("^^^ Untested: " + message);
    }

    public static void untested(String message) {
        Assertion.logUntested(message);
        throw new UnimplementedException(message);
    }

    public static void logUntested(String message) {
    }

    public static void captureCurrentStackTrace(PrintWriter writer) {
        try {
            Assertion.wilyAssert(false, "fake exception to cause a stack trace");
        }
        catch (Throwable t) {
            t.printStackTrace(writer);
        }
    }
}

