/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.http.dataresolver;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.backend.http.dataresolver.HttpDataResolver;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.util.feedback.Module;
import java.lang.reflect.Method;
import java.net.URI;

public class SpringHttpClientDataResolver
implements HttpDataResolver {
    private static Module module = new Module("Spring HTTP Client Data Resolver");
    private static final HttpDataResolver instance = new SpringHttpClientDataResolver();

    private SpringHttpClientDataResolver() {
    }

    public static HttpDataResolver getInstance() {
        return instance;
    }

    @Override
    public URI getUri(IAgent agent, InvocationData data) {
        Object invocationObject = data.getInvocationObject();
        Method getUriMethod = this.getMethodOnObject(agent, invocationObject, "getURI", new Class[0]);
        if (getUriMethod != null) {
            getUriMethod.setAccessible(true);
            try {
                return (URI)getUriMethod.invoke(invocationObject, null);
            }
            catch (Throwable e) {
                agent.IAgent_getModuleFeedback().error(module, "getURI().Unable to get the URI object :" + e);
            }
        }
        return BackendProtocolsConstants.UNKNOWN_URI;
    }

    @Override
    public String getHttpMethod(IAgent agent, InvocationData data) {
        Object invocationObject = data.getInvocationObject();
        Method getHttpMethod = this.getMethodOnObject(agent, invocationObject, "getMethod", new Class[0]);
        if (getHttpMethod != null) {
            try {
                return getHttpMethod.invoke(invocationObject, null).toString();
            }
            catch (Throwable e) {
                agent.IAgent_getModuleFeedback().error(module, "getURI().Unable to get the Http Method object :" + e);
            }
        }
        return null;
    }

    @Override
    public int getHttpStatusCode(IAgent agent, InvocationData data) {
        Object invocationObject = data.getInvocationReturnValueAsObject();
        Method statusCodeMethod = this.getMethodOnObject(agent, invocationObject, "getRawStatusCode", new Class[0]);
        if (statusCodeMethod != null) {
            try {
                Object responseCode = statusCodeMethod.invoke(invocationObject, null);
                return (Integer)responseCode;
            }
            catch (Throwable e) {
                agent.IAgent_getModuleFeedback().error(module, "getRawStatusCode() Unable to get the Method object :" + e);
            }
        }
        return -1;
    }

    @Override
    public String getHttpStatusMessage(IAgent agent, InvocationData data) {
        Object invocationObject = data.getInvocationReturnValueAsObject();
        Method statusTextMethod = this.getMethodOnObject(agent, invocationObject, "getStatusText", new Class[0]);
        if (statusTextMethod != null) {
            try {
                return (String)statusTextMethod.invoke(invocationObject, null);
            }
            catch (Throwable th) {
                agent.IAgent_getModuleFeedback().error(module, "getStatusText() Unable to get the reasonCode object :" + th);
            }
        }
        return null;
    }

    private Method getMethodOnObject(IAgent agent, Object invocationObject, String methodName, Class[] params) {
        Class<?> invocationObjectClass = invocationObject.getClass();
        try {
            Method method = invocationObjectClass.getMethod(methodName, params);
            if (method != null) {
                method.setAccessible(true);
            }
            return method;
        }
        catch (Throwable e) {
            agent.IAgent_getModuleFeedback().error(module, "Unable to get the Method object for " + methodName + " from " + invocationObjectClass.getName() + " : " + e);
            return null;
        }
    }
}

