/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.http.helper;

import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.net.HttpURLConnection;

public class HttpURLConnectionTracerHelper {
    private static final String sharedDataKey = "com.wily.introscope.agent.trace.backend.http.helper.HttpURLConnectionTracerHelper";
    private static final Module module = new Module("HttpURLConnectionTracerHelper");

    public static boolean startBackedTrace(InvocationData data, IModuleFeedbackChannel logger) {
        block6: {
            try {
                Object inputStream;
                Object sharedData = data.get(sharedDataKey);
                if (sharedData != null) {
                    return (Boolean)sharedData;
                }
                Object object = data.getInvocationObject();
                Class<?> currentClass = object.getClass();
                Class<?> currentSuperClass = currentClass.getSuperclass();
                if (object instanceof HttpURLConnection) {
                    while (currentSuperClass != HttpURLConnection.class) {
                        currentClass = currentSuperClass;
                        currentSuperClass = currentClass.getSuperclass();
                    }
                }
                if ((inputStream = ReflectionUtils.getFieldValueOfObject(currentClass, (Object)object, (String)"inputStream")) != null) break block6;
                data.put(sharedDataKey, (Object)Boolean.TRUE);
                return true;
            }
            catch (Exception e) {
                logger.error(module, "Unable to get inputStream:" + e);
                logger.error((Throwable)e);
                data.put(sharedDataKey, (Object)Boolean.FALSE);
                return false;
            }
        }
        data.put(sharedDataKey, (Object)Boolean.FALSE);
        return false;
    }

    public static boolean backendTraceStarted(InvocationData data) {
        Boolean traceWasStarted;
        Object sharedData = data.get(sharedDataKey);
        return sharedData != null && (traceWasStarted = (Boolean)sharedData) != false;
    }
}

