/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.http.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.backend.http.dataresolver.HttpDataResolver;
import com.wily.introscope.agent.trace.backend.http.dataresolver.HttpURLConnectionDataResolver;
import com.wily.introscope.agent.trace.backend.http.helper.HttpURLConnectionTracerHelper;
import com.wily.introscope.agent.trace.backend.http.tracer.BaseHttpBackendTracer;
import com.wily.introscope.agent.trace.utilities.UrlUtilities;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class HttpURLConnectionBackendTracer
extends BaseHttpBackendTracer {
    private static Module module = new Module("HttpURLConnectionBackendTracer");

    public HttpURLConnectionBackendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object tracedObject) {
        super(agent, parameters, probe, tracedObject);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (HttpURLConnectionTracerHelper.startBackedTrace(data, this.feedback)) {
            this.feedback.debug(module, "ITracer_startTrace - Starting a BACKEND Trace");
            super.ITracer_startTrace(tracerIndex, data);
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (HttpURLConnectionTracerHelper.backendTraceStarted(data)) {
            this.feedback.debug(module, "ITracer_finishTrace - Finishing a BACKEND Trace");
            super.ITracer_finishTrace(tracerIndex, data);
        }
    }

    @Override
    protected boolean generateErrorForErrorStatusCode() {
        return false;
    }

    @Override
    protected boolean showStatusCodeIfExceptionThrown() {
        return true;
    }

    @Override
    public HttpDataResolver getDataResolver() {
        return HttpURLConnectionDataResolver.getInstance();
    }

    @Override
    protected String getRawURL(String url) {
        if (url != null && !url.isEmpty()) {
            return UrlUtilities.decodeSpecialChars(url);
        }
        return url;
    }
}

