/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.jms.helper;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.backend.jms.nameformatter.JMSNameFormatter;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.adt.IWeakIdentityMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;

public class JMSHelper {
    public static final Module module = new Module("JMSHelper");
    private static final char UNDERSCORE_CHAR = '_';
    private static IWeakIdentityMap consumersOrProducersInfo = null;
    private static Class jmsQueueClass = null;
    private static Class jmsTopicClass = null;
    private static Class jmsTemporaryQueueClass = null;
    private static Class jmsTemporaryTopicClass = null;
    private static Class jmsDestinationClass = null;
    private static volatile IModuleFeedbackChannel agentFeedBackChannel;

    static {
        IAgent agent = null;
        try {
            agent = AgentShim.getAgent();
            agentFeedBackChannel = agent.IAgent_getModuleFeedback();
            consumersOrProducersInfo = agent.IAgent_getConcurrentMapFactory().getConcurrentCappedWeakIdentityMap("jmsConsumerToDestination");
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
    }

    public static void populateConsumerOrProducerDetails(Object msgConsumerOrProducer, Object jmsDestination) {
        consumersOrProducersInfo.putWeak(msgConsumerOrProducer, jmsDestination);
    }

    public static Object getDestinationInfoFromSession(Object msgConsumerOrProducer) {
        return consumersOrProducersInfo.getWeak(msgConsumerOrProducer);
    }

    public static Object getDestination(InvocationData data, IModuleFeedbackChannel logger) {
        Object dest = null;
        try {
            dest = ReflectionUtils.invokeMethodOnObject((Object)data.getInvocationParameterAsObject(0), (String)"getJMSDestination", (Class[])new Class[0], (Object[])new Object[0]);
        }
        catch (Exception e) {
            logger.error(module, "Could not get Destination Object  Exception: " + e + " Cause: " + e.getCause());
            return null;
        }
        return dest;
    }

    public static boolean isQueue(Object dest, IModuleFeedbackChannel logger) {
        boolean result = false;
        if (dest != null) {
            try {
                if (jmsQueueClass == null) {
                    jmsQueueClass = Class.forName("javax.jms.Queue", true, dest.getClass().getClassLoader());
                }
                result = jmsQueueClass.isAssignableFrom(dest.getClass());
            }
            catch (ClassNotFoundException e) {
                logger.error(module, "Could not get Class information for Queue  Exception: " + e + " Cause: " + e.getCause());
            }
        }
        return result;
    }

    private static String getWeblogicDestinationType(Object dest, IModuleFeedbackChannel logger) {
        String destinationType = "Unknown";
        try {
            try {
                boolean isQueue = (Boolean)ReflectionUtils.invokeMethodOnObject((Object)dest, (String)"isQueue", (Class[])new Class[0], (Object[])new Object[0]);
                if (isQueue) {
                    destinationType = "Queues";
                } else {
                    boolean isTopic = (Boolean)ReflectionUtils.invokeMethodOnObject((Object)dest, (String)"isTopic", (Class[])new Class[0], (Object[])new Object[0]);
                    if (isTopic) {
                        destinationType = "Topics";
                    }
                }
            }
            catch (Exception exception) {
                logger.error("Failed to find if destination being used is a Weblogic Queue");
            }
        }
        catch (Throwable throwable) {}
        return destinationType;
    }

    public static boolean isTopic(Object dest, IModuleFeedbackChannel logger) {
        boolean result = false;
        if (dest != null) {
            try {
                if (jmsTopicClass == null) {
                    jmsTopicClass = Class.forName("javax.jms.Topic", true, dest.getClass().getClassLoader());
                }
                result = jmsTopicClass.isAssignableFrom(dest.getClass());
            }
            catch (ClassNotFoundException e) {
                logger.error(module, "Could not get Class information for Queue  Exception: " + e + " Cause: " + e.getCause());
            }
        }
        return result;
    }

    public static String getQueueName(Object queue, IModuleFeedbackChannel logger) {
        String queueName = "Unknown Queue";
        if (queue != null) {
            try {
                queueName = (String)ReflectionUtils.invokeMethodOnObject((Object)queue, (String)"getQueueName", (Class[])new Class[0], (Object[])new Object[0]);
                queueName = JMSHelper.stripQueryFromName(queueName);
            }
            catch (Exception e) {
                logger.error(module, "Unable to get Queue Name Exception: " + e + " Cause: " + e.getCause());
            }
        }
        return queueName;
    }

    public static String getTopicName(Object topic, IModuleFeedbackChannel logger) {
        String topicName = "Unknown Topic";
        if (topic != null) {
            try {
                topicName = (String)ReflectionUtils.invokeMethodOnObject((Object)topic, (String)"getTopicName", (Class[])new Class[0], (Object[])new Object[0]);
                topicName = JMSHelper.stripQueryFromName(topicName);
            }
            catch (Exception e) {
                logger.error(module, "Unable to get Topic Name Exception: " + e + " Cause: " + e.getCause());
            }
        }
        return topicName;
    }

    private static String stripQueryFromName(String name) {
        int queryIndex;
        if (name != null && (queryIndex = name.indexOf("?")) != -1) {
            return name.substring(0, queryIndex);
        }
        return name;
    }

    public static boolean isDestination(Object dest, IModuleFeedbackChannel logger) {
        boolean result = false;
        if (dest != null) {
            try {
                if (jmsDestinationClass == null) {
                    jmsDestinationClass = Class.forName("javax.jms.Destination", true, dest.getClass().getClassLoader());
                }
                result = jmsDestinationClass.isAssignableFrom(dest.getClass());
            }
            catch (ClassNotFoundException e) {
                logger.error(module, "Could not get Class information for destination  Exception: " + e + " Cause: " + e.getCause());
            }
        }
        return result;
    }

    public static String getDestinationType(Object destination, IModuleFeedbackChannel feedback, InvocationData data) {
        String destinationType = (String)data.get("jms.destination.type");
        if (destinationType != null) {
            return destinationType;
        }
        destinationType = "Unknown";
        if (JMSHelper.isWeblogicDestination(destination)) {
            destinationType = JMSHelper.getWeblogicDestinationType(destination, feedback);
        } else if (JMSHelper.isQueue(destination, feedback)) {
            destinationType = "Queues";
        } else if (JMSHelper.isTopic(destination, feedback)) {
            destinationType = "Topics";
        }
        data.put("jms.destination.type", (Object)destinationType);
        return destinationType;
    }

    private static boolean isWeblogicDestination(Object destination) {
        return destination.getClass().getName().indexOf("weblogic") != -1;
    }

    public static String substituteMetricSeparatorChars(String metric) {
        String newMetric = null;
        newMetric = metric.replace(':', '_');
        newMetric = newMetric.replace('|', '_');
        return newMetric;
    }

    public static boolean isTempQueue(Object dest, IModuleFeedbackChannel logger) {
        boolean result = false;
        if (dest != null) {
            try {
                if (jmsTemporaryQueueClass == null) {
                    jmsTemporaryQueueClass = Class.forName("javax.jms.TemporaryQueue", true, dest.getClass().getClassLoader());
                }
                result = jmsTemporaryQueueClass.isAssignableFrom(dest.getClass());
            }
            catch (ClassNotFoundException e) {
                logger.error(module, "Could not get Class information for destination  Exception: " + e + " Cause: " + e.getCause());
            }
        }
        return result;
    }

    public static boolean isTempTopic(Object dest, IModuleFeedbackChannel logger) {
        boolean result = false;
        if (dest != null) {
            try {
                if (jmsTemporaryTopicClass == null) {
                    jmsTemporaryTopicClass = Class.forName("javax.jms.TemporaryTopic", true, dest.getClass().getClassLoader());
                }
                result = jmsTemporaryTopicClass.isAssignableFrom(dest.getClass());
            }
            catch (ClassNotFoundException e) {
                logger.error(module, "Could not get Class information for destination  Exception: " + e + " Cause: " + e.getCause());
            }
        }
        return result;
    }

    public static boolean isTempDestination(Object dest, IModuleFeedbackChannel logger) {
        return JMSHelper.isTempQueue(dest, logger) || JMSHelper.isTempTopic(dest, logger);
    }

    public static boolean isJMSDestinationPassedAsFirstArg(InvocationData data, IModuleFeedbackChannel logger) {
        Boolean isDestinationFirstArg = (Boolean)data.get("jms.dest.passed.as.first.arg");
        if (isDestinationFirstArg != null && isDestinationFirstArg.booleanValue()) {
            return true;
        }
        Object dest = data.getInvocationParameterAsObject(0);
        boolean isDestination = JMSHelper.isDestination(dest, logger);
        data.put("jms.dest.passed.as.first.arg", (Object)(isDestination ? Boolean.TRUE : Boolean.FALSE));
        return isDestination;
    }

    public static boolean isMessageRedeliverySet(Object jmsMsgObject, IModuleFeedbackChannel logger, InvocationData data) {
        try {
            Boolean msgReDelivered = (Boolean)ReflectionUtils.invokeMethodOnObject((Object)jmsMsgObject, (String)"getJMSRedelivered", (Class[])new Class[0], (Object[])new Object[0]);
            return msgReDelivered;
        }
        catch (Exception e) {
            logger.error(module, "Could not check for msgRedelivery property in the msg  Object  Exception: " + e + " Cause: " + e.getCause());
            return false;
        }
    }

    public static boolean shouldRunProducerTracers(InvocationData data, IModuleFeedbackChannel feedback) {
        Boolean shouldRun = (Boolean)data.get("should run");
        if (shouldRun != null) {
            return shouldRun;
        }
        String destinationNameUsingProducerAPI = JMSHelper.getDestinationNameUsingProducerAPI(data, feedback);
        shouldRun = destinationNameUsingProducerAPI != null && !"Unknown".equals(destinationNameUsingProducerAPI) || JMSHelper.getDestinationInfoFromSession(data.getInvocationObject()) != null || JMSHelper.isJMSDestinationPassedAsFirstArg(data, feedback);
        data.put("should run", (Object)shouldRun);
        return shouldRun;
    }

    public static boolean shouldRunFinishTraceOnSyncReceiver(InvocationData invocationData) {
        Boolean shouldRun = (Boolean)invocationData.get("jms.receiver.tracer.should.finish");
        if (shouldRun != null) {
            return shouldRun;
        }
        shouldRun = invocationData.getInvocationReturnValueAsObject() != null && JMSHelper.getDestinationInfoFromSession(invocationData.getInvocationObject()) != null;
        invocationData.put("jms.receiver.tracer.should.finish", (Object)shouldRun);
        return shouldRun;
    }

    public static boolean isCachedDestTypeATopic(InvocationData data) {
        String destType = (String)data.get("jms.destination.type");
        return destType != null && destType.equals("Topics");
    }

    public static boolean isCachedDestTypeAQueue(InvocationData data) {
        String destType = (String)data.get("jms.destination.type");
        return destType != null && destType.equals("Queues");
    }

    public static String getCachedDestinationName(InvocationData data) {
        String destinationName = (String)data.get("Jms.Destination.Key");
        if (destinationName != null) {
            return destinationName;
        }
        return "Unknown";
    }

    public static boolean isStackEmpty(InvocationData data) {
        Boolean result = (Boolean)data.get("jms.perinterval.is.stack.empty.key");
        if (result != null) {
            return result;
        }
        IStackElement root = VirtualStack.getTransactionCache().getRoot();
        if (root == null || root == data) {
            data.put("jms.perinterval.is.stack.empty.key", (Object)Boolean.TRUE);
            return true;
        }
        IStackElement top = VirtualStack.peek();
        IStackElement cur = top == data ? top.getParent() : top;
        boolean isStackNotEmpty = false;
        while (cur != null) {
            if (!(cur instanceof VirtualStack.DummyVirtualElement) && cur != data) {
                isStackNotEmpty = true;
                break;
            }
            cur = cur.getParent();
        }
        result = isStackNotEmpty ? Boolean.FALSE : Boolean.TRUE;
        data.put("jms.perinterval.is.stack.empty.key", (Object)result);
        return result;
    }

    public static void debug(Module moduleName, String debugMsg) {
        if (agentFeedBackChannel.isDebugEnabled()) {
            agentFeedBackChannel.debug(moduleName, debugMsg);
        }
    }

    public static void info(Module moduleName, String msg) {
        agentFeedBackChannel.info(moduleName, msg);
    }

    public static void error(Module moduleName, String msg) {
        agentFeedBackChannel.error(moduleName, msg);
    }

    public static String getDestinationNameUsingProducerAPI(InvocationData producerInvocationData, IModuleFeedbackChannel logger) {
        try {
            String destinationName = (String)producerInvocationData.get("Jms.Destination.Key");
            if (destinationName != null) {
                return destinationName;
            }
            Object jmsDestionationAsObject = ReflectionUtils.invokeMethodOnObject((Object)producerInvocationData.getInvocationObject(), (String)"getDestination", (Class[])new Class[0], (Object[])new Object[0]);
            if (jmsDestionationAsObject != null) {
                String destinationType = JMSHelper.getDestinationType(jmsDestionationAsObject, logger, producerInvocationData);
                return JMSNameFormatter.checkTempDestAndReturn(producerInvocationData, jmsDestionationAsObject, destinationType);
            }
        }
        catch (Exception e) {
            logger.debug(module, "Could not get Destination Object using JMSProducer API  Exception: " + e + " Cause: " + e.getCause());
            return "Unknown";
        }
        return "Unknown";
    }
}

