/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.correlation.jms;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.backend.jms.helper.JMSCorrelationHelper;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.trace.correlation.BackendProtocolsCorrelationTracer;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.InvocationTargetException;

public class JMSOutgoingCorrelationTracer
extends BackendProtocolsCorrelationTracer
implements BackendProtocolsConstants {
    public JMSOutgoingCorrelationTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
    }

    @Override
    public void ITracer_startTrace(int i, InvocationData invocationData) {
        boolean debug = this.logger.isDebugEnabled(this.module);
        Object message = JMSCorrelationHelper.findMessageParameter(invocationData, this.logger, this.module);
        if (message != null) {
            Object existingProperty = null;
            boolean getOk = false;
            try {
                existingProperty = ReflectionUtils.invokeMethodOnObject((Object)message, (String)"getStringProperty", (Class[])new Class[]{String.class}, (Object[])new Object[]{"CA_APM_CorID"});
                getOk = true;
            }
            catch (InvocationTargetException e) {
                this.logger.error(this.module, "getStringProperty() failed for message object (" + message + ") parameter to method: " + invocationData.getProbeInformation().getProbeIdentification().getProbeMethodName(), (Throwable)e);
            }
            catch (Throwable t) {
                this.logger.error(this.module, "Failed reflection call for getStringProperty() on message object: " + message, t);
            }
            if (getOk && existingProperty == null) {
                String correlationID = this.getOutgoingCorrelationID(invocationData);
                try {
                    ReflectionUtils.invokeMethodOnObject((Object)message, (String)"setStringProperty", (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{"CA_APM_CorID", correlationID});
                    this.setAdditionalCorrelationParameter(invocationData, correlationID, "CorJMSCrossProcessData");
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getCause();
                    this.logger.error(this.module, "setStringProperty() failed for message object (" + message + ") parameter to method: " + invocationData.getProbeInformation().getProbeIdentification().getProbeMethodName(), t);
                }
                catch (Throwable t) {
                    this.logger.error(this.module, "Failed reflection call for setStringProperty() on message object: " + message, t);
                }
            } else if (debug) {
                this.logger.debug(this.module, "The message object already has Correlation ID string property: " + existingProperty);
            }
        } else {
            this.logger.error(this.module, "No non-null parameter found that is assignable to javax.jms.Message for method: " + invocationData.getProbeInformation().getProbeIdentification().getProbeMethodName());
        }
    }

    @Override
    public void ITracer_finishTrace(int i, InvocationData invocationData) {
        this.unGetOutgoingCorrelationID(invocationData);
    }
}

