/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.db;

import com.wily.diagnos.cmp.batch.DGFileSettings;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.log.ISummaryInfo;
import com.wily.diagnos.cmp.tracer.MethodTracer;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.db.ConnectionManager;
import com.wily.introscope.agent.db.DatabaseStoreDelegate;
import com.wily.introscope.agent.db.IConnectionManager;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import java.util.ArrayList;
import java.util.List;

public class DGCompilerMemoryLog
implements ICompilerLog {
    private int countLogMethodNotTraced;
    private int countLogMethodTraced;
    private int countLogClassTraced;
    private int countLogSkippedMethodDetails;
    private int countLogSkippedClassDetails;
    private int countLogMethodTracer;
    private List fMethodsTraced = new ArrayList();
    private List fMethodsNotTraced = new ArrayList();
    private List fClassTraced = new ArrayList();
    private List fMethodTracers = new ArrayList();
    private IConnectionManager manager = null;
    private int kBatchSize = 25000;
    private boolean kStoreClassSkip = false;

    public DGCompilerMemoryLog(IAgent agent) {
        this.kBatchSize = agent.IAgent_getIndexedProperties().safeGetIntProperty("introscope.agent.remoteagentdynamicinstrumentation.logBatchSize", 2500, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        this.kStoreClassSkip = agent.IAgent_getIndexedProperties().safeGetBooleanProperty("introscope.agent.remoteagentdynamicinstrumentation.storeSkips", false, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
    }

    public void ICompilerLog_logMethodTraced(IModeledMethod m) {
        if (this.getManager() != null) {
            this.setCountLogMethodNotTraced(this.getCountLogMethodNotTraced() + 1);
            this.logMethodTraced(m);
        }
    }

    public void ICompilerLog_logClassTraced(String className) {
        if (this.getManager() != null) {
            this.setCountLogClassTraced(this.getCountLogClassTraced() + 1);
            this.logClassTraced(className);
        }
    }

    public void ICompilerLog_logMethodCalls(IModeledMethod method, List methodCalls) {
        if (this.getManager() != null) {
            this.setCountLogMethodTraced(this.getCountLogMethodTraced() + 1);
            this.logMethodNotTraced(method, methodCalls);
        }
    }

    public void ICompilerLog_logMethodTracer(IModeledMethod method, int lineNumber, MethodTracer tracer) {
        if (this.getManager() != null) {
            this.setCountLogMethodTracer(this.getCountLogMethodTracer() + 1);
            this.logMethodTracers(method, tracer);
        }
    }

    public void logPermanentDirectiveInfo(IClassName className, String methodName, String tracerName, String tracerGroupName, String tracerParameters, String tracerClass, String tracerResource) {
        DatabaseStoreDelegate.storeSpecialMethodsTracers(className, methodName, tracerName, tracerGroupName, tracerParameters, tracerClass, tracerResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMethodTraced(IModeledMethod m) {
        List list = this.fMethodsTraced;
        synchronized (list) {
            this.fMethodsTraced.add(m);
            if (this.fMethodsTraced.size() > this.kBatchSize) {
                DatabaseStoreDelegate.storeMethodsTraced(this.fMethodsTraced);
                this.fMethodsTraced.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMethodNotTraced(IModeledMethod m, List methodCalls) {
        List list = this.fMethodsNotTraced;
        synchronized (list) {
            this.fMethodsNotTraced.add(m);
            this.fMethodsNotTraced.add(methodCalls);
            if (this.fMethodsNotTraced.size() > this.kBatchSize) {
                DatabaseStoreDelegate.storeMethodsNotTraced(this.fMethodsNotTraced);
                this.fMethodsNotTraced.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logClassTraced(String className) {
        List list = this.fClassTraced;
        synchronized (list) {
            this.fClassTraced.add(className);
            if (this.fClassTraced.size() > this.kBatchSize) {
                DatabaseStoreDelegate.storeClassesTraced(this.fClassTraced);
                this.fClassTraced.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMethodTracers(IModeledMethod method, MethodTracer tracer) {
        List list = this.fMethodTracers;
        synchronized (list) {
            this.fMethodTracers.add(method);
            this.fMethodTracers.add(tracer);
            if (this.fMethodTracers.size() > this.kBatchSize) {
                DatabaseStoreDelegate.storeMethodsTracers(this.fMethodTracers);
                this.fMethodTracers.clear();
            }
        }
    }

    public void ICompilerLog_close() {
    }

    public void ICompilerLog_dumpFile(String context, String filename, List contents) {
    }

    public void ICompilerLog_finishAborted(String element) {
    }

    public void ICompilerLog_finishArchive(String archive) {
    }

    public void ICompilerLog_finishDirectory(String directory) {
    }

    public void ICompilerLog_finishException(String element) {
    }

    public String ICompilerLog_getPath() {
        return null;
    }

    public ISummaryInfo ICompilerLog_getSummaryInfo() {
        return null;
    }

    public void ICompilerLog_logClassAlreadyInstrumented() {
    }

    public void ICompilerLog_logDetails(CompilerLogDetails details) {
    }

    public void ICompilerLog_logClassSubstitution(IModeledMethod method, int lineNumber, String originalClassName, String substituteClassName) {
    }

    public void ICompilerLog_logErrorMessage(String error) {
    }

    public void ICompilerLog_logException(Throwable e) {
    }

    public void ICompilerLog_logException(String context, Throwable e) {
    }

    public void ICompilerLog_logFileSettings(DGFileSettings fileSettings) {
    }

    public void ICompilerLog_logHeader(String copyright, String releaseAndBuildVersion, String dgVersion) {
    }

    public void ICompilerLog_logInheritanceChange(IClassName originalSuperClass, IClassName newSuperClass) {
    }

    public void ICompilerLog_logInstrumentation(IModeledMethod method, int lineNumber, String fullyQualifiedMethodName) {
    }

    public void ICompilerLog_logInternalError(IModeledMethod method, int lineNumber, String msg) {
    }

    public void ICompilerLog_logInvalidSettings(String specifics) {
    }

    public void ICompilerLog_logMemberReferenceChange(String originalMember, String newMember) {
    }

    public void ICompilerLog_logMessage(String message) {
    }

    public void ICompilerLog_logNoticeConstructorCompletion(IModeledMethod method, String notificationMethod) {
    }

    public void ICompilerLog_logNoticeFieldAssignment(IModeledMethod method, String fieldClass, String fieldName, IClassName notificationClass) {
    }

    public void ICompilerLog_logNoticeObjectCreation(IModeledMethod method, String createdType, IClassName notificationClass) {
    }

    public void ICompilerLog_logSkippedBootstrapClass(String className) {
    }

    public void ICompilerLog_logSkippedClass(String className) {
    }

    public void ICompilerLog_logSkippedClassForFlag(String flagName) {
    }

    public void ICompilerLog_logSkippedMethod(IClassName className, IMethodName methodName) {
    }

    public void ICompilerLog_logStartupCallInsertion(IModeledMethod method, int lineNumber, IClassName traceClassName) {
    }

    public void ICompilerLog_logSubstituteResult(IModeledMethod method, String substituteMethod) {
    }

    public void ICompilerLog_logTitleMessage(String title) {
    }

    public void ICompilerLog_setCopiedFile(String filename) {
    }

    public void ICompilerLog_setCurrentClass(IClassName className) {
    }

    public void ICompilerLog_setCurrentMethod(IClassName className, IMethodName methodName) {
    }

    public void ICompilerLog_setSkippedClass(IClassName className) {
    }

    public void ICompilerLog_setSkippedFile(String filename) {
    }

    public void ICompilerLog_startArchive(String archive) {
    }

    public void ICompilerLog_startDirectory(String directory) {
    }

    public void ICompilerLog_suggestFlush() {
        this.executeDatabaseFlush(true);
    }

    private IConnectionManager getManager() {
        if (this.manager == null) {
            this.manager = ConnectionManager.Instance();
        }
        return this.manager;
    }

    private void setCountLogMethodNotTraced(int countLogMethodNotTraced) {
        this.countLogMethodNotTraced = countLogMethodNotTraced;
    }

    private int getCountLogMethodNotTraced() {
        return this.countLogMethodNotTraced;
    }

    private void setCountLogMethodTraced(int countLogMethodTraced) {
        this.countLogMethodTraced = countLogMethodTraced;
    }

    private int getCountLogMethodTraced() {
        return this.countLogMethodTraced;
    }

    private void setCountLogClassTraced(int countLogClassTraced) {
        this.countLogClassTraced = countLogClassTraced;
    }

    private int getCountLogClassTraced() {
        return this.countLogClassTraced;
    }

    private void setCountLogMethodTracer(int countLogMethodTracer) {
        this.countLogMethodTracer = countLogMethodTracer;
    }

    private int getCountLogMethodTracer() {
        return this.countLogMethodTracer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDatabaseFlush(boolean immediate) {
        List list = this.fClassTraced;
        synchronized (list) {
            DatabaseStoreDelegate.storeClassesTraced(this.fClassTraced);
            this.fClassTraced.clear();
        }
        list = this.fMethodsNotTraced;
        synchronized (list) {
            DatabaseStoreDelegate.storeMethodsNotTraced(this.fMethodsNotTraced);
            this.fMethodsNotTraced.clear();
        }
        list = this.fMethodsTraced;
        synchronized (list) {
            DatabaseStoreDelegate.storeMethodsTraced(this.fMethodsTraced);
            this.fMethodsTraced.clear();
        }
        list = this.fMethodTracers;
        synchronized (list) {
            DatabaseStoreDelegate.storeMethodsTracers(this.fMethodTracers);
            this.fMethodTracers.clear();
        }
    }

    public boolean ICompilerLog_isLogDynamicInstrEnabled() {
        return true;
    }

    public void ICompilerLog_saveLastMutatedClass(IModeledClass mutatedClass) {
    }

    public void ICompilerLog_logLastMutatedClass() {
    }
}

