/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.db;

import com.wily.diagnos.cmp.classfile.DGClassLoadingException;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.TracerName;
import com.wily.diagnos.cmp.directives.apply.ClassSettingsApplier;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.log.NullCompilerLog;
import com.wily.diagnos.cmp.tracer.MethodTracer;
import com.wily.diagnos.personality.ICompilerPersonality;
import com.wily.diagnos.personality.NativePersonality;
import com.wily.diagnos.personality.java.classfile.DGClass;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.db.ClassMethodId;
import com.wily.introscope.agent.db.CompilerLogDatabaseTransaction;
import com.wily.introscope.agent.db.ConnectionManager;
import com.wily.introscope.agent.db.DGCompilerMemoryLog;
import com.wily.introscope.agent.db.DatabaseResult;
import com.wily.introscope.agent.db.IDynamicInstrumentationDatabaseConstants;
import com.wily.introscope.agent.db.directives.DatabaseDirectiveInfo;
import com.wily.introscope.agent.db.directives.DatabaseDynamicDirectivesService;
import com.wily.introscope.agent.transformer.dynamic.IClassRedefinitionCallback;
import com.wily.introscope.agent.transformer.dynamic.IDeepInheritanceHelper;
import com.wily.introscope.agent.transformer.dynamic.IDynamicDirectivesService;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationDelegate;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.agent.util.ByteClassUtil;
import com.wily.introscope.autoprobe.IAutoProbeConfig;
import com.wily.introscope.autoprobe.ICompilerLogger;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.ConditionalInstrumentationInfo;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.DynamicDirectivesResult;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.DynamicInstrumentationResult;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.GroupInstrumentationInfo;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.GroupInstrumentationInfoResult;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.IDynamicInstrumentationListener;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.InstrumentationInfo;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.InstrumentationInfoResult;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.MethodCallsResult;
import com.wily.introscope.spec.server.beans.dynamicinstrumentationtrace.UnsupportedDIOperationException;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.InvalidMethodNameException;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.classfile.java.MethodName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.wilyassert.Assertion;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseQueryDelegate
implements IDynamicInstrumentationDelegate,
IClassRedefinitionCallback,
IDynamicInstrumentationDatabaseConstants {
    private static final String kUndefinedLabelName = "Undefined";
    private static final String kAnchorTracerName = "ConditionalAnchorTracer";
    private static final Module kModule = new Module("DatabaseQueryDelegate");
    private static final String kInsertIntoDirectivesValuesDefault = "insert into directive values (DEFAULT, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String kSelectDirectives = "select directive.directive_id, calledClassTable.class_name, calledMethodTable.method_name, directive.resource_name, directive.tracer_type, directive.group_name, directive.is_permanent, directive.label, directive.directive_type, calledClassTable.is_Interface, callingClassTable.class_name as calling_Class_name, callingMethodTable.method_name as calling_method_name from directive join method as calledMethodTable on directive.method_id = calledMethodTable.method_id join class as calledClassTable on calledClassTable.class_id = calledMethodTable.class_id left join method as callingMethodTable on directive.calling_method_id = callingMethodTable.method_id left join class as callingClassTable on callingClassTable.class_id = callingMethodTable.class_id where directive.is_active = ? and (directive.directive_type = 0 or directive.directive_type = 2 or directive.directive_type = 3 or directive.directive_type = 4 or directive.directive_type = 5)";
    private static final String kSelectDirectivesByGroupName = "select directive.directive_id, calledClassTable.class_name, calledMethodTable.method_name, directive.resource_name, directive.tracer_type, directive.group_name, directive.is_permanent, directive.label, directive.directive_type, calledClassTable.is_Interface, callingClassTable.class_name as calling_Class_name, callingMethodTable.method_name as calling_method_name from directive join method as calledMethodTable on directive.method_id = calledMethodTable.method_id join class as calledClassTable on calledClassTable.class_id = calledMethodTable.class_id left join method as callingMethodTable on directive.calling_method_id = callingMethodTable.method_id left join class as callingClassTable on callingClassTable.class_id = callingMethodTable.class_id where directive.is_active = ? and (directive.directive_type = 0 or directive.directive_type = 2 or directive.directive_type = 3 or directive.directive_type = 4 or directive.directive_type = 5) and directive.Group_name = ?";
    private static final String kSelectGroupDirectives = "select directive.directive_id, directive.Group_name, directive.label, directive.is_Permanent, directive.is_Active, directive.is_static_active from directive where directive.directive_type = 1";
    private static final String kSelectGroupDirectivesByName = "select directive.directive_id, directive.Group_name, directive.label, directive.is_Permanent, directive.is_Active, directive.is_static_active from directive where directive.directive_type = 1 and directive.Group_Name = ?";
    private static final String kSelectDirectivesById = "select directive.directive_id, calledClassTable.class_name, calledMethodTable.method_name, directive.resource_name, directive.tracer_type, directive.group_name, directive.is_permanent, directive.label, directive.directive_type, calledClassTable.is_Interface, callingClassTable.class_name as calling_Class_name, callingMethodTable.method_name as calling_method_name from directive join method as calledMethodTable on directive.method_id = calledMethodTable.method_id join class as calledClassTable on calledClassTable.class_id = calledMethodTable.class_id left join method as callingMethodTable on directive.calling_method_id = callingMethodTable.method_id left join class as callingClassTable on callingClassTable.class_id = callingMethodTable.class_id where directive.is_active = ? and (directive.directive_type = 0 or directive.directive_type = 2 or directive.directive_type = 3 or directive.directive_type = 4 or directive.directive_type = 5) and directive.directive_id = ?";
    private static final String kSelectDirectivesByLabel = "select directive.directive_id, calledClassTable.class_name, calledMethodTable.method_name, directive.resource_name, directive.tracer_type, directive.group_name, directive.is_permanent, directive.label, directive.directive_type, calledClassTable.is_Interface, callingClassTable.class_name as calling_Class_name, callingMethodTable.method_name as calling_method_name from directive join method as calledMethodTable on directive.method_id = calledMethodTable.method_id join class as calledClassTable on calledClassTable.class_id = calledMethodTable.class_id left join method as callingMethodTable on directive.calling_method_id = callingMethodTable.method_id left join class as callingClassTable on callingClassTable.class_id = callingMethodTable.class_id where directive.is_active = ? and (directive.directive_type = 0 or directive.directive_type = 2 or directive.directive_type = 3 or directive.directive_type = 4 or directive.directive_type = 5) and directive.label = ? ";
    private static final String kSelectDirectivesByClassAndMethod = "select directive.directive_id, calledClassTable.class_name, calledMethodTable.method_name, directive.resource_name, directive.tracer_type, directive.group_name, directive.is_permanent, directive.label, directive.directive_type, calledClassTable.is_Interface, callingClassTable.class_name as calling_Class_name, callingMethodTable.method_name as calling_method_name from directive join method as calledMethodTable on directive.method_id = calledMethodTable.method_id join class as calledClassTable on calledClassTable.class_id = calledMethodTable.class_id left join method as callingMethodTable on directive.calling_method_id = callingMethodTable.method_id left join class as callingClassTable on callingClassTable.class_id = callingMethodTable.class_id where directive.is_active = ? and (directive.directive_type = 0 or directive.directive_type = 2 or directive.directive_type = 3 or directive.directive_type = 4 or directive.directive_type = 5) and calledClassTable.class_name = ? and calledMethodTable.method_name = ? ";
    private static final String kSelectGroupDirectivesByLabel = "select directive.directive_id, directive.Group_name, directive.label, directive.is_Permanent, directive.is_Active, directive.is_static_active from directive where directive.directive_type = 1 and directive.label = ? ";
    private static final String kSelectInstrumentationInfo = "select distinct method_trace.tracer_name, method_trace.tracer_resource, method_trace.tracer_group_name, method_trace.tracer_parameters, directive.Label, class.Class_name, method.Method_name, directive.is_active, directive.is_permanent, directive.directive_id, class.is_Interface, directive.directive_type, callingClassTable.class_name as calling_Class_name, callingMethodTable.method_name as calling_method_name  from method_trace left join directive on directive.resource_name = method_trace.tracer_resource and method_trace.tracer_name = directive.tracer_type and directive.method_id = method_trace.method_id  join method on method_trace.method_id = method.method_id join class on class.class_id = method.class_id left join method as callingMethodTable on directive.calling_method_id = callingMethodTable.method_id left join class as callingClassTable on callingClassTable.class_id = callingMethodTable.class_id";
    private static final String kSelectInstrumentationInfoByClassAndMethodClause = " method.method_name = ? and class.class_name = ? ";
    private static final String kSelectInstrumentationInfoByAllDetailsClause = " method.method_name = ? and class.class_name = ?  and method_trace.tracer_name = ? and method_trace.tracer_resource = ? and method_trace.tracer_group_name = ?";
    private static final String kSelectInstrumentationInfoByLabelClause = " directive.label = ? ";
    private static final String kSelectInstrumentationInfoByGroupClause = " method_trace.tracer_group_name = ? ";
    private static final String kSelectInstrumentationInfoActiveClause = " directive.is_active = ? ";
    private static final String kSelectInstrumentationInfoActiveClauseForByClassAndMethodClause = " directive.is_active = ? ";
    private static final String kSelectInstrumentationInfoNullActiveClauseForByClassAndMethodClause = " directive.is_active is null ";
    private boolean fCanRun = true;
    private IDynamicInstrumentationTransformer fTransformer;

    public DynamicInstrumentationResult getMethodCalls(final String metric) {
        final ArrayList list = new ArrayList();
        MethodCallsResult result = new MethodCallsResult();
        result.importAll((DynamicInstrumentationResult)new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                ICompilerPersonality personality = NativePersonality.getNativePersonality();
                String tracerName = "name=" + metric;
                String statement = "select distinct methodcall.class_name, methodcall.method_name, methodcall.METHOD_TYPE from method_trace join method on method_trace.method_id = method.method_id join class on method.class_id = class.class_id join methodcall on methodcall.method_id = method.method_id where method_trace.tracer_parameters like ?";
                PreparedStatement s = this.getPreparedStatement(statement);
                s.setString(1, tracerName);
                ResultSet rs = s.executeQuery();
                while (rs.next()) {
                    String className = rs.getString(1);
                    String methodName = rs.getString(2);
                    String methodType = rs.getString(3);
                    try {
                        IClassName iClassName = personality.getClassSchemaPolicy().getClassName(className);
                        IMethodName iMethodName = personality.getClassSchemaPolicy().getMethodName(methodName);
                        DynamicInstrumentationResult.ClassMethodPair pair = new DynamicInstrumentationResult.ClassMethodPair(iClassName.getReflectionFriendlyQualifiedNameString(), String.valueOf(iMethodName.getNameAndSignatureString()) + methodType);
                        list.add(pair);
                    }
                    catch (InvalidClassNameException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidMethodDescriptorException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidMethodNameException e) {
                        e.printStackTrace();
                    }
                }
                this.feedback.trace(kModule, "getMethodCalls complete");
            }
        }.executeTransaction());
        if (!result.isError()) {
            result.setMethodCalls(list);
        }
        return result;
    }

    public DynamicDirectivesResult getDynamicDirectiveCollection() {
        final ArrayList list = new ArrayList();
        DynamicDirectivesResult result = new DynamicDirectivesResult();
        result.importAll((DynamicInstrumentationResult)new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                DatabaseDirectiveInfo info;
                PreparedStatement s = this.getPreparedStatement(DatabaseQueryDelegate.kSelectDirectives);
                s.setInt(1, 0);
                ResultSet rs = s.executeQuery();
                while (rs.next()) {
                    info = DatabaseQueryDelegate.this.getDatabaseTracerDirectiveInfo(rs);
                    list.add(info);
                }
                s = this.getPreparedStatement(DatabaseQueryDelegate.kSelectGroupDirectives);
                rs = s.executeQuery();
                while (rs.next()) {
                    info = DatabaseQueryDelegate.this.getDatabaseGroupDirectiveInfo(rs);
                    list.add(info);
                }
                this.feedback.trace(kModule, "getDynamicDirectiveCollection complete");
            }
        }.executeTransaction());
        if (!result.isError()) {
            result.setDynamicDirectiveCollection(list);
        }
        return result;
    }

    public DynamicDirectivesResult getDynamicDirectiveById(final int id) {
        final ArrayList list = new ArrayList();
        DynamicDirectivesResult result = new DynamicDirectivesResult();
        result.importAll((DynamicInstrumentationResult)new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                PreparedStatement s = this.getPreparedStatement(DatabaseQueryDelegate.kSelectDirectivesById);
                s.setInt(1, 0);
                s.setInt(2, id);
                ResultSet rs = s.executeQuery();
                while (rs.next()) {
                    DatabaseDirectiveInfo info = DatabaseQueryDelegate.this.getDatabaseTracerDirectiveInfo(rs);
                    list.add(info);
                }
                this.feedback.trace(kModule, "getDynamicDirectiveById complete");
            }
        }.executeTransaction());
        if (!result.isError() && list.size() > 0) {
            result.setDynamicDirectiveCollection(list);
        } else if (!result.isError() && list.size() == 0) {
            result.setException((Throwable)new SQLException("Cannot find directive with id = " + id));
        }
        return result;
    }

    public DynamicDirectivesResult getDynamicDirectiveCollectionByLabel(final String label) {
        if (label == null) {
            return this.getDynamicDirectiveCollection();
        }
        final ArrayList list = new ArrayList();
        DynamicDirectivesResult result = new DynamicDirectivesResult();
        result.importAll((DynamicInstrumentationResult)new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                DatabaseDirectiveInfo info;
                PreparedStatement s = this.getPreparedStatement(DatabaseQueryDelegate.kSelectDirectivesByLabel);
                s.setInt(1, 0);
                s.setString(2, label);
                ResultSet rs = s.executeQuery();
                while (rs.next()) {
                    info = DatabaseQueryDelegate.this.getDatabaseTracerDirectiveInfo(rs);
                    list.add(info);
                }
                s = this.getPreparedStatement(DatabaseQueryDelegate.kSelectGroupDirectivesByLabel);
                s.setString(1, label);
                rs = s.executeQuery();
                while (rs.next()) {
                    info = DatabaseQueryDelegate.this.getDatabaseGroupDirectiveInfo(rs);
                    list.add(info);
                }
                this.feedback.trace(kModule, "getDynamicDirectiveByLabel complete");
            }
        }.executeTransaction());
        if (!result.isError() && list.size() > 0) {
            result.setDynamicDirectiveCollection(list);
        }
        return result;
    }

    public DynamicDirectivesResult getDynamicDirectiveCollectionByClassMethod(IClassName iClassName, IMethodName iMethodName) {
        final ArrayList list = new ArrayList();
        final String className = iClassName.getPackageAndNameString();
        final String methodName = iMethodName.getNameAndSignatureString();
        DynamicDirectivesResult result = new DynamicDirectivesResult();
        result.importAll((DynamicInstrumentationResult)new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                PreparedStatement s = this.getPreparedStatement(DatabaseQueryDelegate.kSelectDirectivesByClassAndMethod);
                s.setInt(1, 0);
                s.setString(2, className);
                s.setString(3, methodName);
                ResultSet rs = s.executeQuery();
                while (rs.next()) {
                    DatabaseDirectiveInfo info = DatabaseQueryDelegate.this.getDatabaseTracerDirectiveInfo(rs);
                    list.add(info);
                }
                this.feedback.trace(kModule, "getDynamicDirectiveCollectionByClassMethod complete");
            }
        }.executeTransaction());
        if (!result.isError() && list.size() > 0) {
            result.setDynamicDirectiveCollection(list);
        }
        return result;
    }

    public DynamicDirectivesResult setDynamicDirectiveLabel(final int id, final String label) {
        DynamicDirectivesResult result = new DynamicDirectivesResult();
        result.importAll((DynamicInstrumentationResult)new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                PreparedStatement createClass = this.getPreparedStatement("update directive set label = ? where directive_id = ?");
                createClass.setInt(2, id);
                createClass.setString(1, label);
                createClass.execute();
                this.feedback.trace(kModule, "setDynamicDirectiveLabel complete");
            }
        }.executeTransaction());
        return result;
    }

    public DynamicDirectivesResult setDynamicDirectiveStatus(final int id, final int status) {
        DynamicDirectivesResult result = new DynamicDirectivesResult();
        result.importAll((DynamicInstrumentationResult)new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                PreparedStatement createClass = this.getPreparedStatement("update directive set is_active = ? where directive_id = ?");
                createClass.setInt(2, id);
                createClass.setInt(1, status);
                createClass.execute();
                this.feedback.trace(kModule, "setDynamicDirectiveStatus complete");
            }
        }.executeTransaction());
        return result;
    }

    public DynamicDirectivesResult setTemporaryDynamicDirectiveNotActive(final int id) {
        DynamicDirectivesResult result = new DynamicDirectivesResult();
        final int[] updateCount = new int[1];
        result.importAll((DynamicInstrumentationResult)new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                PreparedStatement createClass = this.getPreparedStatement("update directive set is_active = ? where directive_id = ? and is_Permanent = ?");
                createClass.setInt(2, id);
                createClass.setInt(1, 1);
                createClass.setInt(3, 1);
                updateCount[0] = createClass.executeUpdate();
                this.feedback.trace(kModule, "setDynamicDirectiveStatus complete");
            }
        }.executeTransaction());
        if (updateCount[0] == 0) {
            result.setStatus(114);
        }
        return result;
    }

    public DynamicDirectivesResult setDynamicDirectivePermanent(final DatabaseDirectiveInfo info) {
        DynamicDirectivesResult result = new DynamicDirectivesResult();
        final String newDirectiveType = this.getPermanentDirectiveType(info);
        result.importAll((DynamicInstrumentationResult)new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                PreparedStatement createClass = this.getPreparedStatement("update directive set is_permanent = ?, tracer_type = ?, calling_method_id = null where directive_id = ?");
                createClass.setInt(1, 0);
                createClass.setString(2, newDirectiveType);
                createClass.setInt(3, info.getLineNumber());
                createClass.execute();
                createClass = this.getPreparedStatement("Update directive type", "update directive set directive_type = ? where directive_id = ? and directive_type = ?");
                createClass.setInt(1, 0);
                createClass.setInt(3, 4);
                createClass.setInt(2, info.getLineNumber());
                createClass.execute();
                createClass.setInt(1, 2);
                createClass.setInt(3, 6);
                createClass.setInt(2, info.getLineNumber());
                createClass.execute();
                createClass.setInt(1, 3);
                createClass.setInt(3, 5);
                createClass.setInt(2, info.getLineNumber());
                createClass.execute();
                this.feedback.trace(kModule, "setDynamicDirectivePermanent complete");
            }
        }.executeTransaction());
        return result;
    }

    private String getPermanentDirectiveType(DatabaseDirectiveInfo info) {
        String dynamicType = info.getTracerType();
        boolean isConditional = info.getCallingClassName() != null;
        return this.getPermanentDirectiveType(dynamicType, isConditional);
    }

    private String getPermanentDirectiveType(String dynamicType, boolean isConditional) {
        if (dynamicType != null && dynamicType.startsWith("Dynamic")) {
            dynamicType = dynamicType.substring(7);
            if (isConditional) {
                dynamicType = "Conditional" + dynamicType;
            }
        }
        return dynamicType;
    }

    private InstrumentationInfoResult getInstrumentationWithHelper(final GetInstrumentationInfoHelper helper) {
        InstrumentationInfoResult result = helper.preflight();
        if (result.isError()) {
            return result;
        }
        final ArrayList<InstrumentationInfo> infos = new ArrayList<InstrumentationInfo>();
        result.importAll((DynamicInstrumentationResult)new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                PreparedStatement s = this.getPreparedStatement(helper.getStatementString());
                helper.setStatementParameters(s);
                ResultSet rs = s.executeQuery();
                helper.extractInfo(infos, rs);
                this.feedback.trace(kModule, "getInstrumentationInfo complete");
            }
        }.executeTransaction());
        if (!result.isError()) {
            helper.postflight(result, infos);
        }
        return result;
    }

    public InstrumentationInfoResult getInstrumentationInfo(final IClassName iClassName, final IMethodName iMethodName, final String tracerType, final String ResourceName, final String GroupName, final boolean alsoInactive) {
        GetInstrumentationInfoHelper helper = new GetInstrumentationInfoHelper(this){

            @Override
            public String getStatementString() {
                String result = "select distinct method_trace.tracer_name, method_trace.tracer_resource, method_trace.tracer_group_name, method_trace.tracer_parameters, directive.Label, class.Class_name, method.Method_name, directive.is_active, directive.is_permanent, directive.directive_id, class.is_Interface, directive.directive_type, callingClassTable.class_name as calling_Class_name, callingMethodTable.method_name as calling_method_name  from method_trace left join directive on directive.resource_name = method_trace.tracer_resource and method_trace.tracer_name = directive.tracer_type and directive.method_id = method_trace.method_id  join method on method_trace.method_id = method.method_id join class on class.class_id = method.class_id left join method as callingMethodTable on directive.calling_method_id = callingMethodTable.method_id left join class as callingClassTable on callingClassTable.class_id = callingMethodTable.class_id where  method.method_name = ? and class.class_name = ?  and method_trace.tracer_name = ? and method_trace.tracer_resource = ? and method_trace.tracer_group_name = ?";
                if (!alsoInactive) {
                    result = String.valueOf(result) + " and " + " directive.is_active = ? ";
                }
                return result;
            }

            @Override
            public void postflight(InstrumentationInfoResult result, List<InstrumentationInfo> infos) {
                result.addIntrumentationInfo(infos);
            }

            @Override
            public InstrumentationInfoResult preflight() {
                InstrumentationInfoResult result = this.checkAndInitializeClass(new InstrumentationInfoResult(), iClassName);
                return result;
            }

            @Override
            public void extractInfo(List<InstrumentationInfo> infos, ResultSet rs) throws SQLException {
                this.extractFullInstrumentationInfoFromResultSet(infos, rs);
            }

            @Override
            public void setStatementParameters(PreparedStatement s) throws SQLException {
                String className = iClassName.getPackageAndNameString();
                String methodName = iMethodName.getNameAndSignatureString();
                s.setString(1, methodName);
                s.setString(2, className);
                s.setString(3, tracerType);
                s.setString(4, ResourceName);
                s.setString(5, GroupName);
                if (!alsoInactive) {
                    s.setInt(6, 0);
                }
            }
        };
        return this.getInstrumentationWithHelper(helper);
    }

    public InstrumentationInfoResult getInstrumentationInfo(final IClassName iClassName, final IMethodName iMethodName, final boolean alsoInactive) {
        GetInstrumentationInfoHelper helper = new GetInstrumentationInfoHelper(this){

            @Override
            public String getStatementString() {
                String result = "select distinct method_trace.tracer_name, method_trace.tracer_resource, method_trace.tracer_group_name, method_trace.tracer_parameters, directive.Label, class.Class_name, method.Method_name, directive.is_active, directive.is_permanent, directive.directive_id, class.is_Interface, directive.directive_type, callingClassTable.class_name as calling_Class_name, callingMethodTable.method_name as calling_method_name  from method_trace left join directive on directive.resource_name = method_trace.tracer_resource and method_trace.tracer_name = directive.tracer_type and directive.method_id = method_trace.method_id  join method on method_trace.method_id = method.method_id join class on class.class_id = method.class_id left join method as callingMethodTable on directive.calling_method_id = callingMethodTable.method_id left join class as callingClassTable on callingClassTable.class_id = callingMethodTable.class_id where ";
                result = !alsoInactive ? String.valueOf(result) + "(" + DatabaseQueryDelegate.kSelectInstrumentationInfoByClassAndMethodClause + " and " + " directive.is_active = ? " + " ) or ( " + DatabaseQueryDelegate.kSelectInstrumentationInfoByClassAndMethodClause + " and " + DatabaseQueryDelegate.kSelectInstrumentationInfoNullActiveClauseForByClassAndMethodClause + " )" : String.valueOf(result) + DatabaseQueryDelegate.kSelectInstrumentationInfoByClassAndMethodClause;
                return result;
            }

            @Override
            public void postflight(InstrumentationInfoResult result, List<InstrumentationInfo> target) {
                DynamicDirectivesResult resultFromDirectives = this.getDynamicDirectiveCollectionByClassMethod(iClassName, iMethodName);
                if (!resultFromDirectives.isError() && resultFromDirectives.getDynamicDirectiveCollection() != null) {
                    for (DatabaseDirectiveInfo info : resultFromDirectives.getDynamicDirectiveCollection()) {
                        boolean activeNotContainedInInfo = true;
                        for (InstrumentationInfo infoInTracerResult : target) {
                            if (!infoInTracerResult.getResourceName().equals(info.getResourceName())) continue;
                            activeNotContainedInInfo = false;
                            break;
                        }
                        if (!activeNotContainedInInfo) continue;
                        Object additionalInfo = null;
                        additionalInfo = info.getDirectiveType() == 4 || info.getDirectiveType() == 5 || info.getDirectiveType() == 6 ? new ConditionalInstrumentationInfo() : new InstrumentationInfo();
                        additionalInfo.setActive(false);
                        additionalInfo.setClassName(info.getClassName());
                        additionalInfo.setGroupName(info.getGroupName());
                        additionalInfo.setLabelName(info.getLabel());
                        additionalInfo.setLineNumber(info.getLineNumber());
                        additionalInfo.setMethodName(info.getMethodName());
                        additionalInfo.setPermanent(info.isPermanent());
                        additionalInfo.setTemporary(info.isTemporary());
                        additionalInfo.setResourceName(info.getResourceName());
                        additionalInfo.setTracerType(info.getTracerType());
                        additionalInfo.setInherited(info.getDirectiveType() == 2 || info.getDirectiveType() == 6);
                        additionalInfo.setAffectingClassTree(info.isInterface() || this.isAffectingTreeByType(info));
                        if (additionalInfo instanceof ConditionalInstrumentationInfo) {
                            additionalInfo.setCallingClassName(info.getCallingClassName());
                            additionalInfo.setCallingMethodName(info.getCallingMethodName());
                        }
                        target.add((InstrumentationInfo)additionalInfo);
                    }
                }
                result.addIntrumentationInfo(target);
            }

            @Override
            public InstrumentationInfoResult preflight() {
                InstrumentationInfoResult result = this.checkAndInitializeClass(new InstrumentationInfoResult(), iClassName);
                return result;
            }

            @Override
            public void extractInfo(List<InstrumentationInfo> infos, ResultSet rs) throws SQLException {
                this.extractFullInstrumentationInfoFromResultSet(infos, rs);
            }

            @Override
            public void setStatementParameters(PreparedStatement s) throws SQLException {
                String className = iClassName.getPackageAndNameString();
                String methodName = iMethodName.getNameAndSignatureString();
                if (!alsoInactive) {
                    s.setString(1, methodName);
                    s.setString(2, className);
                    s.setInt(3, 0);
                    s.setString(4, methodName);
                    s.setString(5, className);
                } else {
                    s.setString(1, methodName);
                    s.setString(2, className);
                }
            }
        };
        return this.getInstrumentationWithHelper(helper);
    }

    public InstrumentationInfoResult getInstrumentationInfo(final boolean alsoInactive) {
        GetInstrumentationInfoHelper helper = new GetInstrumentationInfoHelper(this){

            @Override
            public String getStatementString() {
                String result = DatabaseQueryDelegate.kSelectInstrumentationInfo;
                if (!alsoInactive) {
                    result = String.valueOf(result) + " where " + " directive.is_active = ? ";
                }
                return result;
            }

            @Override
            public void postflight(InstrumentationInfoResult result, List<InstrumentationInfo> infos) {
                result.addIntrumentationInfo(infos);
            }

            @Override
            public InstrumentationInfoResult preflight() {
                InstrumentationInfoResult result = new InstrumentationInfoResult(0);
                return result;
            }

            @Override
            public void setStatementParameters(PreparedStatement s) throws SQLException {
                if (!alsoInactive) {
                    s.setInt(1, 0);
                }
            }

            @Override
            public void extractInfo(List<InstrumentationInfo> infos, ResultSet rs) throws SQLException {
                this.extractFullInstrumentationInfoFromResultSet(infos, rs);
            }
        };
        return this.getInstrumentationWithHelper(helper);
    }

    public InstrumentationInfoResult getInstrumentationInfoByGroup(final String group, final boolean alsoInactive) {
        GetInstrumentationInfoHelper helper = new GetInstrumentationInfoHelper(this){

            @Override
            public String getStatementString() {
                String result = DatabaseQueryDelegate.kSelectInstrumentationInfo;
                if (group != null) {
                    result = String.valueOf(result) + " where " + DatabaseQueryDelegate.kSelectInstrumentationInfoByGroupClause;
                    if (!alsoInactive) {
                        result = String.valueOf(result) + " and " + " directive.is_active = ? ";
                    }
                } else if (!alsoInactive) {
                    result = String.valueOf(result) + " where " + " directive.is_active = ? ";
                }
                return result;
            }

            @Override
            public void postflight(InstrumentationInfoResult result, List<InstrumentationInfo> infos) {
                result.addIntrumentationInfo(infos);
            }

            @Override
            public InstrumentationInfoResult preflight() {
                InstrumentationInfoResult result = new InstrumentationInfoResult(0);
                return result;
            }

            @Override
            public void setStatementParameters(PreparedStatement s) throws SQLException {
                if (group != null) {
                    s.setString(1, group);
                    if (!alsoInactive) {
                        s.setInt(2, 0);
                    }
                } else if (!alsoInactive) {
                    s.setInt(1, 0);
                }
            }

            @Override
            public void extractInfo(List<InstrumentationInfo> infos, ResultSet rs) throws SQLException {
                this.extractFullInstrumentationInfoFromResultSet(infos, rs);
            }
        };
        return this.getInstrumentationWithHelper(helper);
    }

    public InstrumentationInfoResult getInstrumentationInfoByLabel(final String label, final boolean alsoInactive) {
        GetInstrumentationInfoHelper helper = new GetInstrumentationInfoHelper(this){

            @Override
            public String getStatementString() {
                String result = DatabaseQueryDelegate.kSelectInstrumentationInfo;
                if (label != null) {
                    result = String.valueOf(result) + " where " + DatabaseQueryDelegate.kSelectInstrumentationInfoByLabelClause;
                    if (!alsoInactive) {
                        result = String.valueOf(result) + " and " + " directive.is_active = ? ";
                    }
                } else if (!alsoInactive) {
                    result = String.valueOf(result) + " where " + " directive.is_active = ? ";
                }
                return result;
            }

            @Override
            public void postflight(InstrumentationInfoResult result, List<InstrumentationInfo> infos) {
                if (label != null) {
                    for (InstrumentationInfo info : infos) {
                        String key = info.getLabelName();
                        if (key == null) {
                            key = DatabaseQueryDelegate.kUndefinedLabelName;
                        }
                        result.addInstrumentationInfo(key, info);
                    }
                } else {
                    HashSet<String> labels = new HashSet<String>();
                    for (InstrumentationInfo info : infos) {
                        String key = info.getLabelName();
                        if (key == null) {
                            key = DatabaseQueryDelegate.kUndefinedLabelName;
                        }
                        if (key.equals(this.getTemporaryLabel())) continue;
                        labels.add(key);
                    }
                    result.setLabels(labels);
                }
            }

            @Override
            public InstrumentationInfoResult preflight() {
                InstrumentationInfoResult result = new InstrumentationInfoResult(0);
                return result;
            }

            @Override
            public void setStatementParameters(PreparedStatement s) throws SQLException {
                if (label != null) {
                    s.setString(1, label);
                    if (!alsoInactive) {
                        s.setInt(2, 0);
                    }
                } else if (!alsoInactive) {
                    s.setInt(1, 0);
                }
            }

            @Override
            public void extractInfo(List<InstrumentationInfo> infos, ResultSet rs) throws SQLException {
                this.extractFullInstrumentationInfoFromResultSet(infos, rs);
            }
        };
        return this.getInstrumentationWithHelper(helper);
    }

    public DynamicInstrumentationResult cleanTransientData(final IClassName className, final IMethodName methodName) {
        DynamicInstrumentationResult result = this.checkAndInitializeClass(new DynamicInstrumentationResult(), className);
        if (result.isError()) {
            return result;
        }
        result.importAll((DynamicInstrumentationResult)new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                ClassMethodId id = this.getClassMethodId(className.getContainerAndPackageAndNameString(), methodName.getNameAndSignatureString());
                PreparedStatement s = null;
                s = this.getPreparedStatement("delete from method_trace where class_id = ?");
                s.setInt(1, id.getClassId());
                s.execute();
                if (this.feedback.isTraceEnabled(kModule)) {
                    int deletedRows = s.getUpdateCount();
                    this.feedback.trace(kModule, "cleanTransientData complete: " + deletedRows + " rows deleted");
                }
            }
        }.executeTransaction());
        return result;
    }

    public DynamicInstrumentationResult cleanTransientClassData(final IClassName className) {
        DynamicInstrumentationResult result = this.checkAndInitializeClass(new DynamicInstrumentationResult(), className);
        if (result.isError()) {
            return result;
        }
        result.importAll((DynamicInstrumentationResult)new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                ClassMethodId id = this.getClassId(className.getContainerAndPackageAndNameString());
                PreparedStatement s = null;
                s = this.getPreparedStatement("delete from method_trace where class_id = ?");
                s.setInt(1, id.getClassId());
                s.execute();
                if (this.feedback.isTraceEnabled(kModule)) {
                    int deletedRows = s.getUpdateCount();
                    this.feedback.trace(kModule, "cleanTransientClassData complete: " + deletedRows + " rows deleted");
                }
            }
        }.executeTransaction());
        return result;
    }

    public InstrumentationInfoResult assignLabel(IClassName className, IMethodName methodName, String labelName, String resourceName, String tracerType, String groupName) {
        InstrumentationInfoResult result = null;
        DynamicDirectivesResult collectionResult = this.getDynamicDirectiveCollection();
        if (!collectionResult.isError()) {
            result = new InstrumentationInfoResult(0);
            for (DatabaseDirectiveInfo info : collectionResult.getDynamicDirectiveCollection()) {
                if (info.isInterface() || !info.getClassName().equals(className.getPackageAndNameString()) || !info.getMethodName().equals(methodName.getNameAndSignatureString()) || !info.getResourceName().equals(resourceName) || !info.getTracerType().equals(tracerType) || !info.getGroupName().equals(groupName)) continue;
                String oldLabel = info.getLabel();
                this.setDynamicDirectiveLabel(info.getLineNumber(), labelName);
                Object infoResult = null;
                infoResult = info.getDirectiveType() == 4 || info.getDirectiveType() == 5 || info.getDirectiveType() == 6 ? new ConditionalInstrumentationInfo() : new InstrumentationInfo();
                infoResult.setActive(true);
                infoResult.setPermanent(info.isPermanent());
                infoResult.setTemporary(info.isTemporary());
                infoResult.setClassName(info.getClassName());
                infoResult.setMethodName(info.getMethodName());
                infoResult.setLabelName(labelName);
                infoResult.setTracerType(info.getTracerType());
                infoResult.setResourceName(info.getResourceName());
                infoResult.setGroupName(info.getGroupName());
                infoResult.setLineNumber(info.getLineNumber());
                result.addInstrumentationInfo(labelName, (InstrumentationInfo)infoResult);
                if (infoResult instanceof ConditionalInstrumentationInfo) {
                    infoResult.setCallingClassName(info.getCallingClassName());
                    infoResult.setCallingMethodName(info.getCallingMethodName());
                }
                if (oldLabel == null) continue;
                infoResult = info.getDirectiveType() == 4 || info.getDirectiveType() == 5 || info.getDirectiveType() == 6 ? new ConditionalInstrumentationInfo() : new InstrumentationInfo();
                infoResult.setActive(false);
                infoResult.setPermanent(info.isPermanent());
                infoResult.setClassName(info.getClassName());
                infoResult.setMethodName(info.getMethodName());
                infoResult.setLabelName(oldLabel);
                infoResult.setTracerType(info.getTracerType());
                infoResult.setResourceName(info.getResourceName());
                infoResult.setGroupName(info.getGroupName());
                infoResult.setLineNumber(info.getLineNumber());
                if (infoResult instanceof ConditionalInstrumentationInfo) {
                    infoResult.setCallingClassName(info.getCallingClassName());
                    infoResult.setCallingMethodName(info.getCallingMethodName());
                }
                result.addInstrumentationInfo(oldLabel, (InstrumentationInfo)infoResult);
            }
        } else {
            result = new InstrumentationInfoResult(100);
            result.importAll((DynamicInstrumentationResult)collectionResult);
        }
        return result;
    }

    public DynamicInstrumentationResult getAvailableTracers(IClassName className, IMethodName methodName) {
        return DynamicInstrumentationResult.kNotImplemented;
    }

    public InstrumentationInfoResult addInstrumentation(IClassName iClassName, IMethodName iMethodName, String resourceName, String tracerType, String groupName, int status, int type, IClassName callingClassName, IMethodName callingMethodName) {
        return this.addInstrumentation(iClassName, iMethodName, resourceName, tracerType, groupName, this.getTemporaryLabel(), status, type, callingClassName, callingMethodName);
    }

    private String getTemporaryLabel() {
        return "@Temporary Label Prefix@";
    }

    public InstrumentationInfoResult addInstrumentation(IClassName iClassName, IMethodName iMethodName, final String labelName, final String resourceName, String tracerType, final String groupName, final int status, final int type, IClassName iCallingClassName, IMethodName iCallingMethodName) {
        InstrumentationInfoResult result = this.checkAndInitializeClass(new InstrumentationInfoResult(), iClassName);
        if (result.isError()) {
            return result;
        }
        final String className = iClassName.getContainerAndPackageAndNameString();
        final String methodName = iMethodName.getNameAndSignatureString();
        final String callingClassName = iCallingClassName == null ? null : iCallingClassName.getContainerAndPackageAndNameString();
        final String callingMethodName = iCallingMethodName == null ? null : iCallingMethodName.getNameAndSignatureString();
        final String[] errors = new String[1];
        final int[] ids = new int[1];
        final ArrayList duplicatedIds = new ArrayList();
        String filteredTracerType = tracerType;
        if (status == 0) {
            boolean isConditional = callingClassName != null;
            filteredTracerType = this.getPermanentDirectiveType(filteredTracerType, isConditional);
        }
        final String directiveTracerType = filteredTracerType;
        result.importAll((DynamicInstrumentationResult)new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                ClassMethodId id = this.tryStoreClassAndMethod(className, methodName, null, 1, 1);
                ClassMethodId callingId = null;
                if (callingClassName != null && callingMethodName != null) {
                    callingId = this.tryStoreClassAndMethod(callingClassName, callingMethodName, null, 1, 1);
                }
                if (id != null) {
                    PreparedStatement s = this.getPreparedStatement("Select directive_id,  tracer_type, label, is_permanent, directive_type from directive where class_id = ? and method_id = ? and resource_name = ? and group_name = ? and is_active = ?");
                    s.setInt(1, id.getClassId());
                    s.setInt(2, id.getMethodId());
                    s.setString(3, resourceName);
                    s.setString(4, groupName);
                    s.setInt(5, 0);
                    ResultSet existingDirectives = s.executeQuery();
                    while (existingDirectives.next()) {
                        duplicatedIds.add(new Integer(existingDirectives.getInt(5)));
                        duplicatedIds.add(new Integer(existingDirectives.getInt(1)));
                        duplicatedIds.add(existingDirectives.getString(2));
                        duplicatedIds.add(existingDirectives.getString(3));
                        duplicatedIds.add(new Integer(existingDirectives.getInt(4)));
                    }
                    s = this.getPreparedStatement(DatabaseQueryDelegate.kInsertIntoDirectivesValuesDefault);
                    s.setInt(1, type);
                    s.setInt(2, id.getClassId());
                    s.setInt(3, id.getMethodId());
                    s.setString(4, resourceName);
                    s.setString(5, directiveTracerType);
                    s.setString(6, groupName);
                    s.setString(7, labelName);
                    s.setInt(8, 0);
                    s.setInt(9, status);
                    s.setInt(10, -1);
                    if (callingId == null) {
                        s.setNull(11, 4);
                    } else {
                        s.setInt(11, callingId.getMethodId());
                    }
                    s.execute();
                    ids[0] = this.getLastIdCreated();
                } else {
                    this.feedback.debug(kModule, "addDynamicDirective failed for class " + className);
                    errors[0] = "Unable to find class " + className + " and method " + methodName;
                }
                this.feedback.trace(kModule, "addDynamicDirective complete");
            }
        }.executeTransaction());
        if (!result.isError()) {
            if (errors[0] != null) {
                result.setException((Throwable)new Exception(errors[0]));
                result.setStatus(104);
            } else if (!this.getTransformer().checkDynamicInstrumentationDirective(ids[0], (DynamicInstrumentationResult)result)) {
                this.setDynamicDirectiveStatus(ids[0], 1);
                result.setStatus(113);
            } else {
                Object info = null;
                info = type == 4 || type == 5 || type == 6 ? new ConditionalInstrumentationInfo() : new InstrumentationInfo();
                info.setActive(true);
                info.setClassName(className);
                info.setGroupName(groupName);
                info.setLabelName(labelName);
                info.setMethodName(methodName);
                info.setPermanent(status == 0);
                info.setTemporary(status == 1);
                info.setResourceName(resourceName);
                info.setTracerType(tracerType);
                info.setLineNumber(ids[0]);
                if (info instanceof ConditionalInstrumentationInfo) {
                    info.setCallingClassName(callingClassName);
                    info.setCallingMethodName(callingMethodName);
                }
                result.addInstrumentationInfo(groupName, (InstrumentationInfo)info);
                Iterator i = duplicatedIds.iterator();
                while (i.hasNext()) {
                    Integer duplicatedDirectiveType = (Integer)i.next();
                    info = duplicatedDirectiveType == 4 || type == 5 || type == 6 ? new ConditionalInstrumentationInfo() : new InstrumentationInfo();
                    Integer duplicateDirectiveId = (Integer)i.next();
                    info.setClassName(className);
                    info.setGroupName(groupName);
                    info.setTracerType(i.next().toString());
                    info.setLabelName(i.next().toString());
                    info.setMethodName(methodName);
                    Integer duplicateDirectiveStatus = (Integer)i.next();
                    info.setPermanent(duplicateDirectiveStatus == 0);
                    info.setResourceName(resourceName);
                    info.setLineNumber(duplicateDirectiveId.intValue());
                    if (this.allowUpgrade(status, duplicateDirectiveStatus)) {
                        this.setDynamicDirectiveInactive(duplicateDirectiveId);
                        info.setActive(false);
                    } else {
                        info.setActive(true);
                    }
                    boolean cfr_ignored_0 = info instanceof ConditionalInstrumentationInfo;
                    result.addInstrumentationInfo(groupName, (InstrumentationInfo)info);
                }
            }
        }
        return result;
    }

    private boolean allowUpgrade(int status, int duplicateDirectiveStatus) {
        if (duplicateDirectiveStatus == 1) {
            return true;
        }
        if (duplicateDirectiveStatus == 2) {
            return status == 0;
        }
        return false;
    }

    public MethodCallsResult getMethodCalls(final IClassName className, final IMethodName methodName) {
        MethodCallsResult result = this.checkAndInitializeClass(new MethodCallsResult(), className);
        if (result.isError()) {
            return result;
        }
        final ArrayList list = new ArrayList();
        result.importAll((DynamicInstrumentationResult)new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                ICompilerPersonality personality = NativePersonality.getNativePersonality();
                PreparedStatement s = this.getPreparedStatement("select distinct methodcall.class_name, methodcall.method_name, methodcall.METHOD_TYPE from method join class on method.class_id = class.class_id join methodcall on methodcall.method_id = method.method_id where method.method_name = ? and class.class_name = ?");
                s.setString(1, methodName.getNameAndSignatureString());
                s.setString(2, className.getPackageAndNameString());
                ResultSet rs = s.executeQuery();
                while (rs.next()) {
                    String className2 = rs.getString(1);
                    String methodName2 = rs.getString(2);
                    String methodType = rs.getString(3);
                    try {
                        IClassName iClassName = personality.getClassSchemaPolicy().getClassName(className2);
                        IMethodName iMethodName = personality.getClassSchemaPolicy().getMethodName(methodName2);
                        DynamicInstrumentationResult.ClassMethodPair pair = new DynamicInstrumentationResult.ClassMethodPair(iClassName.getReflectionFriendlyQualifiedNameString(), String.valueOf(iMethodName.getNameAndSignatureString()) + methodType);
                        list.add(pair);
                    }
                    catch (InvalidClassNameException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidMethodDescriptorException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidMethodNameException e) {
                        e.printStackTrace();
                    }
                }
                this.feedback.trace(kModule, "getMethodCalls complete");
            }
        }.executeTransaction());
        if (!result.isError()) {
            result.setMethodCalls(list);
        }
        return result;
    }

    public DynamicInstrumentationResult isActive() {
        return new DynamicInstrumentationResult(0).setActive(Boolean.TRUE);
    }

    public InstrumentationInfoResult removeInstrumentation(IClassName iClassName, IMethodName iMethodName, final String resourceName, final String tracerType, final String groupName, boolean redefineTree) {
        InstrumentationInfoResult info;
        int updateCountFromTransaction;
        InstrumentationInfoResult result = this.checkAndInitializeClass(new InstrumentationInfoResult(), iClassName);
        if (result.isError()) {
            return result;
        }
        final String className = iClassName.getContainerAndPackageAndNameString();
        final String methodName = iMethodName.getNameAndSignatureString();
        CompilerLogDatabaseTransaction transaction = new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                ClassMethodId id = this.tryStoreClassAndMethod(className, methodName, null, 1, 1);
                PreparedStatement s = this.getPreparedStatement("remove instrumentation", "update directive set is_active = ? where class_id = ? and method_id = ? and resource_name = ? and tracer_type = ? and group_name = ?");
                s.setInt(1, 1);
                s.setInt(2, id.getClassId());
                s.setInt(3, id.getMethodId());
                s.setString(4, resourceName);
                s.setString(5, tracerType);
                s.setString(6, groupName);
                int updateCount = s.executeUpdate();
                this.putDataMap("updateCount", new Integer(updateCount));
                this.feedback.trace(kModule, "removeDynamicDirective complete");
            }
        };
        DatabaseResult resultFromTransaction = transaction.executeTransaction();
        result.importAll((DynamicInstrumentationResult)resultFromTransaction);
        if (!resultFromTransaction.isError() && (updateCountFromTransaction = transaction.getNumberDataMap("updateCount").intValue()) > 0 && !(info = this.getInstrumentationInfo(iClassName, iMethodName, tracerType, resourceName, groupName, true)).isError()) {
            result.addIntrumentationInfo(info.getInstrumentationInfos());
        }
        return result;
    }

    public boolean initialize(IDynamicInstrumentationTransformer transformer) {
        this.setTransformer(transformer);
        boolean initializeDatabase = this.initializeDatabase(transformer.getAgent());
        if (this.fCanRun && transformer instanceof ICompilerLogger && initializeDatabase) {
            IAgent agent = transformer.getAgent();
            if (agent.IAgent_getModuleFeedback().isTraceEnabled()) {
                agent.IAgent_getModuleFeedback().trace(kModule, "Adding database directives service to dynamic transformer");
            }
            DatabaseDynamicDirectivesService directiveService = new DatabaseDynamicDirectivesService();
            transformer.setDynamicDirectivesService((IDynamicDirectivesService)directiveService);
            if (agent.IAgent_getModuleFeedback().isTraceEnabled()) {
                agent.IAgent_getModuleFeedback().trace(kModule, "Added database directives service to dynamic transformer");
            }
            return true;
        }
        transformer.getAgent().IAgent_getModuleFeedback().error(kModule, "Unable to initialize dynamic instrumentation: no ICompilerLogger available or no database connection available");
        return false;
    }

    public void setNotInitialized() {
        this.fCanRun = false;
    }

    private boolean initializeDatabase(IAgent agent) {
        boolean result = false;
        agent.IAgent_getModuleFeedback().info(kModule, "Initializing Connection manager");
        try {
            ConnectionManager.initialize(this.getRepositoryName());
            if (ConnectionManager.Instance() != null) {
                result = true;
            }
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            agent.IAgent_getModuleFeedback().error(kModule, "Agent not available when initializing Connection Manager");
            agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer().getDynamicInstrumentationService().setNotInitialized();
        }
        if (result) {
            agent.IAgent_getModuleFeedback().info(kModule, "Initialized Connection manager");
        } else {
            agent.IAgent_getModuleFeedback().warn(kModule, "failed to initialize Connection manager");
        }
        return result;
    }

    public void setRepositoryName(String name) {
    }

    public String getRepositoryName() {
        return this.fTransformer.getDynamicInstrumentationService().getRepositoryName();
    }

    public <T extends DynamicInstrumentationResult> T checkAndInitializeClass(T result, IClassName className) {
        return this.checkAndInitializeClass(result, className, null);
    }

    public <T extends DynamicInstrumentationResult> T checkAndInitializeClass(T result, final IClassName className, PermanentDirectiveInfo info) {
        if (this.getTransformer() != null) {
            String classNameReflectionFriendly = className.getReflectionFriendlyQualifiedNameString();
            final StringBuffer sb = new StringBuffer();
            new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

                protected void defineTransaction() throws SQLException {
                    if (this.checkProcessedClass(className.getContainerAndPackageAndNameString())) {
                        sb.append("Y");
                    }
                }
            }.executeTransaction();
            if (sb.length() == 0) {
                final Class cls = this.getTransformer().getClassRedefinitionDelegate().getInstrumentableClass(classNameReflectionFriendly);
                if (cls != null) {
                    try {
                        byte[] codeBytes = ByteClassUtil.getBytesForClass((Class)cls, (int)Integer.MAX_VALUE, (IModuleFeedbackChannel)this.getTransformer().getAgent().IAgent_getModuleFeedback());
                        ByteArrayInputStream stream = new ByteArrayInputStream(codeBytes);
                        DGCompilerMemoryLog log = new DGCompilerMemoryLog(this.getTransformer().getAgent());
                        DGClass dgCls = new DGClass((InputStream)stream, (ICompilerLog)log);
                        log.ICompilerLog_logClassTraced(dgCls.getClassName().getContainerAndPackageAndNameString());
                        this.logClassTracers(log, (IModeledClass)dgCls);
                        log.ICompilerLog_suggestFlush();
                        this.getTransformer().getAgent().IAgent_getModuleFeedback().trace(kModule, "Class " + className.getContainerAndPackageAndNameString() + " has been checked");
                        new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

                            protected void defineTransaction() throws SQLException {
                                this.tryUpdateProcessedClass(className.getContainerAndPackageAndNameString(), 1, cls.isInterface());
                            }
                        }.executeTransaction();
                        result.setStatus(0);
                    }
                    catch (DGClassLoadingException e) {
                        this.getTransformer().getAgent().IAgent_getModuleFeedback().debug(kModule, "Class " + className.getContainerAndPackageAndNameString() + " cannot be instrumented");
                        this.getTransformer().getAgent().IAgent_getModuleFeedback().debug((Throwable)e);
                        this.markProcessed(className);
                        result.setStatus(104);
                    }
                    catch (IOException e) {
                        this.getTransformer().getAgent().IAgent_getModuleFeedback().debug(kModule, "Class " + className.getContainerAndPackageAndNameString() + " cannot be instrumented");
                        this.getTransformer().getAgent().IAgent_getModuleFeedback().debug((Throwable)e);
                        this.markProcessed(className);
                        result.setStatus(104);
                    }
                } else {
                    this.getTransformer().getAgent().IAgent_getModuleFeedback().debug(kModule, "Class " + className.getContainerAndPackageAndNameString() + " not found in instrumentation repository");
                    if (info != null) {
                        DGCompilerMemoryLog log = new DGCompilerMemoryLog(this.getTransformer().getAgent());
                        log.logPermanentDirectiveInfo(info.iClassName, info.iMethodName.getNameAndSignatureString(), info.tracerType, info.groupName, null, null, info.resourceName);
                    }
                    result.setStatus(0);
                }
            } else {
                this.getTransformer().getAgent().IAgent_getModuleFeedback().trace(kModule, "Class has been processed");
                result.setStatus(0);
            }
        } else {
            new Exception().printStackTrace();
            result.setStatus(106);
        }
        return result;
    }

    private void logClassTracers(DGCompilerMemoryLog log, IModeledClass dgCls) {
        if (this.fTransformer instanceof IAutoProbeConfig) {
            IAutoProbeConfig configurer = (IAutoProbeConfig)this.fTransformer;
            DGCompilerSettings settings = configurer.getCompilerSettings();
            ClassSettingsApplier applier = new ClassSettingsApplier(settings, (ICompilerLog)log, dgCls, null);
            Map tracers = applier.getTracersMap();
            this.logAggregateMethodTracer(log, tracers);
        }
    }

    public void logAggregateMethodTracer(ICompilerLog log, Map m) {
        IModuleFeedbackChannel feedback = this.getTransformer().getAgent().IAgent_getModuleFeedback();
        boolean isDebugEnabled = feedback.isDebugEnabled(kModule);
        for (Map.Entry entry : m.entrySet()) {
            IModeledMethod method = (IModeledMethod)entry.getKey();
            Collection tracers = (Collection)entry.getValue();
            for (MethodTracer tracer : tracers) {
                TracerName tracerName = tracer.getTracerName();
                if (tracerName != null && kAnchorTracerName.equals(tracerName.getName())) continue;
                if (isDebugEnabled) {
                    if (tracerName == null) {
                        feedback.debug(kModule, "For tracer " + tracer.getInfo() + ";" + tracer.getTracerResource() + ";" + tracer.getTracerParameters() + " tracerName is null");
                    } else if (tracerName.getName() == null) {
                        feedback.debug(kModule, "For tracer " + tracer.getInfo() + ";" + tracer.getTracerResource() + ";" + tracer.getTracerParameters() + " tracerName.getName() is null");
                    }
                }
                log.ICompilerLog_logMethodTracer(method, 0, tracer);
            }
        }
    }

    private void markProcessed(final IClassName className) {
        new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                PreparedStatement createClass = this.getPreparedStatement("classInsert", "insert into class values (DEFAULT, ?, ?, ?, ?)");
                createClass.setString(1, className.getContainerAndPackageAndNameString());
                createClass.setInt(2, 2);
                createClass.setInt(3, 1);
                createClass.setInt(4, 0);
                createClass.execute();
            }
        }.executeTransaction();
    }

    void setTransformer(IDynamicInstrumentationTransformer transformer) {
        this.fTransformer = transformer;
    }

    private IDynamicInstrumentationTransformer getTransformer() {
        return this.fTransformer;
    }

    public void executeOnRedefinition(Class cls, ByteArrayInputStream stream) {
        try {
            DGClass dgCls = new DGClass((InputStream)stream, (ICompilerLog)new NullCompilerLog());
            this.cleanTransientClassData(dgCls.getClassName());
            DGCompilerMemoryLog log = new DGCompilerMemoryLog(this.getTransformer().getAgent());
            this.logClassTracers(log, (IModeledClass)dgCls);
            log.ICompilerLog_suggestFlush();
        }
        catch (Exception e) {
            try {
                AgentShim.getAgent().IAgent_getModuleFeedback().error(kModule, "Unable to execute callback on class redefintion");
                AgentShim.getAgent().IAgent_getModuleFeedback().trace(kModule, "Unable to execute callback on class redefintion", (Throwable)e);
            }
            catch (Exception exception) {}
        }
    }

    public InstrumentationInfoResult makePermanent(String labelName) {
        DynamicDirectivesResult directivesByLabel = this.getDynamicDirectiveCollectionByLabel(labelName);
        if (!directivesByLabel.isError()) {
            Collection directives = directivesByLabel.getDynamicDirectiveCollection();
            if (directives != null) {
                for (DatabaseDirectiveInfo info : directives) {
                    if (info.isPermanent()) continue;
                    DynamicDirectivesResult updateResult = this.setDynamicDirectivePermanent(info);
                    if (updateResult.isError()) {
                        directivesByLabel.setStatus(updateResult.getStatus());
                        directivesByLabel.setException(updateResult.getException());
                        break;
                    }
                    info.setTracerType(this.getPermanentDirectiveType(info));
                    info.setPermanent(true);
                }
            }
            if (!directivesByLabel.isError()) {
                InstrumentationInfoResult labelInfo = new InstrumentationInfoResult(directivesByLabel);
                directives = directivesByLabel.getDynamicDirectiveCollection();
                if (directives != null) {
                    for (DatabaseDirectiveInfo info : directives) {
                        InstrumentationInfo info2 = this.getInstrumentationInfoFromDatabaseInfo(info);
                        info2.setInherited(false);
                        labelInfo.addInstrumentationInfo(info.getLabel(), info2);
                    }
                }
                return labelInfo;
            }
        }
        return new InstrumentationInfoResult(directivesByLabel);
    }

    private boolean isAffectingTreeByType(DatabaseDirectiveInfo info) {
        return info.getDirectiveType() == 3 || info.getDirectiveType() == 5;
    }

    public IClassName getClassName(String className) {
        try {
            return ClassName.getClassName((String)className);
        }
        catch (InvalidClassNameException invalidClassNameException) {
            return null;
        }
    }

    public IMethodName getMethodName(String methodName) {
        try {
            return MethodName.getMethodName((String)methodName);
        }
        catch (InvalidMethodDescriptorException invalidMethodDescriptorException) {
            return null;
        }
        catch (InvalidMethodNameException invalidMethodNameException) {
            return null;
        }
    }

    public void setDynamicDirectiveInactive(int lineNumber) {
        this.setDynamicDirectiveStatus(lineNumber, 1);
    }

    private InstrumentationInfo getInstrumentationInfoFromDatabaseInfo(DatabaseDirectiveInfo info) {
        Object info2 = null;
        info2 = info.getDirectiveType() == 4 || info.getDirectiveType() == 5 || info.getDirectiveType() == 6 ? new ConditionalInstrumentationInfo() : new InstrumentationInfo();
        info2.setActive(info.isActive());
        info2.setClassName(info.getClassName());
        info2.setGroupName(info.getGroupName());
        info2.setInherited(info.getDirectiveType() == 2 || info.getDirectiveType() == 6);
        info2.setLabelName(info.getLabel());
        info2.setLineNumber(info.getLineNumber());
        info2.setMethodName(info.getMethodName());
        info2.setPermanent(info.isPermanent());
        info2.setTemporary(info.isTemporary());
        info2.setResourceName(info.getResourceName());
        info2.setTracerType(info.getTracerType());
        info2.setAffectingClassTree(info.isInterface() || this.isAffectingTreeByType(info));
        if (info2 instanceof ConditionalInstrumentationInfo) {
            info2.setCallingClassName(info.getCallingClassName());
            info2.setCallingMethodName(info.getCallingMethodName());
        }
        return info2;
    }

    private DatabaseDirectiveInfo getDatabaseTracerDirectiveInfo(ResultSet rs) throws SQLException {
        DatabaseDirectiveInfo info = new DatabaseDirectiveInfo();
        info.setLineNumber(rs.getInt(1));
        info.setClassName(rs.getString(2));
        info.setMethodName(rs.getString(3));
        info.setResourceName(rs.getString(4));
        info.setTracerType(rs.getString(5));
        info.setGroupName(rs.getString(6));
        info.setPermanent(rs.getInt(7) == 0);
        info.setTemporary(rs.getInt(7) == 1);
        info.setLabel(rs.getString(8));
        info.setDirectiveType(rs.getInt(9));
        info.setInterface(rs.getInt(10) == 1);
        info.setCallingClassName(rs.getString(11));
        info.setCallingMethodName(rs.getString(12));
        info.setActive(true);
        info.setStaticActive(info.isPermanent());
        return info;
    }

    private DatabaseDirectiveInfo getDatabaseGroupDirectiveInfo(ResultSet rs) throws SQLException {
        DatabaseDirectiveInfo info = new DatabaseDirectiveInfo();
        info.setLineNumber(rs.getInt(1));
        info.setGroupName(rs.getString(2));
        info.setLabel(rs.getString(3));
        info.setPermanent(rs.getInt(4) == 0);
        info.setActive(rs.getInt(5) == 0);
        info.setStaticActive(rs.getInt(6) == 0 && info.isPermanent());
        info.setDirectiveType(1);
        info.setClassName("");
        info.setMethodName("");
        info.setResourceName("");
        info.setTracerType("");
        info.setCallingClassName("");
        info.setCallingMethodName("");
        return info;
    }

    public DynamicInstrumentationResult createPermanentDirective(IClassName iClassName, IMethodName iMethodName, final String labelName, final String resourceName, final String tracerType, final String groupName, IClassName iCallingClassName, IMethodName iCallingMethodName) {
        InstrumentationInfoResult result2;
        PermanentDirectiveInfo info = new PermanentDirectiveInfo(iClassName, iMethodName, labelName, resourceName, tracerType, groupName, iCallingClassName, iCallingMethodName);
        InstrumentationInfoResult result = this.checkAndInitializeClass(new InstrumentationInfoResult(), iClassName, info);
        if (result.isError()) {
            return result;
        }
        if (iCallingClassName != null && (result2 = this.checkAndInitializeClass(new InstrumentationInfoResult(), iCallingClassName)).isError()) {
            return result2;
        }
        final String className = iClassName.getContainerAndPackageAndNameString();
        final String methodName = iMethodName.getNameAndSignatureString();
        final String callingClassName = iCallingClassName == null ? null : iCallingClassName.getContainerAndPackageAndNameString();
        final String callingMethodName = iCallingMethodName == null ? null : iCallingMethodName.getNameAndSignatureString();
        final String[] errors = new String[1];
        result.importAll((DynamicInstrumentationResult)new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                ClassMethodId id = this.tryStoreClassAndMethod(className, methodName, null, 1, 1);
                ClassMethodId callingId = null;
                if (callingClassName != null && callingMethodName != null) {
                    callingId = this.tryStoreClassAndMethod(callingClassName, callingMethodName, null, 1, 1);
                }
                if (id != null) {
                    int type = 0;
                    if (callingClassName != null) {
                        type = 4;
                    }
                    PreparedStatement s = this.getPreparedStatement(DatabaseQueryDelegate.kInsertIntoDirectivesValuesDefault);
                    s.setInt(1, type);
                    s.setInt(2, id.getClassId());
                    s.setInt(3, id.getMethodId());
                    s.setString(4, resourceName);
                    s.setString(5, tracerType);
                    s.setString(6, groupName);
                    s.setString(7, labelName);
                    s.setInt(8, 0);
                    s.setInt(9, 0);
                    s.setInt(10, -1);
                    if (callingId == null) {
                        s.setNull(11, 4);
                    } else {
                        s.setInt(11, callingId.getMethodId());
                    }
                    s.execute();
                } else {
                    this.feedback.debug(kModule, "addDynamicDirective failed for class " + className);
                    errors[0] = "Unable to find class " + className + " and method " + methodName;
                }
                this.feedback.trace(kModule, "addDynamicDirective complete");
            }
        }.executeTransaction());
        if (!result.isError() && errors[0] != null) {
            result.setException((Throwable)new Exception(errors[0]));
            result.setStatus(104);
        }
        return result;
    }

    public InstrumentationInfoResult removeTemporaryInstrumentation(int lineNumber, IClassName className, IMethodName methodName) {
        return new InstrumentationInfoResult(this.setTemporaryDynamicDirectiveNotActive(lineNumber));
    }

    public int getDynamicInstrumentationStatusCode(boolean refresh) {
        int status = 0;
        if (this.fCanRun) {
            ++status;
            DynamicDirectivesResult result = this.getDynamicDirectiveCollection();
            boolean hasPermanent = false;
            boolean hasPreserved = false;
            boolean hasTemporary = false;
            if (!result.isError()) {
                Collection directives = result.getDynamicDirectiveCollection();
                if (directives != null) {
                    for (DatabaseDirectiveInfo info : directives) {
                        if (!hasPermanent && info.isPermanent()) {
                            hasPermanent = true;
                        }
                        if (!hasTemporary && info.isTemporary()) {
                            hasTemporary = true;
                        }
                        if (!(hasPreserved || info.isTemporary() || info.isPermanent())) {
                            hasPreserved = true;
                        }
                        if (hasTemporary && hasPermanent && hasPreserved) break;
                    }
                }
                if (hasPermanent || hasTemporary || hasPreserved) {
                    status += 2;
                    status += 4;
                }
                if (hasTemporary) {
                    status += 8;
                }
            }
        }
        return status;
    }

    public boolean isEnabled() {
        return this.fTransformer.getDynamicInstrumentationService().isEnabled();
    }

    public GroupInstrumentationInfoResult getGroupsDirectives() {
        return this.getGroupsDirectives(null);
    }

    public GroupInstrumentationInfoResult getGroupsDirectives(final String filterGroupName) {
        final ArrayList list = new ArrayList();
        GroupInstrumentationInfoResult result = new GroupInstrumentationInfoResult();
        result.importAll((DynamicInstrumentationResult)new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            private PreparedStatement getGroupPreparedStatement(String groupName) throws SQLException {
                if (groupName == null) {
                    return this.getPreparedStatement(DatabaseQueryDelegate.kSelectGroupDirectives);
                }
                PreparedStatement result = this.getPreparedStatement(DatabaseQueryDelegate.kSelectGroupDirectivesByName);
                result.setString(1, groupName);
                return result;
            }

            protected void defineTransaction() throws SQLException {
                PreparedStatement s = this.getGroupPreparedStatement(filterGroupName);
                ResultSet rs = s.executeQuery();
                while (rs.next()) {
                    DatabaseDirectiveInfo info = DatabaseQueryDelegate.this.getDatabaseGroupDirectiveInfo(rs);
                    list.add(info);
                }
                this.feedback.trace(kModule, "getGroupsDirectives.SelectGroupDirectives complete");
            }
        }.executeTransaction());
        if (!result.isError()) {
            for (DatabaseDirectiveInfo info : list) {
                Assertion.wilyAssert((info.getGroupName() != null && !info.getGroupName().equals("TemporaryGroup") ? 1 : 0) != 0);
                result.addGroupIntrumentationInfo(info.getLineNumber(), info.getGroupName(), info.isActive(), info.isStaticActive(), info.isPermanent(), info.getLabel(), true, info.isPermanent());
            }
        }
        list.clear();
        InstrumentationInfoResult result2 = new InstrumentationInfoResult();
        result2.importAll((DynamicInstrumentationResult)new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            private PreparedStatement getGroupPreparedStatement(String groupName) throws SQLException {
                if (groupName == null) {
                    PreparedStatement s = this.getPreparedStatement(DatabaseQueryDelegate.kSelectDirectives);
                    s.setInt(1, 0);
                    return s;
                }
                PreparedStatement s = this.getPreparedStatement(DatabaseQueryDelegate.kSelectDirectivesByGroupName);
                s.setInt(1, 0);
                s.setString(2, groupName);
                return s;
            }

            protected void defineTransaction() throws SQLException {
                PreparedStatement s = this.getGroupPreparedStatement(filterGroupName);
                ResultSet rs = s.executeQuery();
                while (rs.next()) {
                    DatabaseDirectiveInfo info = DatabaseQueryDelegate.this.getDatabaseTracerDirectiveInfo(rs);
                    list.add(info);
                }
                this.feedback.trace(kModule, "getGroupsDirectives.SelectAllDirectives complete");
            }
        }.executeTransaction());
        if (!result2.isError()) {
            HashMap map = new HashMap();
            for (DatabaseDirectiveInfo databaseDirectiveInfo : list) {
                String groupName = databaseDirectiveInfo.getGroupName();
                List<DatabaseDirectiveInfo> listFromMap = null;
                if (groupName == null) continue;
                if (!map.containsKey(groupName)) {
                    listFromMap = new ArrayList();
                    map.put(groupName, listFromMap);
                } else {
                    listFromMap = (List)map.get(groupName);
                }
                listFromMap.add(databaseDirectiveInfo);
            }
            for (Map.Entry entry : map.entrySet()) {
                GroupInstrumentationInfo infoAlreadyGot = (GroupInstrumentationInfo)result.getIntrumentationInfo().get(entry.getKey());
                boolean isPermanent = false;
                for (DatabaseDirectiveInfo info : (List)entry.getValue()) {
                    if (!info.isPermanent()) continue;
                    isPermanent = true;
                    break;
                }
                if (infoAlreadyGot == null) {
                    if (((String)entry.getKey()).equals("TemporaryGroup")) continue;
                    result.addGroupIntrumentationInfo(0, (String)entry.getKey(), true, isPermanent, isPermanent, "DynamicGroups", true, false);
                    continue;
                }
                infoAlreadyGot.setHasPermanentInstrumentation(isPermanent);
                boolean newPermanentSetting = infoAlreadyGot.isPermanent();
                if (!infoAlreadyGot.isPermanent() && isPermanent) {
                    newPermanentSetting = true;
                    infoAlreadyGot.setStaticActive(true);
                }
                infoAlreadyGot.setPermanent(newPermanentSetting);
            }
        }
        return result;
    }

    public GroupInstrumentationInfoResult makePermanentGroupDirectives() {
        GroupInstrumentationInfoResult result = new GroupInstrumentationInfoResult();
        result.importAll((DynamicInstrumentationResult)new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                PreparedStatement s = this.getPreparedStatement("update directive set is_permanent = ? , is_static_active = is_active where directive_type = ?");
                s.setInt(2, 1);
                s.setInt(1, 0);
                s.execute();
                this.feedback.trace(kModule, "makePermanentGroupDirectives complete");
            }
        }.executeTransaction());
        if (!result.isError()) {
            result = this.getGroupsDirectives();
        }
        return result;
    }

    public GroupInstrumentationInfoResult setGroupDirective(final String groupName, final boolean turnOn, final int status) {
        GroupInstrumentationInfoResult result = new GroupInstrumentationInfoResult();
        result.importAll((DynamicInstrumentationResult)new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                PreparedStatement s = this.getPreparedStatement("select directive_id, is_permanent, is_static_active, is_active from directive where directive_type = ? and group_name = ?");
                s.setInt(1, 1);
                s.setString(2, groupName);
                ResultSet rs = s.executeQuery();
                int directiveId = Integer.MIN_VALUE;
                int directiveCurrentStatus = Integer.MIN_VALUE;
                int directiveCurrentStaticActiveStatus = Integer.MIN_VALUE;
                if (rs.next()) {
                    directiveId = rs.getInt(1);
                    directiveCurrentStatus = rs.getInt(2);
                    directiveCurrentStaticActiveStatus = rs.getInt(3);
                    rs.getInt(4);
                }
                if (directiveId < 0) {
                    s = this.getPreparedStatement(DatabaseQueryDelegate.kInsertIntoDirectivesValuesDefault);
                    s.setInt(1, 1);
                    s.setInt(2, -1);
                    s.setInt(3, -1);
                    s.setString(4, null);
                    s.setString(5, null);
                    s.setString(6, groupName);
                    s.setString(7, "DynamicGroups");
                    int activeValue = turnOn ? 0 : 1;
                    s.setInt(8, activeValue);
                    s.setInt(9, status);
                    int staticActiveValue = 1;
                    if (status == 0) {
                        staticActiveValue = activeValue;
                    }
                    s.setInt(10, staticActiveValue);
                    s.setNull(11, 4);
                    s.execute();
                } else {
                    s = this.getPreparedStatement("update directive set label = ?, is_permanent = ?, is_active = ?, is_static_active = ? where directive_id = ?");
                    s.setString(1, "DynamicGroups");
                    int newStatus = directiveCurrentStatus;
                    if (status == 0) {
                        newStatus = status;
                    }
                    s.setInt(2, newStatus);
                    int activeValue = turnOn ? 0 : 1;
                    s.setInt(3, activeValue);
                    int staticActiveValue = directiveCurrentStaticActiveStatus;
                    if (status == 0) {
                        staticActiveValue = activeValue;
                    }
                    s.setInt(4, staticActiveValue);
                    s.setInt(5, directiveId);
                    s.execute();
                }
                this.feedback.trace(kModule, "setGroupDirective complete");
            }
        }.executeTransaction());
        if (!result.isError()) {
            GroupInstrumentationInfoResult currentGroupStatus = this.getGroupsDirectives(groupName);
            result.importAll(currentGroupStatus);
        }
        return result;
    }

    public void getDynamicInstrumentationPBD(IDynamicInstrumentationListener listener, String label, boolean permanentOnly) {
        listener.deliverResult((DynamicInstrumentationResult)new DynamicDirectivesResult(105));
    }

    public DynamicInstrumentationResult getClasses(String methodPattern) {
        return new DynamicDirectivesResult(105);
    }

    public DynamicInstrumentationResult getMethods(String classPattern) {
        return new DynamicDirectivesResult(105);
    }

    public DynamicInstrumentationResult getPackagesOrAssemblies() {
        return new DynamicDirectivesResult(105);
    }

    public GroupInstrumentationInfoResult createPermanentGroupDirective(String name, boolean isActive) {
        return null;
    }

    public boolean isForcedBroadcast() {
        return false;
    }

    public void notifyTransformed(String className, Class classBeingRedefined) {
    }

    public void forceBroadcast() {
    }

    public void addServiceDelegate(IDynamicInstrumentationDelegate service) {
    }

    public IDeepInheritanceHelper getDeepInheritanceHelper() {
        return null;
    }

    public void setDeepInheritanceHelper(IDeepInheritanceHelper helper) {
    }

    public GroupInstrumentationInfoResult setGroupDirectiveWithoutBusy(String groupName, boolean turnOn, int status) {
        return this.setGroupDirective(groupName, turnOn, status);
    }

    public void executeOnUnsupportedOperation(UnsupportedDIOperationException exception, Class candidate, ByteArrayInputStream stream) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class GetInstrumentationInfoHelper {
        private GetInstrumentationInfoHelper() {
        }

        public abstract InstrumentationInfoResult preflight();

        public abstract String getStatementString();

        public abstract void setStatementParameters(PreparedStatement var1) throws SQLException;

        public abstract void extractInfo(List<InstrumentationInfo> var1, ResultSet var2) throws SQLException;

        public abstract void postflight(InstrumentationInfoResult var1, List<InstrumentationInfo> var2);

        protected void extractFullInstrumentationInfoFromResultSet(List<InstrumentationInfo> infos, ResultSet rs) throws SQLException {
            while (rs.next()) {
                int directiveType = rs.getInt(12);
                Object info = null;
                info = directiveType == 4 || directiveType == 5 || directiveType == 6 ? new ConditionalInstrumentationInfo() : new InstrumentationInfo();
                String className = rs.getString(6);
                String methodName = rs.getString(7);
                boolean isActive = rs.getInt(8) == 0;
                int instrumentationStatus = rs.getInt(9);
                boolean isPermanent = instrumentationStatus == 0;
                boolean isTemporary = instrumentationStatus == 1;
                info.setActive(isActive);
                info.setPermanent(isPermanent);
                info.setTemporary(isTemporary);
                info.setClassName(className);
                info.setMethodName(methodName);
                String labelName = rs.getString(5);
                if (labelName == null) {
                    labelName = DatabaseQueryDelegate.kUndefinedLabelName;
                }
                info.setLabelName(labelName);
                String tracerName = rs.getString(1);
                info.setTracerType(tracerName);
                String tracerParameter = rs.getString(2);
                info.setResourceName(tracerParameter);
                String tracerGroup = rs.getString(3);
                info.setGroupName(tracerGroup);
                int lineNumber = rs.getInt(10);
                info.setLineNumber(lineNumber);
                info.setInherited(directiveType == 2 || directiveType == 6);
                boolean isInterface = rs.getInt(11) == 1;
                info.setAffectingClassTree(isInterface || directiveType == 3 || directiveType == 5);
                if (info instanceof ConditionalInstrumentationInfo) {
                    info.setCallingClassName(rs.getString(13));
                    info.setCallingMethodName(rs.getString(14));
                }
                infos.add((InstrumentationInfo)info);
            }
        }
    }

    private static class PermanentDirectiveInfo {
        private final IClassName iClassName;
        private final IMethodName iMethodName;
        private final String labelName;
        private final String resourceName;
        private final String tracerType;
        private final String groupName;
        private final IClassName iCallingClassName;
        private final IMethodName iCallingMethodName;

        public PermanentDirectiveInfo(IClassName iClassName, IMethodName iMethodName, String labelName, String resourceName, String tracerType, String groupName, IClassName iCallingClassName, IMethodName iCallingMethodName) {
            this.iClassName = iClassName;
            this.iMethodName = iMethodName;
            this.labelName = labelName;
            this.resourceName = resourceName;
            this.tracerType = tracerType;
            this.groupName = groupName;
            this.iCallingClassName = iCallingClassName;
            this.iCallingMethodName = iCallingMethodName;
        }
    }
}

