/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.threaddump.common;

import com.wily.introscope.threaddump.common.IWilyThreadDump;
import com.wily.introscope.threaddump.common.WilyThreadInfo;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class WilyThreadDump
extends IWilyThreadDump {
    private static final long serialVersionUID = 1729559450570537551L;
    private WilyThreadInfo[] fThreads;
    private volatile int fDeadlockedCount = 0;
    private volatile int fRunningCount = 0;
    private volatile int fBlockedCount = 0;
    private volatile int fWaitingCount = 0;
    private volatile long[] fThreadIDs = null;
    private volatile Map<Long, WilyThreadInfo> fThreadIDMap;

    public WilyThreadDump() {
    }

    public WilyThreadDump(WilyThreadInfo[] threads) {
        this();
        this.fThreads = threads;
        this.calculateStateCounts();
    }

    private void calculateStateCounts() {
        int i = 0;
        while (i < this.fThreads.length) {
            if (this.fThreads[i].isDeadlocked()) {
                ++this.fDeadlockedCount;
            }
            if (this.fThreads[i].isBlocked()) {
                ++this.fBlockedCount;
            } else if (this.fThreads[i].isRunning()) {
                ++this.fRunningCount;
            } else if (this.fThreads[i].isWaiting()) {
                ++this.fWaitingCount;
            }
            ++i;
        }
    }

    public WilyThreadInfo[] getThreads() {
        return (WilyThreadInfo[])this.fThreads.clone();
    }

    public int getTotalThreadCount() {
        return this.fThreads.length;
    }

    public int getDeadlockedThreadCount() {
        return this.fDeadlockedCount;
    }

    public int getRunningThreadCount() {
        return this.fRunningCount;
    }

    public int getBlockedThreadCount() {
        return this.fBlockedCount;
    }

    public int getWaitingThreadCount() {
        return this.fWaitingCount;
    }

    public WilyThreadInfo getDependencyThread(WilyThreadInfo thread) {
        if (thread.getLockOwnerID() < 0L) {
            return null;
        }
        int i = 0;
        while (i < this.fThreads.length) {
            if (this.fThreads[i].getThreadID() == thread.getLockOwnerID()) {
                return this.fThreads[i];
            }
            ++i;
        }
        return null;
    }

    public long[] getThreadIDs() {
        this.buildThreadIDMapAndCache();
        return this.fThreadIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildThreadIDMapAndCache() {
        if (this.fThreadIDs == null) {
            WilyThreadDump wilyThreadDump = this;
            synchronized (wilyThreadDump) {
                if (this.fThreadIDs == null) {
                    this.fThreadIDs = new long[this.fThreads.length];
                    this.fThreadIDMap = new HashMap<Long, WilyThreadInfo>();
                    int i = 0;
                    while (i < this.fThreads.length) {
                        this.fThreadIDs[i] = this.fThreads[i].getThreadID();
                        ++i;
                    }
                    Arrays.sort(this.fThreadIDs);
                }
            }
        }
    }

    public WilyThreadInfo getThreadInfo(long threadID) {
        this.buildThreadIDMapAndCache();
        return this.fThreadIDMap.get(threadID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.fThreads.length) {
            sb = sb.append(this.fThreads[i].toString());
            ++i;
        }
        return sb.toString();
    }

    public boolean isSerializedVersion() {
        return false;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int array_size = in.readInt();
        this.fThreads = new WilyThreadInfo[array_size];
        int i = 0;
        while (i < array_size) {
            this.fThreads[i] = (WilyThreadInfo)in.readObject();
            ++i;
        }
        this.calculateStateCounts();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        int array_size = this.fThreads.length;
        out.writeInt(array_size);
        int i = 0;
        while (i < array_size) {
            out.writeObject(this.fThreads[i]);
            ++i;
        }
    }

    public boolean getErrorFlag() {
        return false;
    }
}

