/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.util.adt.ConcurrentThreadLocalHashMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.heartbeat.WaitAndExecuteBehavior;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AConcurrentWeakBehaviorThreadLocalHashMap<K, V>
extends ConcurrentThreadLocalHashMap<K, V> {
    private volatile long fStaleCheckFrequency;
    private volatile IntervalHeartbeat fHeartbeat;
    protected static Module kModule = new Module("AConcurrentWeakBehaviorThreadLocalHashMap");
    protected volatile transient ReferenceQueue<Object> fWeakReferenceQueue;
    private volatile WaitAndExecuteBehavior fStaleCheckBehavior;
    private final Object fBehaviorKillLock = new Object();
    private static final long serialVersionUID = 1L;

    public AConcurrentWeakBehaviorThreadLocalHashMap(IntervalHeartbeat beat, IModuleFeedbackChannel feedback, boolean useThreadLocal, long staleCheckFrequency) {
        this(beat, feedback, useThreadLocal, 750, 75, 0.75f, staleCheckFrequency, 8);
    }

    public AConcurrentWeakBehaviorThreadLocalHashMap(IntervalHeartbeat beat, IModuleFeedbackChannel feedback, boolean useThreadLocal, int initialSize, int threadLocalSize, float loadFactor, long staleCheckFrequency, int numThreads) {
        super(feedback, useThreadLocal, useThreadLocal, initialSize, threadLocalSize, loadFactor, numThreads);
        this.fWeakReferenceQueue = new ReferenceQueue();
        if (beat != null) {
            this.startStaleCheck(beat, staleCheckFrequency);
        }
    }

    public AConcurrentWeakBehaviorThreadLocalHashMap() {
        this.fWeakReferenceQueue = new ReferenceQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startStaleCheck(IntervalHeartbeat heartbeat, long staleCheckFrequency) {
        Object object = this.fBehaviorKillLock;
        synchronized (object) {
            if (this.fStaleCheckBehavior != null) {
                this.fStaleCheckBehavior.kill();
            }
            this.fHeartbeat = heartbeat;
            this.fStaleCheckFrequency = staleCheckFrequency;
            this.fStaleCheckBehavior = new WaitAndExecuteBehavior(this.fHeartbeat, this.fStaleCheckFrequency, "concurrentMapStaleCheck"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected boolean execute() {
                    Object object = AConcurrentWeakBehaviorThreadLocalHashMap.this.fBehaviorKillLock;
                    synchronized (object) {
                        AConcurrentWeakBehaviorThreadLocalHashMap.this.removeStaleKeys();
                        return false;
                    }
                }
            };
        }
    }

    public void removeStaleKeys() {
        Reference<Object> key;
        boolean isTraceEnabled = this.getFeedback().isTraceEnabled(kModule);
        int initialSize = 0;
        if (isTraceEnabled) {
            initialSize = this.size();
        }
        if (isTraceEnabled) {
            this.getFeedback().trace(kModule, "Starting check for stale keys at " + new Date() + " on a map size of " + initialSize);
        }
        int removeCount = 0;
        while ((key = this.fWeakReferenceQueue.poll()) != null) {
            this.remove(key);
            if (!isTraceEnabled) continue;
            ++removeCount;
        }
        if (isTraceEnabled) {
            this.getFeedback().trace(kModule, "End check for stale keys at " + new Date() + ": map size = " + this.size());
        }
        if (isTraceEnabled && removeCount > 0) {
            this.getFeedback().trace(kModule, "Check for stale keys: initial size = " + initialSize + ", removed = " + removeCount + ", size = " + this.size());
        }
    }

    @Override
    protected void onGet() {
    }

    @Override
    protected void onPut() {
    }
}

