/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.EngineLOB;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.Resetable;
import org.apache.derby.impl.jdbc.AutoPositioningStream;
import org.apache.derby.impl.jdbc.BinaryToRawStream;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.LOBStreamControl;
import org.apache.derby.impl.jdbc.PositionedStoreStream;
import org.apache.derby.impl.jdbc.UpdatableBlobStream;
import org.apache.derby.impl.jdbc.Util;

final class EmbedBlob
extends ConnectionChild
implements Blob,
EngineLOB {
    private boolean materialized;
    private InputStream myStream;
    private int locator;
    private long myLength;
    private long pos;
    private BinaryToRawStream biStream;
    private static int BLOB_BUF_SIZE = 4096;
    private byte[] buf;
    private boolean isValid;
    private LOBStreamControl control;

    EmbedBlob(byte[] byArray, EmbedConnection embedConnection) throws SQLException {
        super(embedConnection);
        this.myLength = -1L;
        this.isValid = true;
        try {
            this.control = new LOBStreamControl(embedConnection.getDBName(), byArray);
            this.materialized = true;
            embedConnection.addLOBReference(this);
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
    }

    protected EmbedBlob(DataValueDescriptor dataValueDescriptor, EmbedConnection embedConnection) throws StandardException {
        block6: {
            super(embedConnection);
            this.myLength = -1L;
            this.isValid = true;
            this.myStream = dataValueDescriptor.getStream();
            if (this.myStream == null) {
                this.materialized = true;
                byte[] byArray = dataValueDescriptor.getBytes();
                try {
                    this.control = new LOBStreamControl(this.getEmbedConnection().getDBName(), byArray);
                }
                catch (SQLException sQLException) {
                    throw StandardException.newException(sQLException.getSQLState());
                }
                catch (IOException iOException) {
                    throw StandardException.newException("XJ022.S", iOException);
                }
            }
            this.materialized = false;
            this.myStream = new PositionedStoreStream(this.myStream);
            try {
                ((Resetable)((Object)this.myStream)).initStream();
            }
            catch (StandardException standardException) {
                if (!standardException.getMessageId().equals("40XD0")) break block6;
                throw StandardException.newException("XJ073.S");
            }
        }
        this.buf = new byte[BLOB_BUF_SIZE];
        this.pos = 0L;
        embedConnection.addLOBReference(this);
    }

    private void setPosition(long l) throws StandardException, IOException {
        if (this.materialized) {
            this.pos = l;
        } else {
            ((Resetable)((Object)this.myStream)).resetStream();
            this.biStream = new BinaryToRawStream(this.myStream, this);
            this.pos = 0L;
            while (this.pos < l) {
                int n = this.biStream.read(this.buf, 0, (int)Math.min(l - this.pos, (long)BLOB_BUF_SIZE));
                if (n <= 0) {
                    throw StandardException.newException("XJ079.S");
                }
                this.pos += (long)n;
            }
        }
    }

    private int read() throws IOException, SQLException {
        int n;
        if (this.materialized) {
            try {
                if (this.pos >= this.control.getLength()) {
                    return -1;
                }
                n = this.control.read(this.pos);
            }
            catch (StandardException standardException) {
                throw Util.generateCsSQLException(standardException);
            }
        } else {
            n = this.biStream.read();
        }
        ++this.pos;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public long length() throws SQLException {
        block15: {
            this.checkValidity();
            try {
                if (this.materialized) {
                    return this.control.getLength();
                }
            }
            catch (IOException var1_1) {
                throw Util.setStreamFailure(var1_1);
            }
            if (this.myLength != -1L) {
                return this.myLength;
            }
            var1_2 = false;
            var2_3 = this.getConnectionSynchronization();
            // MONITORENTER : var2_3
            v0 = var1_2 = this.getEmbedConnection().isClosed() == false;
            if (var1_2) {
                this.setupContextStack();
            }
            this.setPosition(0L);
            this.myLength = this.biStream.getLength();
            if (this.myLength == -1L) break block15;
            this.biStream.close();
            var3_5 = this.myLength;
            // MONITOREXIT : var2_3
            if (var1_2 == false) return var3_5;
            this.restoreContextStack();
            return var3_5;
        }
        while (true) {
            if ((var3_6 = this.biStream.read(this.buf)) == -1) {
                this.myLength = this.pos;
                this.biStream.close();
                var3_7 = this.pos;
                // MONITOREXIT : var2_3
                if (var1_2 == false) return var3_7;
                ** break;
            }
            this.pos += (long)var3_6;
        }
        {
            catch (Throwable var2_4) {
                throw this.handleMyExceptions(var2_4);
            }
        }
lbl40:
        // 1 sources

        this.restoreContextStack();
        return var3_7;
        catch (Throwable var6_8) {
            if (var1_2 == false) throw var6_8;
            this.restoreContextStack();
            throw var6_8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes(long l, int n) throws SQLException {
        this.checkValidity();
        boolean bl = false;
        try {
            byte[] byArray;
            if (l < 1L) {
                throw StandardException.newException("XJ070.S", new Long(l));
            }
            if (n < 0) {
                throw StandardException.newException("XJ071.S", new Integer(n));
            }
            if (this.materialized) {
                byArray = new byte[n];
                int n2 = this.control.read(byArray, 0, byArray.length, l - 1L);
                if (n2 == -1) {
                    byte[] byArray2 = new byte[]{};
                    return byArray2;
                }
                if (n2 < n) {
                    byte[] byArray3 = new byte[n2];
                    System.arraycopy(byArray, 0, byArray3, 0, n2);
                    byArray = byArray3;
                }
            } else {
                Object object = this.getConnectionSynchronization();
                synchronized (object) {
                    boolean bl2 = bl = !this.getEmbedConnection().isClosed();
                    if (bl) {
                        this.setupContextStack();
                    }
                    this.setPosition(l - 1L);
                    byArray = new byte[n];
                    int n3 = InputStreamUtil.readLoop(this.biStream, byArray, 0, n);
                    this.pos += (long)n3;
                    if (n3 < n) {
                        byte[] byArray4 = new byte[n3];
                        System.arraycopy(byArray, 0, byArray4, 0, n3);
                        byte[] byArray5 = byArray4;
                        return byArray5;
                    }
                }
            }
            byte[] byArray6 = byArray;
            return byArray6;
        }
        catch (StandardException standardException) {
            StandardException standardException2;
            if (!standardException.getMessageId().equals("XJ079.S")) throw this.handleMyExceptions(standardException2);
            standardException2 = StandardException.newException("XJ076.S", new Long(l));
            throw this.handleMyExceptions(standardException2);
        }
        catch (Throwable throwable) {
            throw this.handleMyExceptions(throwable);
        }
        finally {
            if (bl) {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream() throws SQLException {
        this.checkValidity();
        boolean bl = false;
        try {
            if (this.materialized) {
                InputStream inputStream = this.control.getInputStream(0L);
                return inputStream;
            }
            Object object = this.getConnectionSynchronization();
            synchronized (object) {
                try {
                    boolean bl2 = bl = !this.getEmbedConnection().isClosed();
                    if (bl) {
                        this.setupContextStack();
                    }
                    ((Resetable)((Object)this.myStream)).resetStream();
                    UpdatableBlobStream updatableBlobStream = new UpdatableBlobStream(this, new AutoPositioningStream(this, this.myStream, this));
                    return updatableBlobStream;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throw this.handleMyExceptions(throwable2);
                    }
                }
            }
        }
        finally {
            if (bl) {
                this.restoreContextStack();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public long position(byte[] var1_1, long var2_2) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 1[TRYBLOCK]], but top level block is 13[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkMatch(byte[] byArray) throws IOException, SQLException {
        for (int i = 1; i < byArray.length; ++i) {
            int n = this.read();
            if (n >= 0 && n == byArray[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public long position(Blob var1_1, long var2_2) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 15[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkMatch(Blob blob) throws IOException, SQLException {
        int n;
        InputStream inputStream;
        try {
            inputStream = blob.getBinaryStream();
        }
        catch (SQLException sQLException) {
            return false;
        }
        if (inputStream == null) {
            return false;
        }
        int n2 = inputStream.read();
        if (n2 < 0) {
            return false;
        }
        do {
            if ((n2 = inputStream.read()) >= 0) continue;
            return true;
        } while (n2 == (n = this.read()) && n >= 0);
        return false;
    }

    private SQLException handleMyExceptions(Throwable throwable) throws SQLException {
        if (throwable instanceof StandardException && ((StandardException)throwable).getMessageId().equals("40XD0")) {
            throwable = StandardException.newException("XJ073.S");
        }
        return this.handleException(throwable);
    }

    protected void finalize() {
        if (!this.materialized) {
            ((Resetable)((Object)this.myStream)).closeStream();
        }
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        this.checkValidity();
        try {
            if (this.materialized) {
                if (l - 1L > this.length()) {
                    throw Util.generateCsSQLException("XJ076.S", new Long(l));
                }
                if (l < 1L) {
                    throw Util.generateCsSQLException("XJ070.S", new Long(l));
                }
                n2 = (int)this.control.write(byArray, n, n2, l - 1L);
            } else {
                this.control = new LOBStreamControl(this.getEmbedConnection().getDBName());
                this.control.copyData(this.myStream, this.length());
                n2 = (int)this.control.write(byArray, n, n2, l - 1L);
                this.myStream.close();
                this.materialized = true;
            }
            return n2;
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        this.checkValidity();
        if (l - 1L > this.length()) {
            throw Util.generateCsSQLException("XJ076.S", new Long(l));
        }
        if (l < 1L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(l));
        }
        try {
            if (this.materialized) {
                return this.control.getOutputStream(l - 1L);
            }
            this.control = new LOBStreamControl(this.getEmbedConnection().getDBName());
            this.control.copyData(this.myStream, l - 1L);
            this.myStream.close();
            this.materialized = true;
            return this.control.getOutputStream(l - 1L);
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
    }

    public void truncate(long l) throws SQLException {
        if (l > this.length()) {
            throw Util.generateCsSQLException("XJ079.S", new Long(this.pos));
        }
        try {
            if (this.materialized) {
                this.control.truncate(l);
            } else {
                this.control = new LOBStreamControl(this.getEmbedConnection().getDBName());
                this.control.copyData(this.myStream, l);
                this.myStream.close();
                this.materialized = true;
            }
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
    }

    public void free() throws SQLException {
        if (!this.isValid) {
            return;
        }
        this.isValid = false;
        this.localConn.removeLOBMapping(this.locator);
        this.myLength = -1L;
        if (!this.materialized) {
            ((Resetable)((Object)this.myStream)).closeStream();
        } else {
            try {
                this.control.free();
                this.control = null;
            }
            catch (IOException iOException) {
                throw Util.setStreamFailure(iOException);
            }
        }
    }

    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        this.checkValidity();
        if (l <= 0L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(l));
        }
        if (l2 < 0L) {
            throw Util.generateCsSQLException("XJ071.S", new Long(l2));
        }
        if (l2 > this.length() - l) {
            throw Util.generateCsSQLException("XJ087.S", (Object)new Long(l), new Long(l2));
        }
        try {
            return new UpdatableBlobStream(this, this.getBinaryStream(), l - 1L, l2);
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
    }

    private void checkValidity() throws SQLException {
        this.getEmbedConnection().checkIfClosed();
        if (!this.isValid) {
            throw this.newSQLException("XJ215.S");
        }
    }

    boolean isMaterialized() {
        return this.materialized;
    }

    public int getLocator() {
        if (this.locator == 0) {
            this.locator = this.localConn.addLOBMapping(this);
        }
        return this.locator;
    }
}

