/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge.rules;

import com.wily.introscope.agent.upgrade.merge.IRulesEngine;
import com.wily.introscope.agent.upgrade.merge.rules.DeleteEntryRule;
import com.wily.introscope.agent.upgrade.merge.rules.DeleteFileRule;
import com.wily.introscope.agent.upgrade.merge.rules.NoMergeFileRule;
import com.wily.introscope.agent.upgrade.merge.rules.OverwriteFileRule;
import com.wily.introscope.agent.upgrade.merge.rules.PreferredEntryRule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Rules {
    private Map<IRulesEngine.MergeableType, Set<DeleteFileRule>> fDeleteFileRules = new HashMap<IRulesEngine.MergeableType, Set<DeleteFileRule>>();
    private Map<IRulesEngine.MergeableType, Set<OverwriteFileRule>> fOverwriteFileRules = new HashMap<IRulesEngine.MergeableType, Set<OverwriteFileRule>>();
    private Map<IRulesEngine.MergeableType, Set<NoMergeFileRule>> fNoMergeFileRules = new HashMap<IRulesEngine.MergeableType, Set<NoMergeFileRule>>();
    private Map<IRulesEngine.MergeableType, Set<DeleteEntryRule>> fDeleteEntryRules = new HashMap<IRulesEngine.MergeableType, Set<DeleteEntryRule>>();
    private Map<IRulesEngine.MergeableType, Map<String, PreferredEntryRule>> fPreferredEntryRules = new HashMap<IRulesEngine.MergeableType, Map<String, PreferredEntryRule>>();

    public boolean hasDeleteFileRule(IRulesEngine.MergeableType type, String name) {
        boolean retValue = false;
        Set<DeleteFileRule> rules = this.fDeleteFileRules.get((Object)type);
        if (rules != null) {
            retValue = rules.contains(new DeleteFileRule(type, name));
        }
        return retValue;
    }

    public void addDeleteFileRule(DeleteFileRule rule) {
        IRulesEngine.MergeableType type = rule.getType();
        Set<DeleteFileRule> rules = this.fDeleteFileRules.get((Object)type);
        if (rules == null) {
            rules = new HashSet<DeleteFileRule>();
            this.fDeleteFileRules.put(type, rules);
        }
        rules.add(rule);
    }

    public boolean hasOverwriteFileRule(IRulesEngine.MergeableType type, String name) {
        boolean retValue = false;
        Set<OverwriteFileRule> rules = this.fOverwriteFileRules.get((Object)type);
        if (rules != null) {
            retValue = rules.contains(new OverwriteFileRule(type, name));
        }
        return retValue;
    }

    public void addOverwriteFileRule(OverwriteFileRule rule) {
        IRulesEngine.MergeableType type = rule.getType();
        Set<OverwriteFileRule> rules = this.fOverwriteFileRules.get((Object)type);
        if (rules == null) {
            rules = new HashSet<OverwriteFileRule>();
            this.fOverwriteFileRules.put(type, rules);
        }
        rules.add(rule);
    }

    public boolean hasNoMergeFileRule(IRulesEngine.MergeableType type, String name) {
        boolean retValue = false;
        Set<NoMergeFileRule> rules = this.fNoMergeFileRules.get((Object)type);
        if (rules != null) {
            retValue = rules.contains(new NoMergeFileRule(type, name));
        }
        return retValue;
    }

    public void addNoMergeFileRule(NoMergeFileRule rule) {
        IRulesEngine.MergeableType type = rule.getType();
        Set<NoMergeFileRule> rules = this.fNoMergeFileRules.get((Object)type);
        if (rules == null) {
            rules = new HashSet<NoMergeFileRule>();
            this.fNoMergeFileRules.put(type, rules);
        }
        rules.add(rule);
    }

    public boolean hasDeleteEntryRule(IRulesEngine.MergeableType type, String name) {
        boolean retValue = false;
        Set<DeleteEntryRule> rules = this.fDeleteEntryRules.get((Object)type);
        if (rules != null) {
            retValue = rules.contains(new DeleteEntryRule(type, name));
        }
        return retValue;
    }

    public void addDeleteEntryRule(DeleteEntryRule rule) {
        IRulesEngine.MergeableType type = rule.getType();
        Set<DeleteEntryRule> rules = this.fDeleteEntryRules.get((Object)type);
        if (rules == null) {
            rules = new HashSet<DeleteEntryRule>();
            this.fDeleteEntryRules.put(type, rules);
        }
        rules.add(rule);
    }

    public PreferredEntryRule getPreferredEntryRule(IRulesEngine.MergeableType type, String name) {
        PreferredEntryRule retValue = null;
        Map<String, PreferredEntryRule> rules = this.fPreferredEntryRules.get((Object)type);
        if (rules != null) {
            retValue = rules.get(name.toLowerCase());
        }
        return retValue;
    }

    public void addPreferredEntryRule(PreferredEntryRule rule) {
        IRulesEngine.MergeableType type = rule.getType();
        Map<String, PreferredEntryRule> rules = this.fPreferredEntryRules.get((Object)type);
        if (rules == null) {
            rules = new HashMap<String, PreferredEntryRule>();
            this.fPreferredEntryRules.put(type, rules);
        }
        rules.put(rule.getName(), rule);
    }
}

