/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection.rules;

import com.wily.agent.main.IIntelligentInstrumentationTracerHelper;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.intelligent.detection.rules.AbstractFailFastRule;
import com.wily.introscope.agent.intelligent.detection.rules.InstrumentationCheck;
import com.wily.introscope.agent.intelligent.entrypoint.Logger;
import com.wily.introscope.agent.intelligent.entrypoint.apis.ExecutionStatus;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.common.Utils;
import com.wily.introscope.autoprobe.AutoProbeTransformer;

public class SkipMethodIfAlreadyInstrumentedRule
extends AbstractFailFastRule
implements InstrumentationCheck {
    private IIntelligentInstrumentationTracerHelper helper = null;
    private Class[] allClassesInVm = null;

    private SkipMethodIfAlreadyInstrumentedRule() {
        try {
            IAgent agent = AgentShim.getAgent();
            this.helper = agent.IAgent_getTracerAdministrator().getIntelligentInstrumentationService();
        }
        catch (Exception e) {
            Logger.logException((String)("Error while initializing " + this.getClass().getName()), (Exception)e);
        }
    }

    private SkipMethodIfAlreadyInstrumentedRule(AutoProbeTransformer autoProbeTransformer) {
        this(autoProbeTransformer.getAgent());
    }

    private SkipMethodIfAlreadyInstrumentedRule(IAgent agent) {
        if (agent != null) {
            this.helper = agent.IAgent_getTracerAdministrator().getIntelligentInstrumentationService();
        }
    }

    @Override
    public boolean doExecute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
        if (this.helper != null && this.allClassesInVm != null) {
            String methodName;
            IndexAwareTraceElement traceElement = trace[currentElementIndex];
            String className = traceElement.getClassName();
            return !this.helper.areMatchingMethodsTraced(className, methodName = traceElement.getMethodName(), this.allClassesInVm);
        }
        return true;
    }

    @Override
    public boolean isInstrumented(String className, String methodName) {
        this.refreshClassRepo();
        return this.helper != null && this.helper.areMatchingMethodsTraced(className, methodName, this.allClassesInVm);
    }

    public void refreshClassRepo() {
        if (this.helper != null) {
            this.allClassesInVm = this.helper.getAllClassesInVm();
        }
    }

    @Override
    public String toString() {
        return Utils.formatStringRep(this.getClass().getSimpleName());
    }

    public static SkipMethodIfAlreadyInstrumentedRule getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /* synthetic */ SkipMethodIfAlreadyInstrumentedRule(SkipMethodIfAlreadyInstrumentedRule skipMethodIfAlreadyInstrumentedRule) {
        this();
    }

    private static class SingletonHolder {
        private static final SkipMethodIfAlreadyInstrumentedRule INSTANCE = new SkipMethodIfAlreadyInstrumentedRule(null);

        private SingletonHolder() {
        }
    }
}

