/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint.stacktrace;

import com.wily.introscope.agent.intelligent.entrypoint.EntryPointDetectionConfiguration;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.common.Utils;
import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.WrappedStackTraceElement;
import com.wily.introscope.agent.probe.net.ManagedDatagramSocket;
import com.wily.introscope.agent.probe.net.ManagedSocketInputStream;
import com.wily.introscope.agent.probe.net.ManagedSocketOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;

public class StackTraceRepository {
    private static Queue<StackTraceElement[]> tracesQueue = new ConcurrentLinkedQueue<StackTraceElement[]>();
    private static final AgentElementsFilter AGENT_ELEMENTS_FILTER = new AgentElementsFilter();

    public static boolean add(StackTraceElement[] trace) {
        return tracesQueue.add(trace);
    }

    public static StackTraceElement[] poll() {
        return tracesQueue.poll();
    }

    public static IndexAwareTraceElement[] pollWrappedTrace() {
        return StackTraceRepository.wrapTraceElements(tracesQueue.poll());
    }

    public static IndexAwareTraceElement[] wrapTraceElements(StackTraceElement[] origTrace) {
        StackTraceElement[] filteredTrace = AGENT_ELEMENTS_FILTER.filter(origTrace);
        IndexAwareTraceElement[] wrappedTrace = null;
        if (filteredTrace != null && filteredTrace.length > 0) {
            int length = filteredTrace.length;
            wrappedTrace = new IndexAwareTraceElement[length];
            StackTraceElement element = null;
            int index = 0;
            while (index < length) {
                element = filteredTrace[index];
                wrappedTrace[index] = new WrappedStackTraceElement(element, index, length);
                ++index;
            }
        }
        return wrappedTrace;
    }

    public static int size() {
        return tracesQueue.size();
    }

    public static boolean isEmpty() {
        return tracesQueue.isEmpty();
    }

    public static boolean isFull() {
        return StackTraceRepository.size() >= EntryPointDetectionConfiguration.getStackTracesLimitPerInterval();
    }

    public static void clear() {
        tracesQueue.clear();
    }

    public static AgentElementsFilter getAgentElementsFilter() {
        return AGENT_ELEMENTS_FILTER;
    }

    public static class AgentElementsFilter {
        private final Set<Pattern> packagePrefixesForAgentElements = new HashSet<Pattern>();
        private static final String GET_STACK_TRACE_ELEMENT_CLASS_NAME = "java.lang.Thread";
        private static final String GET_STACK_TRACE_ELEMENT_METHOD_NAME = "getStackTrace";
        private static final String GET_STACK_TRACE_ELEMENT_NAME = Utils.getFqMethodName("java.lang.Thread", "getStackTrace");
        private static final String SUGGEST_STACK_TRACE_RECORDING_METHOD_NAME = "suggestStackTraceRecording";
        private static final Set<String> classesToFilterOut = new HashSet<String>(2);
        private static final Set<String> substitutedClassMethods = new HashSet<String>(5);

        static {
            classesToFilterOut.add(GET_STACK_TRACE_ELEMENT_CLASS_NAME);
            substitutedClassMethods.add(Utils.getFqMethodName(ManagedDatagramSocket.class.getName(), "send"));
            substitutedClassMethods.add(Utils.getFqMethodName(ManagedDatagramSocket.class.getName(), "receive"));
            substitutedClassMethods.add(Utils.getFqMethodName(ManagedSocketOutputStream.class.getName(), "write"));
            substitutedClassMethods.add(Utils.getFqMethodName(ManagedSocketInputStream.class.getName(), "read"));
        }

        public AgentElementsFilter(Set<String> packageExprns) {
            this(packageExprns, true);
        }

        public AgentElementsFilter(Set<String> packageExprns, boolean isRegexBased) {
            for (String packageExpr : packageExprns) {
                if (!isRegexBased) {
                    packageExpr = Utils.convertToPackageRegex(packageExpr);
                }
                this.packagePrefixesForAgentElements.add(Pattern.compile(packageExpr, 2));
            }
        }

        public AgentElementsFilter(String commadSepratedPackagesList) {
            String[] stringArray = commadSepratedPackagesList.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pkg = stringArray[n2];
                pkg = Utils.convertToPackageRegex(pkg);
                this.packagePrefixesForAgentElements.add(Pattern.compile(pkg, 2));
                ++n2;
            }
        }

        public AgentElementsFilter() {
            this("com.ca,com.wily");
        }

        public StackTraceElement[] filter(StackTraceElement[] traceElements) {
            if (traceElements != null && traceElements.length > 0) {
                StackTraceElement element = null;
                int size = traceElements.length;
                int index = 0;
                String fqMethod = "";
                boolean foundThreadElement = false;
                while (index < size) {
                    element = traceElements[index];
                    fqMethod = Utils.getFqMethodName(element.getClassName(), element.getMethodName());
                    if (GET_STACK_TRACE_ELEMENT_NAME.equals(fqMethod)) {
                        foundThreadElement = true;
                    }
                    if (foundThreadElement && (substitutedClassMethods.contains(fqMethod) || !Utils.doesElementPackageMatch(element, this.packagePrefixesForAgentElements) && !classesToFilterOut.contains(element.getClassName()) && !element.getMethodName().equals(SUGGEST_STACK_TRACE_RECORDING_METHOD_NAME))) break;
                    ++index;
                }
                if (foundThreadElement) {
                    return Arrays.copyOfRange(traceElements, index, size);
                }
            }
            return traceElements;
        }
    }
}

