/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.exitpoint.stacktrace;

import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.intelligent.detection.ConditionalTraceRecorder;
import com.wily.introscope.agent.intelligent.detection.RecordingData;
import com.wily.introscope.agent.intelligent.detection.StackTraceProvider;
import com.wily.introscope.agent.intelligent.entrypoint.common.Utils;
import com.wily.introscope.agent.intelligent.exitpoint.ExitPointDetectionConfiguration;
import com.wily.introscope.agent.intelligent.exitpoint.stacktrace.ThreadSelector;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.intelligent.Logger;

public class ExitPointStackTraceRecorder
implements ConditionalTraceRecorder {
    private static final Logger.ILoggingHandler LOGGER = ExitPointDetectionConfiguration.getLogger();
    private final ThreadSelector threadSelector = new ThreadSelector();

    @Override
    public boolean record(RecordingData threadLocalRecData, StackTraceProvider provider) {
        if (this.shouldRecordStackTrace(threadLocalRecData)) {
            boolean status = this.recordTraceInternal(threadLocalRecData);
            if (status) {
                this.notifyRecordingListeners(threadLocalRecData);
            }
            return status;
        }
        return false;
    }

    private boolean recordTraceInternal(RecordingData threadLocalData) {
        LOGGER.logDebugMessage("StackTraceRecorder: Recording stack trace in repository");
        StackTraceElement[] traceElements = Thread.currentThread().getStackTrace();
        boolean status = threadLocalData.acceptTrace(traceElements);
        return status;
    }

    private void logTraceIfEnabled(StackTraceElement[] traceElements) {
        if (LOGGER.isTraceEnabled() && ExitPointDetectionConfiguration.shouldLogStackTraces()) {
            String traceAsString = Utils.getStringRepresentationOfTrace(traceElements);
            LOGGER.logTraceMessage("Stack Trace: \n" + traceAsString);
        }
    }

    private boolean shouldRecordStackTrace(RecordingData threadLocalData) {
        if (!ExitPointDetectionConfiguration.isExitPointDetectionEnabled()) {
            return false;
        }
        VirtualStack.TransactionCache cache = VirtualStack.getTransactionCache();
        if (cache.getStartTransactionElement() != null && cache.getBackend() == null) {
            return this.threadSelector.shouldRecordTrace(threadLocalData);
        }
        return false;
    }

    private boolean isEntryPointInStack(VirtualStack.TransactionCache cache) {
        ITransactionElement txnElement = cache.getStartTransactionElement();
        return txnElement != null && txnElement instanceof IBlameTransactionElement && ((IBlameTransactionElement)txnElement).isAutomaticEntryPoint();
    }

    private void notifyRecordingListeners(RecordingData threadLocalData) {
        this.threadSelector.notifyOnRecording(threadLocalData);
    }

    public ThreadSelector getThreadSelector() {
        return this.threadSelector;
    }
}

