/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.intelligent.instrumentation.util;

import com.wily.introscope.probebuilder.intelligent.instrumentation.FilePersistenceService;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class MethodInfo {
    private final String methodName;
    private String methodDesciptor;
    private final Set<FilePersistenceService.TracingType> traceTypes = new HashSet<FilePersistenceService.TracingType>();

    public MethodInfo(String method, String desc) {
        this(method, desc, FilePersistenceService.TracingType.SKIP);
    }

    public MethodInfo(String method, String desc, FilePersistenceService.TracingType type) {
        this.methodName = method;
        this.methodDesciptor = desc;
        this.traceTypes.add(type);
    }

    public MethodInfo(String method, String desc, Collection<FilePersistenceService.TracingType> types) {
        this.methodName = method;
        this.methodDesciptor = desc;
        this.traceTypes.addAll(types);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodDesciptor() {
        return this.methodDesciptor;
    }

    public void setMethodDesciptor(String methodDesciptor) {
        this.methodDesciptor = methodDesciptor;
    }

    public Collection<FilePersistenceService.TracingType> getTracingTypes() {
        return this.traceTypes;
    }

    public void addTraceType(FilePersistenceService.TracingType traceType) {
        this.traceTypes.add(traceType);
    }

    public void addTraceTypes(Collection<FilePersistenceService.TracingType> traceTypes) {
        this.traceTypes.addAll(traceTypes);
    }

    public boolean isSkipped() {
        for (FilePersistenceService.TracingType key : this.getTracingTypes()) {
            if (key != FilePersistenceService.TracingType.SKIP) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object info) {
        if (this == info) {
            return true;
        }
        if (!(info instanceof MethodInfo)) {
            return false;
        }
        MethodInfo methodInfo = (MethodInfo)info;
        return this.getMethodName().equals(methodInfo.getMethodName()) && this.getMethodDesciptor().equals(methodInfo.getMethodDesciptor()) && this.getTracingTypes().equals(methodInfo.getTracingTypes());
    }

    public int hashCode() {
        int h = this.getMethodName().hashCode();
        h += this.getMethodDesciptor().hashCode();
        return h += this.getTracingTypes().hashCode();
    }

    public String toString() {
        return String.format("[methodName: %s,  descriptor: %s, trace types: %s]", this.methodName, this.methodDesciptor, this.traceTypes);
    }
}

