/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.scoring;

import java.util.Stack;

public class MethodScoreCalculator {
    private static final int kGotoOperandsOffset = 3;
    private int currentSum;
    private Stack<BlockInfo> blockStack = new Stack();

    public void increment(int value) {
        this.currentSum += value;
        this.incrementStackTop(value);
    }

    private void incrementStackTop(int value) {
        if (!this.blockStack.isEmpty()) {
            BlockInfo info = this.blockStack.peek();
            info.sum += value;
        }
    }

    public int getCurrentSum() {
        return this.currentSum;
    }

    public void handleIfBlockStart(int lineNumber, int jumpTarget) {
        this.blockStack.push(new BlockInfo(BlockType.TYPE1, lineNumber, jumpTarget));
    }

    public void handleBckGoto(int lineNumber, int jumpTarget, int factor) {
        Stack<BlockInfo> tempStack = new Stack<BlockInfo>();
        boolean restore = true;
        while (!this.blockStack.isEmpty()) {
            BlockInfo current = this.blockStack.pop();
            tempStack.push(current);
            if (!this.matchesType1LoopEnd(current, lineNumber, jumpTarget)) continue;
            int intermediateBlockSums = this.aggregateTempStackBlockSums(tempStack);
            this.currentSum += intermediateBlockSums * (factor - 1);
            this.updateTopWithIntermediateBlockSum(this.blockStack, intermediateBlockSums, factor);
            restore = false;
            break;
        }
        if (restore) {
            while (!tempStack.isEmpty()) {
                this.blockStack.push((BlockInfo)tempStack.pop());
            }
        }
    }

    private boolean matchesType1LoopEnd(BlockInfo blkEntry, int lineNumber, int jumpTarget) {
        return blkEntry.type == BlockType.TYPE1 && blkEntry.jumpTarget == lineNumber + 3;
    }

    public void handleGotoBlockStart(int lineNumber, int jumpTarget) {
        this.blockStack.push(new BlockInfo(BlockType.TYPE2, lineNumber, jumpTarget));
    }

    public void handleBckJumpIf(int lineNumber, int jumpTarget, int factor) {
        Stack<BlockInfo> tempStack = new Stack<BlockInfo>();
        boolean restore = true;
        while (!this.blockStack.isEmpty()) {
            BlockInfo current = this.blockStack.pop();
            tempStack.push(current);
            if (!this.matchesType2LoopEnd(current, lineNumber, jumpTarget)) continue;
            int intermediateBlockSums = this.aggregateTempStackBlockSums(tempStack);
            this.currentSum += intermediateBlockSums * (factor - 1);
            if (this.foundOrphanLoop(current, lineNumber, jumpTarget)) {
                current.sum = intermediateBlockSums * factor;
                this.blockStack.push(current);
            } else {
                this.updateTopWithIntermediateBlockSum(this.blockStack, intermediateBlockSums, factor);
            }
            restore = false;
            break;
        }
        if (restore) {
            while (!tempStack.isEmpty()) {
                this.blockStack.push((BlockInfo)tempStack.pop());
            }
        }
    }

    private boolean foundOrphanLoop(BlockInfo blkEntry, int lineNumber, int jumpTarget) {
        return lineNumber < blkEntry.jumpTarget;
    }

    private boolean matchesType2LoopEnd(BlockInfo blkEntry, int lineNumber, int jumpTarget) {
        return blkEntry.type == BlockType.TYPE2 && jumpTarget > blkEntry.line;
    }

    private int aggregateTempStackBlockSums(Stack<BlockInfo> tempStack) {
        int sum = 0;
        while (!tempStack.isEmpty()) {
            sum += tempStack.pop().sum;
        }
        return sum;
    }

    private void updateTopWithIntermediateBlockSum(Stack<BlockInfo> stack, int sum, int factor) {
        if (!stack.isEmpty()) {
            stack.peek().sum += sum * factor;
        }
    }

    public void handleSynStart() {
        this.blockStack.push(new BlockInfo(BlockType.SYNCHRONIZED, -1, -1));
    }

    public void handleSyncEnd(int factor) {
        int sum = 0;
        while (!this.blockStack.isEmpty()) {
            BlockInfo current = this.blockStack.pop();
            sum += current.sum;
            if (current.type == BlockType.SYNCHRONIZED) break;
        }
        this.currentSum += sum * (factor - 1);
        this.incrementStackTop(sum * factor);
    }

    int getStackSize() {
        return this.blockStack.size();
    }

    int getTopElementScore() {
        return this.blockStack.peek().sum;
    }

    private class BlockInfo {
        BlockType type;
        int line;
        int jumpTarget;
        int sum;

        private BlockInfo(BlockType type, int lineNumber, int jumpT) {
            this.type = type;
            this.line = lineNumber;
            this.jumpTarget = jumpT;
            this.sum = 0;
        }

        public String toString() {
            return "BlockInfo [type=" + (Object)((Object)this.type) + ", line=" + this.line + ", jumpTarget=" + this.jumpTarget + ", sum=" + this.sum + "]";
        }
    }

    private static enum BlockType {
        TYPE1,
        TYPE2,
        SYNCHRONIZED;

    }
}

