/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.servlethelper;

import com.wily.introscope.agent.servlet.WilyServletInputStream;
import com.wily.introscope.agent.trace.servlet.IDirectParameterAccessor;
import com.wily.introscope.agent.trace.servlet.IServletRequestHelper;
import com.wily.introscope.agent.trace.servlet.LoaderContext;
import com.wily.introscope.agent.urlgroup.TomcatUtil;
import com.wily.introscope.spec.agent.bizdef.KBizDefConstants;
import com.wily.introscope.spec.server.MetricNameUtils;
import com.wily.util.adt.WeakIdentityHashMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ServletRequestHelper
implements IServletRequestHelper {
    private static final ThreadLocal kPostMaps = null;
    private static final Set<String> keySet = new HashSet<String>();
    private static final Set<String> postKeySet = new HashSet<String>();
    private static final Set<String> extraKeySet = new HashSet<String>();
    private IModuleFeedbackChannel fFeedback = null;
    private static final String kDefaultCharacterEncoding = "UTF-8";

    static {
        keySet.add("Context Path");
        keySet.add("Scheme");
        keySet.add("Server Name");
        keySet.add("Server Port");
        keySet.add("URL");
        keySet.add("URL Query");
        keySet.add("Refering URL");
        keySet.add("CorGUID");
        keySet.add("Session ID");
        keySet.add("Application Name");
        keySet.add("HTTP Method");
        keySet.add("Remote Client Address");
        keySet.add("User ID");
        extraKeySet.add("introscope.agent.HttpServletTracer.headerParameters");
        extraKeySet.add("XWTG");
        extraKeySet.add("introscope.agent.HttpServletTracer.cookieParameters");
        postKeySet.add("introscope.agent.HttpServletTracer.postParameters");
    }

    public void setFeedback(IModuleFeedbackChannel inFeedback) {
        this.fFeedback = inFeedback;
    }

    public String getAttribute(Object object, String name) {
        Object result = ((HttpServletRequest)object).getAttribute(name);
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    public String getCharacterEncoding(Object object) {
        return ((HttpServletRequest)object).getCharacterEncoding();
    }

    public void setCharacterEncoding(Object object, String encodingType) {
        block3: {
            try {
                HttpServletRequest request = (HttpServletRequest)object;
                request.setCharacterEncoding(encodingType);
                if (this.fFeedback != null && this.fFeedback.isDebugEnabled()) {
                    this.fFeedback.debug("setCharacterEncoding sets encoding type to be:" + encodingType);
                }
            }
            catch (UnsupportedEncodingException ex) {
                if (this.fFeedback == null || !this.fFeedback.isDebugEnabled()) break block3;
                this.fFeedback.debug("setCharacterEncoding fails for:" + encodingType + ex.getMessage());
            }
        }
    }

    public String getContextPath(Object object) {
        return ((HttpServletRequest)object).getContextPath();
    }

    public Object[] getCookies(Object object) {
        return ((HttpServletRequest)object).getCookies();
    }

    public String getHeader(Object object, String headerName) {
        return ((HttpServletRequest)object).getHeader(headerName);
    }

    public Enumeration getHeaderNames(Object object) {
        return ((HttpServletRequest)object).getHeaderNames();
    }

    public String getLocalAddr(Object object) {
        return ((HttpServletRequest)object).getLocalAddr();
    }

    public String getMethod(Object object) {
        return ((HttpServletRequest)object).getMethod();
    }

    public Map getParameterMap(Object request, String parEncoding) {
        String requestEncoding = this.getCharacterEncoding(request);
        if (this.fFeedback != null && this.fFeedback.isDebugEnabled()) {
            this.fFeedback.debug("getParameterMap: URI=" + this.getRequestURI(request) + ", parEncoding=" + parEncoding + ", requestEncoding=" + requestEncoding);
        }
        if (parEncoding != null && requestEncoding == null) {
            this.setCharacterEncoding(request, parEncoding);
        }
        String queryString = this.getQueryString(request);
        Map localMap = new HashMap();
        try {
            String encoding = this.getSafeCharacterEncoding(request, parEncoding);
            TomcatUtil.parseParameters(localMap, (String)queryString, (String)encoding);
            if (queryString != null && this.fFeedback != null && this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug("getParameterMap: query string-" + queryString + " encoding-" + encoding + " request type-" + request.getClass().toString());
                Set mapEntries = localMap.entrySet();
                for (Map.Entry currEntry : mapEntries) {
                    String[] values = (String[])currEntry.getValue();
                    String valuesString = null;
                    String[] stringArray = values;
                    int n = values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String currValue = stringArray[n2];
                        if (valuesString == null) {
                            valuesString = currValue;
                        } else {
                            valuesString.concat(";" + currValue);
                        }
                        ++n2;
                    }
                    this.fFeedback.debug("getParameterMap: key-" + (String)currEntry.getKey() + " value-" + valuesString);
                }
            }
        }
        catch (Throwable throwable) {
            localMap = Collections.EMPTY_MAP;
        }
        return localMap;
    }

    public Map getParameterMap(Object request) {
        return ((HttpServletRequest)request).getParameterMap();
    }

    public String getProtocol(Object object) {
        return ((HttpServletRequest)object).getProtocol();
    }

    public String getQueryString(Object object) {
        return ((HttpServletRequest)object).getQueryString();
    }

    public BufferedReader getReader(Object object) {
        try {
            return ((HttpServletRequest)object).getReader();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getRemoteAddr(Object object) {
        return ((HttpServletRequest)object).getRemoteAddr();
    }

    public int getRemotePort(Object object) {
        return ((HttpServletRequest)object).getRemotePort();
    }

    public String getRemoteUser(Object object) {
        return ((HttpServletRequest)object).getRemoteUser();
    }

    public String getRequestURI(Object object) {
        return ((HttpServletRequest)object).getRequestURI();
    }

    public String getRequestedSessionId(Object request) {
        return ((HttpServletRequest)request).getRequestedSessionId();
    }

    public String getScheme(Object object) {
        return ((HttpServletRequest)object).getScheme();
    }

    public String getServerName(Object object) {
        return ((HttpServletRequest)object).getServerName();
    }

    public int getServerPort(Object object) {
        return ((HttpServletRequest)object).getServerPort();
    }

    public String getServletPath(Object object) {
        return ((HttpServletRequest)object).getServletPath();
    }

    public Object getSession(boolean create, Object request) {
        return ((HttpServletRequest)request).getSession(create);
    }

    public Object getServletConfig(Object servlet) {
        if (servlet instanceof Servlet) {
            return ((Servlet)servlet).getServletConfig();
        }
        return null;
    }

    public Object getServletContext(Object object) {
        return ((ServletConfig)object).getServletContext();
    }

    public String getServletName(Object object) {
        return ((ServletConfig)object).getServletName();
    }

    public String getServletContextName(Object object) {
        return ((ServletContext)object).getServletContextName();
    }

    public String safeGetServletContextName(Object object) {
        String result = null;
        try {
            Object servletContext = this.getServletContext(object);
            ServletContext sc = (ServletContext)servletContext;
            result = sc.getServletContextName();
        }
        catch (Exception exception) {}
        return result;
    }

    public String safeGetServletContextStringIdentifier(Object request, Object servletconfig) {
        String result = null;
        result = this.safeGetServletContextName(servletconfig);
        if (result == null && (result = this.getContextPath(request)) != null && result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    public String getRealPath(Object object, String path) {
        return ((ServletContext)object).getRealPath(path);
    }

    public URL getResource(Object object, String resource) throws MalformedURLException {
        return ((ServletContext)object).getResource(resource);
    }

    public InputStream getResourceAsStream(Object object, String resource) {
        return ((ServletContext)object).getResourceAsStream(resource);
    }

    public String getId(Object session) {
        return ((HttpSession)session).getId();
    }

    public String getSessionAttribute(Object httpSession, String name) {
        Object result = ((HttpSession)httpSession).getAttribute(name);
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    public String getSessionValue(Object httpSession, String name) {
        Object result = ((HttpSession)httpSession).getValue(name);
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    public Object getServerPortAsInteger(Object request) {
        return new Integer(this.getServerPort(request));
    }

    public String getApplicationName(Object request, Object servlet) {
        String result = null;
        Object servletconfig = this.getServletConfig(servlet);
        result = this.safeGetServletContextStringIdentifier(request, servletconfig);
        if (MetricNameUtils.containsMetricSeparatorChars((String)result)) {
            result = MetricNameUtils.substituteMetricSeparatorChars((String)result);
        }
        return result;
    }

    public String getSafeCharacterEncoding(Object request, String fCharacterEncoding) {
        String encoding = null;
        try {
            encoding = this.getCharacterEncoding(request);
        }
        catch (Throwable throwable) {}
        encoding = encoding == null ? fCharacterEncoding : encoding;
        encoding = encoding == null ? kDefaultCharacterEncoding : encoding;
        return encoding;
    }

    public Set getKeySet() {
        return keySet;
    }

    public Set getPostKeySet() {
        return postKeySet;
    }

    public Set getExtraKeySet() {
        return extraKeySet;
    }

    public Object get(Object request, Object servlet, Map parameterMap, LoaderContext context, Object next, String charEncoding) {
        if (next == null) {
            return null;
        }
        if (next instanceof String) {
            String key;
            block40: {
                block39: {
                    block38: {
                        Map result;
                        key = next.toString();
                        if (key.startsWith("httprequest.header.")) {
                            return this.activateAccessor(request, context, (IDirectParameterAccessor)context.getAccessor((Object)key), parameterMap);
                        }
                        if (key.startsWith("httprequest.attribute.")) {
                            return this.activateAccessor(request, context, (IDirectParameterAccessor)context.getAccessor((Object)key), parameterMap);
                        }
                        if (key.startsWith("httpsession.attribute.")) {
                            return this.activateAccessor(request, context, (IDirectParameterAccessor)context.getAccessor((Object)key), parameterMap);
                        }
                        if (key.startsWith("httprequest.parameter.")) {
                            if (parameterMap.isEmpty()) {
                                parameterMap.putAll(this.getParameterMap(request, charEncoding));
                            }
                            return this.activateAccessor(request, context, (IDirectParameterAccessor)context.getAccessor((Object)key), parameterMap);
                        }
                        if (!key.equals("introscope.agent.HttpServletTracer.postParameters")) break block38;
                        if (parameterMap.isEmpty()) {
                            parameterMap.putAll(this.getParameterMap(request, charEncoding));
                        }
                        if ((result = this.getPostParameterMap(request, parameterMap, charEncoding)) != null && result.size() > 0) {
                            return result;
                        }
                        return null;
                    }
                    if (key.equals("User ID")) {
                        return context.getUserIdAccessor().IUserIDAccessor_accessUserID((IServletRequestHelper)this, request);
                    }
                    if (key.equals("Context Path")) {
                        return this.getContextPath(request);
                    }
                    if (key.equals("Scheme")) {
                        return this.getScheme(request);
                    }
                    if (key.equals("Server Port")) {
                        return Integer.toString(this.getServerPort(request));
                    }
                    if (key.equals("Remote Client Address")) {
                        return this.getRemoteAddr(request);
                    }
                    if (key.equals("Server Name")) {
                        return this.getServerName(request);
                    }
                    if (key.equals("URL")) {
                        return this.getRequestURI(request);
                    }
                    if (key.equals("URL Query")) {
                        return this.getQueryString(request);
                    }
                    if (key.equals("Refering URL")) {
                        return this.getHeader(request, key);
                    }
                    if (!key.equals("CorGUID")) break block39;
                    String wilyCorrelation = this.getAttribute(request, key);
                    if (wilyCorrelation != null && !wilyCorrelation.equals("0")) {
                        return wilyCorrelation;
                    }
                    return null;
                }
                if (!key.equals("Session ID")) break block40;
                try {
                    return this.getId(this.getSession(false, request));
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable throwable) {
                    try {
                        return this.getRequestedSessionId(request);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable2) {
                        return null;
                    }
                }
            }
            try {
                if (key.equals("Application Name")) {
                    return this.getServletContextName(this.getServletConfig(servlet));
                }
                if (key.equals("HTTP Method")) {
                    return this.getMethod(request);
                }
                if (key.equals("introscope.agent.HttpServletTracer.headerParameters")) {
                    return this.getHeaderParamMap(request);
                }
                if (key.equals("XWTG")) {
                    return this.getXWTGParamMap(request);
                }
                if (key.equals("introscope.agent.HttpServletTracer.cookieParameters")) {
                    return this.getCookieMap(request);
                }
                if (key.equals("x-apm-bt")) {
                    return this.getExternalbtParamter(request);
                }
                if (key.equals("x-apm-bt")) {
                    return this.getBRTMbtParamter(request);
                }
                return null;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return null;
    }

    private Object activateAccessor(Object request, LoaderContext context, IDirectParameterAccessor accessor, Map parameterMap) {
        if (accessor != null) {
            return accessor.IParameterAccessor_accessParameter((IServletRequestHelper)this, request, context, parameterMap);
        }
        return null;
    }

    public Map getPostParameterMap(Object request, Map fParameterMap, String parEncoding) {
        Map localMap;
        HashMap<String, String> fPostParameterMap = new HashMap<String, String>();
        String requestEncoding = this.getCharacterEncoding(request);
        if (this.fFeedback != null && this.fFeedback.isDebugEnabled()) {
            this.fFeedback.debug("getPostParameterMap: URI=" + this.getRequestURI(request) + ", fParameterMap=" + fParameterMap + ", parEncoding=" + parEncoding + ", requestEncoding=" + requestEncoding);
        }
        if (parEncoding != null && requestEncoding == null) {
            this.setCharacterEncoding(request, parEncoding);
        }
        if ((localMap = this.getParameterMap(request)) != null) {
            for (Map.Entry localEntry : localMap.entrySet()) {
                String queryValue;
                String localKey = (String)localEntry.getKey();
                String localValue = null;
                Object localObjValue = localEntry.getValue();
                if (localObjValue instanceof String) {
                    localValue = (String)localObjValue;
                } else if (localObjValue instanceof String[]) {
                    localValue = ((String[])localObjValue)[0];
                }
                if (fParameterMap.get(localKey) == null) {
                    fPostParameterMap.put(localKey, localValue);
                    continue;
                }
                if (fParameterMap.get(localKey) instanceof String && !fParameterMap.get(localKey).equals(localValue)) {
                    fPostParameterMap.put(localKey, localValue);
                    continue;
                }
                if (!(fParameterMap.get(localKey) instanceof String[]) || localValue.equals(queryValue = ((String[])fParameterMap.get(localKey))[0])) continue;
                fPostParameterMap.put(localKey, localValue);
            }
        }
        return fPostParameterMap;
    }

    public Object getServletInputStream(Object original, byte[] content) throws IOException {
        return WilyServletInputStream.getWilyServletInputStream((ServletInputStream)original, content);
    }

    private Map getHeaderParamMap(Object servletRequest) {
        HashMap<String, String> headersMap = null;
        Enumeration headerNames = this.getHeaderNames(servletRequest);
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerKey = (String)headerNames.nextElement();
                if (headerKey == null || headerKey.toString().trim().toLowerCase().equals("cookie") || headerKey.toString().trim().toLowerCase().equals("x-wtg-info") || headerKey.toString().trim().toLowerCase().equals("host")) continue;
                String headerValue = this.getHeader(servletRequest, headerKey);
                if (headersMap == null) {
                    headersMap = new HashMap<String, String>();
                    headersMap.put(headerKey, headerValue);
                    continue;
                }
                headersMap.put(headerKey, headerValue);
            }
        }
        return headersMap;
    }

    private Object getXWTGParamMap(Object request) {
        String xWTGParam = null;
        Enumeration headerNames = this.getHeaderNames(request);
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerKey = (String)headerNames.nextElement();
                if (headerKey == null || !headerKey.toString().trim().toLowerCase().equals("x-wtg-info")) continue;
                xWTGParam = this.getHeader(request, headerKey);
            }
        }
        if (xWTGParam != null) {
            HashMap xWTGInfoParamMap = new HashMap();
            int startIndex = 0;
            if (xWTGParam.toLowerCase().startsWith(KBizDefConstants.kBizXWTGINFOHeaderStartValue)) {
                if ((startIndex += KBizDefConstants.kBizXWTGINFOHeaderStartValue.length()) < xWTGParam.length()) {
                    xWTGParam = xWTGParam.substring(startIndex);
                } else {
                    startIndex = 0;
                }
            }
            if (startIndex > 0) {
                try {
                    TomcatUtil.parseParameters(xWTGInfoParamMap, (String)xWTGParam, (String)kDefaultCharacterEncoding);
                    if (xWTGInfoParamMap != null && xWTGInfoParamMap.size() > 0) {
                        return xWTGInfoParamMap;
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return null;
                }
            }
        }
        return null;
    }

    private String getExternalbtParamter(Object request) {
        new HashMap();
        String header = null;
        Enumeration headerNames = this.getHeaderNames(request);
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerKey = (String)headerNames.nextElement();
                if (headerKey == null || !headerKey.toString().trim().toLowerCase().equals("x-apm-bt")) continue;
                header = this.getHeader(request, headerKey);
            }
        }
        return header;
    }

    private String getBRTMbtParamter(Object request) {
        new HashMap();
        String header = null;
        Enumeration headerNames = this.getHeaderNames(request);
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerKey = (String)headerNames.nextElement();
                if (headerKey == null || !headerKey.toString().trim().toLowerCase().equals("x-apm-bt")) continue;
                header = this.getHeader(request, headerKey);
            }
        }
        return header;
    }

    private Object getCookieMap(Object request) {
        HashMap<String, String> cookiesMap = new HashMap<String, String>();
        Object[] cookies = this.getCookies(request);
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                if (cookies[i] != null) {
                    Cookie c = (Cookie)cookies[i];
                    String cookieKey = c.getName();
                    String cookieValue = c.getValue();
                    if (cookieKey != null && cookieValue != null) {
                        cookiesMap.put(cookieKey, cookieValue);
                    }
                }
                ++i;
            }
        }
        if (cookiesMap.size() > 0) {
            return cookiesMap;
        }
        return null;
    }

    public Map getParameterMapAndStoreStream(Object request) {
        try {
            this.storeStream(request);
            return ((HttpServletRequest)request).getParameterMap();
        }
        catch (IOException iOException) {
            return new HashMap();
        }
    }

    private void storeStream(Object request) throws IOException {
        int nRead;
        ServletInputStream is = ((ServletRequest)request).getInputStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        byte[] result = buffer.toByteArray();
        WeakIdentityHashMap map = this.getStorageMap();
        if (map != null) {
            map.put(request, result);
        }
    }

    public byte[] getStoredRequestStream(Object request) {
        Object result;
        WeakIdentityHashMap map = this.getStorageMap();
        if (map != null && (result = map.get(request)) != null) {
            return (byte[])result;
        }
        return null;
    }

    private WeakIdentityHashMap getStorageMap() {
        if (kPostMaps != null) {
            return (WeakIdentityHashMap)kPostMaps.get();
        }
        return null;
    }
}

