/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import java.util.EmptyStackException;

public final class IntStack {
    static final int kDefaultCapacity = 32;
    private int[] fStack = new int[32];
    private int fCurrentIndex = -1;

    public void reset() {
        this.fCurrentIndex = -1;
    }

    public boolean isEmpty() {
        return this.fCurrentIndex == -1;
    }

    public void push(int num) {
        ++this.fCurrentIndex;
        if (this.fCurrentIndex >= this.fStack.length) {
            int[] newStack = new int[this.fStack.length * 2];
            System.arraycopy(this.fStack, 0, newStack, 0, this.fStack.length);
            this.fStack = newStack;
        }
        this.fStack[this.fCurrentIndex] = num;
    }

    public int peek() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.fStack[this.fCurrentIndex];
    }

    public int pop() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        int val = this.fStack[this.fCurrentIndex];
        --this.fCurrentIndex;
        return val;
    }
}

