/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.format;

import com.wily.util.format.Messages;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class NaturalElapsedTimeFormat
extends NumberFormat {
    private static final long serialVersionUID = 1L;
    private final boolean fVerbose;
    private boolean fShowMillis = false;
    private Locale fLocale = Locale.getDefault();

    public NaturalElapsedTimeFormat() {
        this.fVerbose = true;
    }

    public NaturalElapsedTimeFormat(boolean verbose) {
        this.fVerbose = verbose;
    }

    public NaturalElapsedTimeFormat(Locale locale, boolean verbose) {
        this.fLocale = locale;
        this.fVerbose = verbose;
    }

    public NaturalElapsedTimeFormat setShowMillisPart(boolean v) {
        this.fShowMillis = v;
        return this;
    }

    public StringBuffer format(long milliseconds, StringBuffer toAppendTo, FieldPosition pos) {
        pos.setBeginIndex(toAppendTo.length());
        double seconds = (double)milliseconds / 1000.0;
        long minutes = (long)seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        seconds %= 60.0;
        minutes %= 60L;
        hours %= 24L;
        String prefix = !this.fVerbose ? "Short_" : "";
        StringBuffer pattern = new StringBuffer(14);
        if (days > 0L) {
            pattern.append(Messages.getString(this.fLocale, String.valueOf(prefix) + "ElapsedTime_DaysFormat"));
        }
        if (hours > 0L) {
            if (pattern.length() > 0) {
                pattern.append(this.fVerbose ? ", " : " ");
            }
            pattern.append(Messages.getString(this.fLocale, String.valueOf(prefix) + "ElapsedTime_HoursFormat"));
        }
        if (minutes > 0L) {
            if (pattern.length() > 0) {
                pattern.append(this.fVerbose ? ", " : " ");
            }
            pattern.append(Messages.getString(this.fLocale, String.valueOf(prefix) + "ElapsedTime_MinutesFormat"));
        }
        if (seconds > 0.0 || pattern.length() == 0 || this.fShowMillis) {
            if (pattern.length() > 0) {
                pattern.append(this.fVerbose ? ", " : " ");
            }
            if (this.fShowMillis) {
                pattern.append(Messages.getString(this.fLocale, String.valueOf(prefix) + "ElapsedTime_MSSecondsFormat"));
            } else {
                pattern.append(Messages.getString(this.fLocale, String.valueOf(prefix) + "ElapsedTime_SecondsFormat"));
            }
        }
        MessageFormat format = new MessageFormat(pattern.toString(), this.fLocale);
        return format.format(new Object[]{new Long(days), new Long(hours), new Long(minutes), new Double(seconds)}, toAppendTo, pos);
    }

    public Number parse(String source, ParsePosition parsePosition) {
        throw new UnsupportedOperationException(Messages.getString("NaturalElapsedTimeFormat.UnsupportedOperationError_Log"));
    }

    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format((long)number, toAppendTo, pos);
    }
}

