/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.interactivecommand;

import com.wily.util.interactivecommand.IInteractiveCommand;
import com.wily.util.interactivecommand.InteractiveCommandException;
import com.wily.util.texthelp.IHelpProviderListSupplier;
import com.wily.util.texthelp.ISingleCommandHelpProvider;
import com.wily.util.texthelp.TextualHelpProvider;
import com.wily.utilities.properties.Messages;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

class InteractiveCommandParser {
    private final Hashtable fCommandMap = new Hashtable();
    private final String fDelim;

    InteractiveCommandParser(String delim) {
        this.fDelim = delim;
    }

    public synchronized void registerCommand(IInteractiveCommand c) {
        String casedString = c.IInteractiveCommand_getName().toUpperCase();
        this.fCommandMap.put(casedString, c);
    }

    public synchronized String executeCommandString(String s) throws InteractiveCommandException {
        StringTokenizer commandEnum = new StringTokenizer(s, this.fDelim);
        if (!commandEnum.hasMoreElements()) {
            throw new InteractiveCommandException(Messages.getString("InteractiveCommandParser.EmptyCommandError_Log"));
        }
        String commandString = (String)commandEnum.nextElement();
        String casedString = commandString.toUpperCase();
        IInteractiveCommand command = (IInteractiveCommand)this.fCommandMap.get(casedString);
        if (command == null) {
            throw new InteractiveCommandException(String.valueOf(Messages.getString("InteractiveCommandParser.InteractiveCommandException_Log")) + commandString);
        }
        Vector<String> strings = new Vector<String>();
        while (commandEnum.hasMoreElements()) {
            String nextString = (String)commandEnum.nextElement();
            strings.addElement(nextString);
        }
        Object[] commands = new String[strings.size()];
        strings.copyInto(commands);
        return command.IInteractiveCommand_executeCommand((String[])commands);
    }

    public void printHelp(PrintWriter outputChannel) {
        TextualHelpProvider helpProvider = new TextualHelpProvider(new CommandHelpListSupplier());
        helpProvider.printHelp(outputChannel);
        outputChannel.flush();
    }

    private class CommandHelpListSupplier
    implements IHelpProviderListSupplier {
        private CommandHelpListSupplier() {
        }

        public ISingleCommandHelpProvider[] ICommandListSupplier_getHelpProviders() {
            Enumeration commands = InteractiveCommandParser.this.fCommandMap.elements();
            Vector bag = new Vector();
            while (commands.hasMoreElements()) {
                bag.addElement(commands.nextElement());
            }
            Object[] result = new ISingleCommandHelpProvider[bag.size()];
            bag.copyInto(result);
            return result;
        }
    }
}

