/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LazyFileOutputStream
extends OutputStream {
    private final File fFile;
    private FileOutputStream fOutput;

    public LazyFileOutputStream(File file) {
        this.fFile = file;
        this.fOutput = null;
    }

    private void createIfNecessary() throws IOException {
        if (this.fOutput == null) {
            this.fOutput = new FileOutputStream(this.fFile);
        }
    }

    public void write(int b) throws IOException {
        this.createIfNecessary();
        this.fOutput.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.createIfNecessary();
        this.fOutput.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.createIfNecessary();
        this.fOutput.write(b, off, len);
    }

    public void flush() throws IOException {
        if (this.fOutput != null) {
            this.fOutput.flush();
        }
    }

    public void close() throws IOException {
        if (this.fOutput != null) {
            this.fOutput.close();
        }
    }
}

