/*
 * Decompiled with CFR 0.152.
 */
package com.wily.apm.spec.tess.beans.bizdefinition;

import com.wily.apm.spec.tess.beans.bizdefinition.IBizDefinitionConstants;
import com.wily.util.adt.CanonicalObjectPool;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class SearchFilter
implements Externalizable,
IBizDefinitionConstants {
    private int fVersion = 1;
    private String fFieldName;
    private int fFieldType;
    private int fMatchOperator;
    private Object fFieldMatchValue;
    private static final Integer kIntZero = new Integer(0);
    private static final String[] sFieldNames = new String[]{"id", "description", "businessProcessName", "businessTransactionName", "transactionComponentName", "ts_creation_date", "ts_last_modified_date", "enabled", "incarnationId", "agentName"};

    public SearchFilter() {
    }

    public SearchFilter(String fieldName, int fieldType, int matchOperator, String fieldMatchValue) {
        this.fFieldName = this.canonicalizeFieldName(fieldName);
        this.fFieldType = fieldType;
        this.fMatchOperator = matchOperator;
        this.fFieldMatchValue = this.convertValue(fieldMatchValue);
    }

    public SearchFilter(String fieldName, int fieldType, int matchOperator) {
        this.fFieldName = this.canonicalizeFieldName(fieldName);
        this.fFieldType = fieldType;
        this.fMatchOperator = matchOperator;
    }

    public String getFieldName() {
        return this.fFieldName;
    }

    public void setFieldName(String fieldName) {
        this.fFieldName = this.canonicalizeFieldName(fieldName);
    }

    public int getFieldType() {
        return this.fFieldType;
    }

    public void setFieldType(int fieldType) {
        if (this.fFieldType == fieldType) {
            return;
        }
        this.fFieldType = fieldType;
        if (this.fFieldMatchValue != null) {
            this.fFieldMatchValue = this.convertValue(this.fFieldMatchValue.toString());
        }
    }

    public int getMatchOperator() {
        return this.fMatchOperator;
    }

    public void setMatchOperator(int matchOperator) {
        this.fMatchOperator = matchOperator;
    }

    public String getFieldMatchValue() {
        return this.fFieldMatchValue.toString();
    }

    public void setFieldMatchValue(String fieldMatchValue) {
        this.fFieldMatchValue = this.convertValue(fieldMatchValue);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fVersion = in.readInt();
        this.fFieldName = this.canonicalizeFieldName(in.readUTF());
        this.fFieldType = in.readInt();
        this.fMatchOperator = in.readInt();
        this.fFieldMatchValue = this.convertValue(in.readUTF());
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.fVersion);
        out.writeUTF(this.fFieldName);
        out.writeInt(this.fFieldType);
        out.writeInt(this.fMatchOperator);
        out.writeUTF(this.fFieldMatchValue.toString());
    }

    public boolean passes(Object fieldValue) {
        boolean bPasses = false;
        bPasses = this.fFieldType == 4 ? this.result((Boolean)this.fFieldMatchValue, (Boolean)fieldValue) : (this.fFieldType == 3 ? this.result((Double)this.fFieldMatchValue, (Double)fieldValue) : (this.fFieldType == 1 ? this.result((Integer)this.fFieldMatchValue, (Integer)fieldValue) : (this.fFieldType == 2 ? this.result((Long)this.fFieldMatchValue, (Long)fieldValue) : (this.fFieldType == 5 ? this.result((Short)this.fFieldMatchValue, (Short)fieldValue) : (this.fFieldType == 0 ? this.result((String)this.fFieldMatchValue, (String)fieldValue) : (this.fFieldType == 6 ? this.result((Long)this.fFieldMatchValue, (Long)fieldValue) : false))))));
        return bPasses;
    }

    private Object convertValue(String value) {
        if (this.fFieldType == 4) {
            return Boolean.valueOf(value) != false ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.fFieldType == 3) {
            return Double.valueOf(value);
        }
        if (this.fFieldType == 1) {
            Integer val = Integer.valueOf(value);
            if (val == 0) {
                return kIntZero;
            }
            return val;
        }
        if (this.fFieldType == 2) {
            return Long.valueOf(value);
        }
        if (this.fFieldType == 5) {
            return Short.valueOf(value);
        }
        if (this.fFieldType == 0) {
            return CanonicalObjectPool.getCanonicalString(String.valueOf(value));
        }
        if (this.fFieldType == 6) {
            return Long.valueOf(value);
        }
        return null;
    }

    private String canonicalizeFieldName(String name) {
        int i = sFieldNames.length - 1;
        while (i >= 0) {
            String fn = sFieldNames[i];
            if (name.equals(fn)) {
                return fn;
            }
            --i;
        }
        return name;
    }

    private boolean result(String matchValue, String fieldValue) {
        boolean bResult = false;
        bResult = this.fMatchOperator == 1 ? fieldValue.equals(matchValue) : (this.fMatchOperator == 2 ? !fieldValue.equals(matchValue) : (this.fMatchOperator == 3 ? fieldValue.compareTo(matchValue) > 0 : (this.fMatchOperator == 4 ? fieldValue.compareTo(matchValue) >= 0 : (this.fMatchOperator == 5 ? fieldValue.compareTo(matchValue) < 0 : (this.fMatchOperator == 6 ? fieldValue.compareTo(matchValue) <= 0 : false)))));
        return bResult;
    }

    private boolean result(Double matchValue, Double fieldValue) {
        boolean bResult = false;
        bResult = this.fMatchOperator == 1 ? fieldValue.doubleValue() == matchValue.doubleValue() : (this.fMatchOperator == 2 ? fieldValue.doubleValue() != matchValue.doubleValue() : (this.fMatchOperator == 3 ? fieldValue > matchValue : (this.fMatchOperator == 4 ? fieldValue >= matchValue : (this.fMatchOperator == 5 ? fieldValue < matchValue : (this.fMatchOperator == 6 ? fieldValue <= matchValue : false)))));
        return bResult;
    }

    private boolean result(Short matchValue, Short fieldValue) {
        boolean bResult = false;
        bResult = this.fMatchOperator == 1 ? fieldValue == matchValue : (this.fMatchOperator == 2 ? fieldValue != matchValue : (this.fMatchOperator == 3 ? fieldValue > matchValue : (this.fMatchOperator == 4 ? fieldValue >= matchValue : (this.fMatchOperator == 5 ? fieldValue < matchValue : (this.fMatchOperator == 6 ? fieldValue <= matchValue : false)))));
        return bResult;
    }

    private boolean result(Long matchValue, Long fieldValue) {
        boolean bResult = false;
        bResult = this.fMatchOperator == 1 ? fieldValue.longValue() == matchValue.longValue() : (this.fMatchOperator == 2 ? fieldValue.longValue() != matchValue.longValue() : (this.fMatchOperator == 3 ? fieldValue > matchValue : (this.fMatchOperator == 4 ? fieldValue >= matchValue : (this.fMatchOperator == 5 ? fieldValue < matchValue : (this.fMatchOperator == 6 ? fieldValue <= matchValue : false)))));
        return bResult;
    }

    private boolean result(Integer matchValue, Integer fieldValue) {
        boolean bResult = false;
        bResult = this.fMatchOperator == 1 ? fieldValue.intValue() == matchValue.intValue() : (this.fMatchOperator == 2 ? fieldValue.intValue() != matchValue.intValue() : (this.fMatchOperator == 3 ? fieldValue > matchValue : (this.fMatchOperator == 4 ? fieldValue >= matchValue : (this.fMatchOperator == 5 ? fieldValue < matchValue : (this.fMatchOperator == 6 ? fieldValue <= matchValue : false)))));
        return bResult;
    }

    private boolean result(Boolean matchValue, Boolean fieldValue) {
        boolean bResult = false;
        bResult = this.fMatchOperator == 1 ? fieldValue == matchValue : (this.fMatchOperator == 2 ? fieldValue != matchValue : false);
        return bResult;
    }
}

