/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.classmatcher;

import com.wily.diagnos.cmp.classmatcher.AImmutableClassMatcher;
import com.wily.diagnos.cmp.directives.utility.CompilerSettingsUtility;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.ClassFileUtilities;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;

public class DGExactClassMatcher
extends AImmutableClassMatcher {
    protected final IClassName fClassName;

    public DGExactClassMatcher(IClassName className) {
        this.fClassName = className;
    }

    public boolean IClassMatcher_matches(IModeledClass cls) {
        return this.IClassMatcher_matches(cls.getClassName());
    }

    public boolean IClassMatcher_supportsNameMatching() {
        return true;
    }

    public boolean IClassMatcher_matches(IClassName className) {
        boolean result = ClassFileUtilities.looselyMatches(this.fClassName, className);
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setSkipCause(1024);
            current.setExactClassMatcherPattern(this.fClassName);
        }
        return result;
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode(result, this.fClassName);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DGExactClassMatcher) {
            DGExactClassMatcher m = (DGExactClassMatcher)obj;
            return this.fClassName.equals(m.fClassName);
        }
        return false;
    }

    public String[] getMatcherKeys() {
        return new String[]{CompilerSettingsUtility.getKeyFromString(this.fClassName.getPackageAndNameString())};
    }
}

