/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.ADirective;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.InvalidDirectiveException;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.transform.builder.SubstituteObjRefResultTransformationBuilder;
import com.wily.util.classfile.FullyQualifiedMethodName;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IMethodSignature;
import com.wily.util.classfile.ISlotSignature;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;

public final class SubstituteResultIfFlaggedDirective
extends ADirective {
    private static final String kMethodMustHaveExactlyOneParameterMessage = "Method must have exactly one parameter: ";
    private static final String kParameterMustBeObjectReferenceMessage = "Method must have an object reference type for the parameter: ";
    private static final String kParameterAndReturnTypeMustMatchMessage = "Method must have matching parameter and return types: ";
    private static final String kReturnTypesMustMatchMessage = "Return types for the two methods must match";
    private final FlagName fFlagName;
    private final IMethodName fSourceMethod;
    private final FullyQualifiedMethodName fSubstitutionMethod;

    public SubstituteResultIfFlaggedDirective(String source, int lineNumber, FlagName flagName, IMethodName sourceMethod, FullyQualifiedMethodName substitutionMethod) throws InvalidDirectiveException {
        super(source, lineNumber);
        this.validateParameters(sourceMethod, substitutionMethod);
        this.fFlagName = flagName;
        this.fSourceMethod = sourceMethod;
        this.fSubstitutionMethod = substitutionMethod;
    }

    private void validateParameters(IMethodName sourceMethod, FullyQualifiedMethodName substitutionMethod) throws InvalidDirectiveException {
        IMethodSignature sourceDescriptor = sourceMethod.getSignature();
        IMethodSignature substitutionDescriptor = substitutionMethod.getMethodName().getSignature();
        if (substitutionDescriptor.getParameterCount() != 1) {
            throw new InvalidDirectiveException(kMethodMustHaveExactlyOneParameterMessage + substitutionMethod.getMethodName().getNameAndSignatureString(), (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Exception_Parsing_Substitute_Result_One_Parameter_Only", substitutionMethod.getMethodName().getNameAndSignatureString(), false));
        }
        ISlotSignature substitutionParameter = substitutionDescriptor.getParameterSignatureByIndex(0);
        if (!substitutionParameter.isAnyReference()) {
            throw new InvalidDirectiveException(kParameterMustBeObjectReferenceMessage + substitutionMethod.getMethodName().getNameAndSignatureString(), (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Exception_Parsing_Substitute_Result_Parameter_Must_Be_Object_Reference", substitutionMethod.getMethodName().getNameAndSignatureString(), false));
        }
        ISlotSignature substitutionReturnType = substitutionDescriptor.getReturnSlotSignature();
        if (!substitutionParameter.equals(substitutionReturnType)) {
            throw new InvalidDirectiveException(kParameterAndReturnTypeMustMatchMessage + substitutionMethod.getMethodName().getNameAndSignatureString(), (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Exception_Parsing_Substitute_Result_Parameter_And_Return_Type_Must_Match", substitutionMethod.getMethodName().getNameAndSignatureString(), false));
        }
        ISlotSignature sourceReturnType = sourceDescriptor.getReturnSlotSignature();
        if (!substitutionReturnType.equals(sourceReturnType)) {
            throw new InvalidDirectiveException(kReturnTypesMustMatchMessage, (ILocalizableMessage)new SimpleLocalizableMessage("Diagnos_Exception_Parsing_Substitute_Result_Return_Types_Must_Match"));
        }
    }

    private FlagName getFlagName() {
        return this.fFlagName;
    }

    private IMethodName getSourceMethod() {
        return this.fSourceMethod;
    }

    private FullyQualifiedMethodName getSubstitutionMethod() {
        return this.fSubstitutionMethod;
    }

    protected void applyToSettings(CompilerSettingsBuilder builder) {
        TracerGroupBuilder tracerGroupBuilder = builder.getTracerGroupBuilder(this.getFlagName());
        builder.addTransformation(new SubstituteObjRefResultTransformationBuilder(tracerGroupBuilder, this.getSourceMethod(), this.getSubstitutionMethod()));
        tracerGroupBuilder.setSource(this.getSource());
    }
}

