/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives.apply;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class PersistenceFileLockHelper {
    private static File file;
    private static FileChannel channel;
    private static IAgent fAgent;
    private static FileLock fLock;
    public static volatile boolean initializeSuccessful;
    private static boolean initializeExceptionLogFlag;

    static {
        fLock = null;
        initializeSuccessful = false;
        initializeExceptionLogFlag = false;
    }

    public static void initialize(IAgent Agent) {
        fAgent = Agent;
        String path = null;
        try {
            try {
                path = PersistenceFileLockHelper.getInstallationPath();
                if (path != null) {
                    file = new File(String.valueOf(path) + "/" + "AutoPersist.lock");
                }
                if (file != null) {
                    channel = new RandomAccessFile(file, "rw").getChannel();
                }
                if (channel != null) {
                    initializeSuccessful = true;
                }
            }
            catch (FileNotFoundException e) {
                if (!initializeExceptionLogFlag) {
                    fAgent.IAgent_getModuleFeedback().error("Cannot create the lock file in " + path + ". Please enable write permissions to this folder for entry point detection to work.");
                    if (fAgent != null && fAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                        fAgent.IAgent_getModuleFeedback().debug("Cannot create the lock file in " + path + " " + e.getStackTrace());
                    }
                    initializeExceptionLogFlag = true;
                }
                if (!initializeSuccessful) {
                    if (!initializeExceptionLogFlag) {
                        fAgent.IAgent_getModuleFeedback().error("Cannot create the lock file for persistence api in " + path + " .Entry point detection will not work.");
                        initializeExceptionLogFlag = true;
                    }
                } else {
                    fAgent.IAgent_getModuleFeedback().info("Lock File created in " + path);
                }
            }
            catch (Exception e) {
                fAgent.IAgent_getModuleFeedback().error("Cannot create the lock file for persistence api in " + path + " .Entry point detection will not work.");
                if (fAgent != null && fAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                    fAgent.IAgent_getModuleFeedback().debug("Cannot create the lock file for persistence api in " + path + " .Entry point detection will not work." + e.getStackTrace());
                }
                initializeExceptionLogFlag = true;
                if (!initializeSuccessful) {
                    if (!initializeExceptionLogFlag) {
                        fAgent.IAgent_getModuleFeedback().error("Cannot create the lock file for persistence api in " + path + " .Entry point detection will not work.");
                        initializeExceptionLogFlag = true;
                    }
                } else {
                    fAgent.IAgent_getModuleFeedback().info("Lock File created in " + path);
                }
            }
        }
        finally {
            if (!initializeSuccessful) {
                if (!initializeExceptionLogFlag) {
                    fAgent.IAgent_getModuleFeedback().error("Cannot create the lock file for persistence api in " + path + " .Entry point detection will not work.");
                    initializeExceptionLogFlag = true;
                }
            } else {
                fAgent.IAgent_getModuleFeedback().info("Lock File created in " + path);
            }
        }
    }

    public static void acquireExclusiveLock() throws IOException {
        fLock = channel.lock();
    }

    public static void acquireSharedLock() throws IOException {
        fLock = channel.lock(0L, Long.MAX_VALUE, true);
    }

    public static FileLock trySharedLock() throws IOException {
        fLock = channel.tryLock(0L, Long.MAX_VALUE, true);
        return fLock;
    }

    public static FileLock tryExclusiveLock() throws IOException {
        fLock = channel.tryLock(0L, Long.MAX_VALUE, false);
        return fLock;
    }

    public static boolean hasLock() {
        return fLock != null;
    }

    public static boolean isLockValid() {
        return fLock.isValid();
    }

    public static void releaseLock() throws IOException {
        if (fLock != null) {
            fLock.release();
        }
    }

    private static String getInstallationPath() {
        String[] directivesList = AutoProbeTransformer.getDirectivesFileList();
        int i = 0;
        while (i < directivesList.length) {
            if (directivesList[i].endsWith("hotdeploy")) {
                return directivesList[i];
            }
            ++i;
        }
        return null;
    }
}

