/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.log;

import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IMethodName;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CompilerLogDetails {
    public static final CompilerLogDetails kNullLogDetails = new CompilerLogDetails();
    public static final CompilerLogDetails kSinkLogDetails = new CompilerLogDetails();
    public static final String kNormalMessageForClass = "Normal Processing class";
    public static final String kNormalMessageForModeledClass = "Normal Processing Modelled Class";
    public static final String kNormalMessageForModeledClassAndMethod = "Normal Processing Modelled Class and Modelled Method";
    public static final String kNormalMessageForMatchingClass = "Normal Processing class";
    public static final String kNormalMessageForModeledMethod = "Normal Processing Modelled Method";
    public static final String kSkippingBootstrapClass = "Skipping bootstrap class";
    public static final String kSkippingEmptyNameClass = "Skipping class with null name";
    private static final String kReturn = "\n";
    public static final int kNoSkip = 0;
    public static final int kSkipClasses = 1;
    public static final int kSkipFilterForClasses = 2;
    public static final int kSkipContainer = 4;
    public static final int kSkipContainerPrefix = 8;
    public static final int kSkipPackage = 16;
    public static final int kSkipFilterForClassPackage = 32;
    public static final int kSkipPackagePrefix = 64;
    public static final int kSkipAllClassMatcher = 128;
    public static final int kSkipAnnotationClassMatcher = 256;
    public static final int kSkipCorbaClassMatcher = 512;
    public static final int kSkipExactClassMatcher = 1024;
    public static final int kSkipGlobClassMatcher = 2048;
    public static final int kSkipInheritedClassMatcher = 4096;
    public static final int kSkipMethodAllExceptContructorMatches = 8192;
    public static final int kSkipAnnotationMethosMatcher = 16384;
    public static final int kSkipComplexMethodMatcher = 32768;
    public static final int kSkipInstanceContructorMatcher = 65536;
    public static final int kSkipNamedMethodMatcher = 131072;
    public static final int kSkipRemoteMethodMatcher = 262144;
    public static final int kSkipBootstrapClass = 524488;
    public static final int kSkipStaticMethodMatcher = 0x100000;
    public static final int kSkipGlobMethodMatcher = 0x200000;
    public static final String kCommentAnnotationClassMatcher = "DGAnnotationClassMatcher detected the annotation name as annotation in the modelled class";
    private String fGenericMessage;
    private Date fCreationTime = new Date();
    private String fClassName;
    private String fMethodName;
    private int fSkipCause = 0;
    private String fNormalizedClassName;
    private String fContainerName;
    private String fContainerPrefix;
    private String fClassPackage;
    private String kFilterForClasses;
    private String kFilterForClassPackage;
    private String kPackagePrefix;
    private Boolean fCheckClass;
    private String fAnnotationClassName;
    private String fComment;
    private String fCorbaName;
    private IClassName fExactMatchPattern;
    private IClassName fInheritedClassName;
    private IMethodName fMethodMatchName;

    CompilerLogDetails() {
    }

    CompilerLogDetails(String className, String message) {
        this();
        this.fClassName = className;
        this.fGenericMessage = message;
    }

    CompilerLogDetails(String className, String methodName, String message) {
        this(className, message);
        this.fMethodName = message;
    }

    public static CompilerLogDetails getNullObject() {
        return kNullLogDetails;
    }

    public String getDetailsString() {
        StringBuffer result = new StringBuffer();
        result.append("fClassName: ").append(this.fClassName).append(kReturn);
        result.append("fMethodName: ").append(this.fMethodName).append(kReturn);
        result.append("fGenericMessage: ").append(this.fGenericMessage).append(kReturn);
        return result.toString();
    }

    public void setNormalizedClassName(String fNormalizedClassName) {
        this.fNormalizedClassName = fNormalizedClassName;
    }

    public String getNormalizedClassName() {
        return this.fNormalizedClassName;
    }

    public void setSkipCause(int cause) {
        this.fSkipCause = cause;
    }

    public void setContainerName(String containerName) {
        this.fContainerName = containerName;
    }

    public void setContainerPrefix(String prefix) {
        this.fContainerPrefix = prefix;
    }

    public void setClassPackage(String classPackage) {
        this.fClassPackage = classPackage;
    }

    public void setFilterForClasses(String filterForClasses) {
        this.kFilterForClasses = filterForClasses;
    }

    public void setFilterForClassPackage(String filterForClassPackage) {
        this.kFilterForClassPackage = filterForClassPackage;
    }

    public void setPackagePrefix(String prefix) {
        this.kPackagePrefix = prefix;
    }

    public void setCheckClassAlso(Boolean checkClass) {
        this.fCheckClass = checkClass;
    }

    public void setAnnotationName(String string) {
        this.fAnnotationClassName = string;
    }

    public void setComment(String comment) {
        this.fComment = comment;
    }

    public void setCorbaName(String corbaName) {
        this.fCorbaName = corbaName;
    }

    public void setExactClassMatcherPattern(IClassName pattern) {
        this.fExactMatchPattern = pattern;
    }

    public void setInheritedClassName(IClassName className) {
        this.fInheritedClassName = className;
    }

    public String getClassName() {
        return this.fClassName;
    }

    public void setMethodMatchName(IMethodName name) {
        this.fMethodMatchName = name;
    }

    public boolean isSkip() {
        return this.fSkipCause > 0;
    }

    public String getMethodName() {
        return this.fMethodName;
    }

    public int getSkipCause() {
        return this.fSkipCause;
    }

    public Date getCreationTime() {
        return this.fCreationTime;
    }

    public Map getDetails() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.fNormalizedClassName != null) {
            result.put("Normalized Class Name", this.fNormalizedClassName);
        }
        if (this.fContainerName != null) {
            result.put("Container Name from directives", this.fContainerName);
        }
        if (this.fContainerPrefix != null) {
            result.put("Container prefix from directives", this.fContainerPrefix);
        }
        if (this.fClassPackage != null) {
            result.put("Class Package from directives", this.fClassPackage);
        }
        if (this.kFilterForClasses != null) {
            result.put("Filter for classes from directives", this.kFilterForClasses);
        }
        if (this.kFilterForClassPackage != null) {
            result.put("Filter for class package from directives", this.kFilterForClassPackage);
        }
        if (this.kFilterForClassPackage != null) {
            result.put("Filter for class package from directives", this.kFilterForClassPackage);
        }
        if (this.kFilterForClassPackage != null) {
            result.put("Filter for class package from directives", this.kFilterForClassPackage);
        }
        if (this.kPackagePrefix != null) {
            result.put("Package prefix from directives", this.kPackagePrefix);
        }
        if (this.fAnnotationClassName != null) {
            result.put("Annotation class name from directives", this.fAnnotationClassName);
        }
        if (this.fCorbaName != null) {
            result.put("Corba class name", this.fCorbaName);
        }
        if (this.fExactMatchPattern != null) {
            result.put("Class name pattern matched", this.fExactMatchPattern.getReflectionFriendlyQualifiedNameString());
        }
        if (this.fMethodMatchName != null) {
            result.put("Method name pattern matched", this.fMethodMatchName.getNameAndSignatureString());
        }
        if (this.fInheritedClassName != null) {
            result.put("Class name that class inherit from", this.fInheritedClassName.getReflectionFriendlyQualifiedNameString());
        }
        return result;
    }

    public static void logImmediately(ICompilerLog targetLog, String className, String methodName, String message, int cause) {
        CompilerLogDetails details = new CompilerLogDetails(className, methodName, message);
        details.setSkipCause(cause);
        targetLog.ICompilerLog_logDetails(details);
    }
}

